/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.RemoveUnsupportedTagOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class UnsupportedTagResolution
extends WorkbenchMarkerResolution {
    protected IMarker fBackingMarker = null;
    private boolean plural = false;

    public UnsupportedTagResolution(IMarker marker) {
        this.fBackingMarker = marker;
    }

    public String getDescription() {
        if (this.plural) {
            return MarkerMessages.UnsupportedTagResolution_remove_unsupported_tags;
        }
        return this.getLabel();
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_ELCL_REMOVE");
    }

    public String getLabel() {
        if (this.plural) {
            return this.getDescription();
        }
        try {
            String arg = (String)this.fBackingMarker.getAttribute("messagearguments");
            String[] args = arg.split("#");
            return NLS.bind((String)MarkerMessages.UnsupportedTagResolution_remove_unsupported_tag, (Object[])new String[]{args[0]});
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void run(IMarker marker) {
        RemoveUnsupportedTagOperation op = new RemoveUnsupportedTagOperation(new IMarker[]{marker});
        op.schedule();
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        RemoveUnsupportedTagOperation op = new RemoveUnsupportedTagOperation(markers);
        op.schedule();
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> mset = new HashSet<IMarker>(markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (Util.isApiProblemMarker((IMarker)marker) && !this.fBackingMarker.equals((Object)marker) && marker.getAttribute("apiMarkerID", -1) == 6) {
                mset.add(marker);
            }
            ++n2;
        }
        int size = mset.size();
        this.plural = size > 0;
        return mset.toArray(new IMarker[size]);
    }
}

