/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.aut;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.rcptt.ecl.client.tcp.EclTcpClientManager;
import org.eclipse.rcptt.ecl.runtime.ISession;
import org.eclipse.rcptt.internal.core.WorkspaceMonitor;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.aut.AutLaunchStorage;
import org.eclipse.rcptt.internal.launching.aut.AutStorage;
import org.eclipse.rcptt.internal.launching.aut.BaseAut;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.internal.launching.aut.IBaseAutLaunchRetarget;
import org.eclipse.rcptt.internal.launching.aut.OutputCaptureListener;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutLaunchState;
import org.eclipse.rcptt.launching.AutListener;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.ILaunchExecutor;

public enum BaseAutManager implements AutManager,
ILaunchConfigurationListener,
ILaunchesListener,
ILaunchesListener2,
IDebugEventSetListener
{
    INSTANCE;

    private Map<String, ILaunchExecutor> executors;
    private AutStorage auts = new AutStorage();
    private AutLaunchStorage launches = new AutLaunchStorage();
    private CopyOnWriteArrayList<AutListener> listeners = new CopyOnWriteArrayList();
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_TYPE = "type";
    private static final String EXTPT_EXECUTORS = "org.eclipse.rcptt.launching.executors";

    private BaseAutManager() {
        this.executors = BaseAutManager.readExecutors();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        manager.addLaunchListener((ILaunchesListener)this);
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.addDebugEventListener((IDebugEventSetListener)this);
        this.addListener(new OutputCaptureListener());
        for (Map.Entry<String, ILaunchExecutor> entry : this.executors.entrySet()) {
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(entry.getKey());
            try {
                ILaunchConfiguration[] configs;
                ILaunchConfiguration[] iLaunchConfigurationArray = configs = manager.getLaunchConfigurations(type);
                int n2 = configs.length;
                int n3 = 0;
                while (n3 < n2) {
                    ILaunchConfiguration config = iLaunchConfigurationArray[n3];
                    this.addAut(config, entry.getValue());
                    ++n3;
                }
            }
            catch (CoreException e) {
                Q7LaunchingPlugin.log("Couldn't load base AUTs", e);
            }
        }
        this.launchesAdded(manager.getLaunches());
    }

    @Override
    public List<Aut> getAuts() {
        return this.auts.getAll();
    }

    @Override
    public List<AutLaunch> getLaunches() {
        return this.launches.getAll();
    }

    @Override
    public BaseAut getByName(String name) {
        return this.auts.getByName(name);
    }

    @Override
    public AutLaunch getById(String id) {
        return this.launches.getById(id);
    }

    @Override
    public BaseAut getByLaunch(ILaunchConfiguration config) {
        BaseAut result = this.auts.getByLaunch(config);
        if (result == null) {
            this.launchConfigurationAdded(config);
            return this.auts.getByLaunch(config);
        }
        return result;
    }

    @Override
    public BaseAutLaunch getByLaunch(ILaunch launch) {
        return this.launches.getByLaunch(launch);
    }

    public List<AutLaunch> getLaunches(BaseAut aut) {
        return this.launches.getByAut(aut);
    }

    public BaseAutLaunch getCurrentLaunch(BaseAut aut) {
        return this.launches.getCurrent(aut);
    }

    public void launchConfigurationAdded(ILaunchConfiguration config) {
        ILaunchExecutor executor = this.getExecutor(config);
        if (executor != null) {
            this.addAut(config, executor);
        }
    }

    public void launchConfigurationRemoved(ILaunchConfiguration config) {
        BaseAut aut = this.auts.removeByLaunch(config);
        if (aut != null) {
            for (AutListener listener : this.listeners) {
                listener.autRemoved(aut);
            }
            List<AutLaunch> list = this.launches.getByAut(aut);
            for (AutLaunch autLaunch : list) {
                if (!this.launches.remove((BaseAutLaunch)autLaunch)) continue;
                for (AutListener listener : this.listeners) {
                    listener.launchRemoved(autLaunch);
                }
                autLaunch.shutdown();
            }
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration config) {
        BaseAut aut = this.auts.getByLaunch(config);
        if (aut == null) {
            return;
        }
        for (AutListener listener : this.listeners) {
            listener.autChanged(aut);
        }
    }

    public void launchesAdded(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            BaseAut aut = this.auts.getByLaunch(launch);
            if (aut != null && !this.handleRestart(launch)) {
                BaseAutLaunch.Context context = new BaseAutLaunch.Context(){

                    @Override
                    public ISession connect(String host, int port) throws IOException {
                        return EclTcpClientManager.Instance.startClientSession(InetAddress.getByName(host), port);
                    }
                };
                BaseAutLaunch autLaunch = new BaseAutLaunch(launch, aut, context);
                this.launches.add(autLaunch);
                for (AutListener listener : this.listeners) {
                    listener.launchAdded(autLaunch);
                }
            }
            ++n2;
        }
    }

    private boolean handleRestart(ILaunch launch) {
        String id = BaseAutManager.getRestartId(launch.getLaunchConfiguration());
        if (id != null) {
            BaseAutLaunch aut = this.launches.getById(id);
            if (aut == null) {
                Q7LaunchingPlugin.log("No AUT launch found for launch: " + String.valueOf(launch) + " with id = " + id);
            } else {
                ILaunch oldLaunch = aut.setLaunch(launch);
                this.launches.replaceLaunch(aut, launch, oldLaunch);
            }
            return true;
        }
        return false;
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            BaseAutLaunch autLaunch;
            ILaunch launch = iLaunchArray[n2];
            BaseAut aut = this.auts.getByLaunch(launch);
            if (aut != null && (autLaunch = this.launches.getByLaunch(launch)) != null && autLaunch.getState() != AutLaunchState.RESTART) {
                autLaunch.terminated(0);
                if (this.launches.remove(autLaunch)) {
                    for (AutListener listener : this.listeners) {
                        listener.launchRemoved(autLaunch);
                    }
                }
            }
            ++n2;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            BaseAutLaunch aut = this.launches.getByLaunch(launch);
            if (aut != null) {
                aut.terminated(Status.OK_STATUS);
                if (this.launches.remove(aut)) {
                    for (AutListener listener : this.listeners) {
                        listener.launchRemoved(aut);
                    }
                }
            }
            ++n2;
        }
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    @Override
    public void addListener(AutListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeListener(AutListener listener) {
        this.listeners.remove(listener);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess process;
            ILaunch launch;
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            if (source instanceof IProcess && event.getKind() == 8 && (launch = (process = (IProcess)source).getLaunch()) != null) {
                try {
                    BaseAutLaunch aut = this.launches.getByLaunch(launch);
                    if (aut != null) {
                        aut.terminateProcess(process.getExitValue());
                    }
                }
                catch (DebugException e) {
                    Q7LaunchingPlugin.log(e.getStatus());
                }
            }
            ++n2;
        }
    }

    private ILaunchExecutor getExecutor(ILaunchConfiguration config) {
        try {
            String id = config.getType().getIdentifier();
            return this.executors.get(id);
        }
        catch (CoreException e) {
            return null;
        }
    }

    private void addAut(ILaunchConfiguration config, ILaunchExecutor executor) {
        IFile file = config.getFile();
        if (file != null && WorkspaceMonitor.isIgnored((IResource)file)) {
            return;
        }
        BaseAut aut = new BaseAut(config, executor);
        this.auts.add(aut);
        for (AutListener listener : this.listeners) {
            listener.autAdded(aut);
        }
    }

    private static String getRestartId(ILaunchConfiguration config) {
        if (config != null) {
            try {
                String id;
                if (config.getAttribute("restart", false) && !(id = config.getAttribute("org.eclipse.rcptt.launching.ATTR_AUT_LAUNCH_ID", "")).isEmpty()) {
                    return id;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Map<String, ILaunchExecutor> readExecutors() {
        IConfigurationElement[] configs;
        HashMap<String, ILaunchExecutor> executors = new HashMap<String, ILaunchExecutor>();
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTPT_EXECUTORS);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                ILaunchExecutor executor = (ILaunchExecutor)config.createExecutableExtension(ATTR_CLASS);
                String type = config.getAttribute(ATTR_TYPE);
                executors.put(type, executor);
            }
            catch (Exception e) {
                StringBuilder builder = new StringBuilder();
                builder.append("Problem while loading '");
                builder.append(EXTPT_EXECUTORS);
                builder.append("' extension");
                try {
                    String plugin = config.getNamespaceIdentifier();
                    builder.append(" from the '");
                    builder.append(plugin);
                    builder.append("' plugin");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                builder.append(": ");
                builder.append(e.getMessage());
                Q7LaunchingPlugin.log(builder.toString(), e);
            }
            ++n2;
        }
        return executors;
    }

    @Override
    public List<AutLaunch> storeAUTLaunches(ILaunchConfiguration configuration) {
        BaseAut aut = this.getByLaunch(configuration);
        if (aut != null) {
            return aut.getLaunches();
        }
        return null;
    }

    @Override
    public void updateAUTLaunches(ILaunchConfiguration newConfig, List<AutLaunch> launches) {
        BaseAut launch = this.getByLaunch(newConfig);
        if (launch != null) {
            for (AutLaunch autLaunch : launches) {
                if (!(autLaunch instanceof BaseAutLaunch) || !(autLaunch instanceof IBaseAutLaunchRetarget)) continue;
                ((IBaseAutLaunchRetarget)((Object)autLaunch)).retarget(launch);
                this.launches.remove((BaseAutLaunch)autLaunch);
                this.launches.add((BaseAutLaunch)autLaunch);
            }
        }
    }

    public void handleRestart(BaseAutLaunch aut, ILaunch oldLaunch, ILaunch launch) {
        this.launches.replaceLaunch(aut, launch, oldLaunch);
    }
}

