/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.launching.events;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Platform implements Enumerator
{
    OTHER(0, "Other", "Other"),
    MAC_OS(1, "MacOs", "MacOs"),
    WINDOWS(2, "Windows", "Windows"),
    LINUX(3, "Linux", "Linux");

    public static final int OTHER_VALUE = 0;
    public static final int MAC_OS_VALUE = 1;
    public static final int WINDOWS_VALUE = 2;
    public static final int LINUX_VALUE = 3;
    private static final Platform[] VALUES_ARRAY;
    public static final List<Platform> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Platform[]{OTHER, MAC_OS, WINDOWS, LINUX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Platform get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Platform result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Platform getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Platform result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Platform get(int value) {
        switch (value) {
            case 0: {
                return OTHER;
            }
            case 1: {
                return MAC_OS;
            }
            case 2: {
                return WINDOWS;
            }
            case 3: {
                return LINUX;
            }
        }
        return null;
    }

    private Platform(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

