/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.gef;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerFigure;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ConnectionCreationTool;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.TeslaMessages;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.Assert;
import org.eclipse.rcptt.tesla.core.protocol.AssertKind;
import org.eclipse.rcptt.tesla.core.protocol.BooleanResponse;
import org.eclipse.rcptt.tesla.core.protocol.ChildrenResponse;
import org.eclipse.rcptt.tesla.core.protocol.DragCommand;
import org.eclipse.rcptt.tesla.core.protocol.ElementCommand;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GetBounds;
import org.eclipse.rcptt.tesla.core.protocol.GetPropertyValue;
import org.eclipse.rcptt.tesla.core.protocol.GetRegionText;
import org.eclipse.rcptt.tesla.core.protocol.GetText;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.ObjectResponse;
import org.eclipse.rcptt.tesla.core.protocol.ParentResponse;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolPackage;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectData;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.diagram.ActivateDirectEdit;
import org.eclipse.rcptt.tesla.core.protocol.diagram.AssertFigureExists;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CancelDirectEdit;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CommitDirectEdit;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CreateConnection;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CreateConnectionResponse;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CreateFigure;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CreateFigureResponse;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramFactory;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramPackage;
import org.eclipse.rcptt.tesla.core.protocol.diagram.FigureMouseCommand;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommand;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommandKind;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MoveFigure;
import org.eclipse.rcptt.tesla.core.protocol.diagram.ResizeFigure;
import org.eclipse.rcptt.tesla.core.protocol.diagram.SetFigureSelection;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.core.ui.DiagramItem;
import org.eclipse.rcptt.tesla.gef.AutoExpandLevels;
import org.eclipse.rcptt.tesla.gef.DNDSupport;
import org.eclipse.rcptt.tesla.gef.DiagramViewerUIElement;
import org.eclipse.rcptt.tesla.gef.DirectEditorContainer;
import org.eclipse.rcptt.tesla.gef.EditPartChangeCollector;
import org.eclipse.rcptt.tesla.gef.FigureElementMapper;
import org.eclipse.rcptt.tesla.gef.FigureUIElement;
import org.eclipse.rcptt.tesla.gef.GefActivator;
import org.eclipse.rcptt.tesla.gef.GefModelMapper;
import org.eclipse.rcptt.tesla.gef.GefUtils;
import org.eclipse.rcptt.tesla.gef.IGefReplayHelper;
import org.eclipse.rcptt.tesla.gef.PaletteUIElement;
import org.eclipse.rcptt.tesla.gef.PropertySourceBasedModelMapper;
import org.eclipse.rcptt.tesla.gef.RawFigureElementMapper;
import org.eclipse.rcptt.tesla.gef.RawFigureUIElement;
import org.eclipse.rcptt.tesla.gef.TeslaDirectEditManager;
import org.eclipse.rcptt.tesla.gef.TeslaGefAccess;
import org.eclipse.rcptt.tesla.gef.TeslaGefMessages;
import org.eclipse.rcptt.tesla.gef.describers.EditPartDescriber;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.SimpleCommandPrinter;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.core.info.InfoUtils;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.tesla.internal.ui.IBasicMappingNode;
import org.eclipse.rcptt.tesla.internal.ui.SWTElementMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.internal.ui.processors.IModelMapperHelper;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.rcptt.tesla.swt.util.IdentifyObjectUtil;
import org.eclipse.rcptt.tesla.ui.describers.IWidgetDescriber;
import org.eclipse.rcptt.util.Function;
import org.eclipse.rcptt.util.ListUtil;
import org.eclipse.rcptt.util.Predicate;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public class GefProcessor
implements ITeslaCommandProcessor,
IModelMapperHelper {
    private final EClass[] commandsSupported = new EClass[]{DiagramPackage.Literals.CREATE_FIGURE, DiagramPackage.Literals.MOVE_FIGURE, DiagramPackage.Literals.GET_FIGURES, DiagramPackage.Literals.SET_FIGURE_SELECTION, DiagramPackage.Literals.ACTIVATE_DIRECT_EDIT, DiagramPackage.Literals.COMMIT_DIRECT_EDIT, DiagramPackage.Literals.CANCEL_DIRECT_EDIT, DiagramPackage.Literals.CREATE_CONNECTION, DiagramPackage.Literals.RESIZE_FIGURE, DiagramPackage.Literals.MOUSE_COMMAND, DiagramPackage.Literals.FIGURE_MOUSE_COMMAND, DiagramPackage.Literals.ASSERT_FIGURE_EXISTS, ProtocolPackage.Literals.ASSERT, ProtocolPackage.Literals.GET_TEXT, ProtocolPackage.Literals.PARENT, ProtocolPackage.Literals.CHILDREN, ProtocolPackage.Literals.DRAG_COMMAND, ProtocolPackage.Literals.GET_REGION_TEXT, ProtocolPackage.Literals.GET_BOUNDS};
    private AbstractTeslaClient client;
    private final Map<Widget, DirectEditorContainer> openedDirectEdits = new HashMap<Widget, DirectEditorContainer>();
    private String id;
    private final Set<EditPart> dragParts = new HashSet<EditPart>();
    EditPartViewer.Conditional findAtCondition = new EditPartViewer.Conditional(){

        public boolean evaluate(EditPart editpart) {
            while (editpart != null) {
                if (GefProcessor.this.dragParts.contains(editpart)) {
                    return false;
                }
                editpart = editpart.getParent();
            }
            return true;
        }
    };

    public String getFeatureID() {
        return "org.eclipse.rcptt.tesla.gef";
    }

    public int getPriority() {
        return 250;
    }

    private SelectResponse toResponse(Element e) {
        SelectResponse response = ProtocolFactory.eINSTANCE.createSelectResponse();
        response.getElements().add((Object)e);
        return response;
    }

    private SWTUIProcessor getSWTProcessor() {
        return (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
    }

    public ITeslaCommandProcessor.PreExecuteStatus preExecute(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        Element element;
        DiagramViewerUIElement diagram;
        SelectCommand cmd;
        SelectData data;
        Element element2;
        DiagramViewerUIElement diagram2;
        if (command instanceof SelectCommand && (diagram2 = this.getDiagram(element2 = (data = (cmd = (SelectCommand)command).getData()).getParent())) != null && !this.getSWTProcessor().activateViewEditor(this.getPlayer().wrap((Object)diagram2.getCanvas()), false, info)) {
            return new ITeslaCommandProcessor.PreExecuteStatus(false);
        }
        if ((command instanceof FigureMouseCommand || command instanceof MouseCommand) && (diagram = this.getDiagram(element = (cmd = (ElementCommand)command).getElement())) != null && !this.getSWTProcessor().activateViewEditor(this.getPlayer().wrap((Object)diagram.getCanvas()), false, info)) {
            return new ITeslaCommandProcessor.PreExecuteStatus(false);
        }
        return null;
    }

    public void initialize(AbstractTeslaClient client, String id) {
        this.client = client;
        this.id = id;
    }

    public boolean isCommandSupported(Command cmd) {
        ElementCommand elementCmd;
        Element element;
        EClass ecl = cmd.eClass();
        EClass[] eClassArray = this.commandsSupported;
        int n = this.commandsSupported.length;
        int n2 = 0;
        while (n2 < n) {
            EClass cl = eClassArray[n2];
            if (cl.equals(ecl)) {
                return true;
            }
            ++n2;
        }
        if (cmd instanceof ElementCommand && (element = (elementCmd = (ElementCommand)cmd).getElement()).getKind().equals(ElementKind.DiagramViewer.name())) {
            return this.getSWTProcessor().isCommandSupported((Command)elementCmd);
        }
        return false;
    }

    private static boolean skipModalDialogCheck(Command command) {
        if (command instanceof FigureMouseCommand) {
            MouseCommandKind kind = ((FigureMouseCommand)command).getKind();
            return kind == MouseCommandKind.UP || kind == MouseCommandKind.HOVER;
        }
        return false;
    }

    public Response executeCommand(Command command, IElementProcessorMapper mapper) {
        if (command instanceof GetBounds) {
            Element element = ((ElementCommand)command).getElement();
            FigureUIElement widget = (FigureUIElement)this.getMapper().get(element);
            org.eclipse.swt.graphics.Rectangle bounds = null;
            if (widget != null) {
                bounds = widget.getDiagram().getBounds();
            }
            return SWTUIProcessor.boundsResponse(bounds);
        }
        EClass eClass = command.eClass();
        EPackage pkg = eClass.getEPackage();
        Response response = null;
        DiagramViewerUIElement swtElement = null;
        if (command instanceof ElementCommand) {
            Element element = ((ElementCommand)command).getElement();
            swtElement = this.getDiagram(element);
            if (!GefProcessor.skipModalDialogCheck(command) && (response = SWTUIProcessor.checkForModalDialogs((SWTUIElement)swtElement)) != null) {
                return response;
            }
        }
        if (pkg.equals(DiagramPackage.eINSTANCE)) {
            switch (eClass.getClassifierID()) {
                case 0: {
                    response = this.handleCreateFigure((CreateFigure)command, mapper);
                    break;
                }
                case 3: {
                    response = this.handleSetFigureSelection((SetFigureSelection)command);
                    break;
                }
                case 6: {
                    response = this.handleActivateDirectEdit((ActivateDirectEdit)command, mapper);
                    break;
                }
                case 2: {
                    response = this.handleFigureMove((MoveFigure)command);
                    break;
                }
                case 11: {
                    response = this.handleFigureResize((ResizeFigure)command);
                    break;
                }
                case 8: {
                    response = this.handleCommitDirectEdit((CommitDirectEdit)command);
                    break;
                }
                case 7: {
                    response = this.handleCancelDirectEdit((CancelDirectEdit)command);
                    break;
                }
                case 9: {
                    response = this.handleCreateConnection((CreateConnection)command, mapper);
                    break;
                }
                case 12: {
                    response = this.handleMouseCommand((MouseCommand)command);
                    break;
                }
                case 13: {
                    response = this.handleFigureMouseCommand((FigureMouseCommand)command);
                    break;
                }
                case 14: {
                    response = this.handleAssertFigureExists((AssertFigureExists)command);
                }
            }
        }
        if (pkg.equals(ProtocolPackage.eINSTANCE)) {
            switch (eClass.getClassifierID()) {
                case 44: {
                    response = this.handleChildrenCommand((ElementCommand)command, mapper);
                    break;
                }
                case 46: {
                    response = this.handleParentCommand((ElementCommand)command, mapper);
                    break;
                }
                case 10: {
                    response = this.handleGetTextCommand((GetText)command);
                    break;
                }
                case 62: {
                    response = this.handleAssert((Assert)command);
                    break;
                }
                case 63: {
                    response = this.handleGetRegionText((GetRegionText)command);
                    break;
                }
                case 69: {
                    response = ((SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class)).getDragSupport().handleDrag((DragCommand)command);
                    break;
                }
                case 93: {
                    response = this.handleGetPropertyValue((GetPropertyValue)command);
                    break;
                }
                default: {
                    if (!(command instanceof ElementCommand) || swtElement == null) break;
                    ElementCommand redirectedCmd = this.getSWTProcessor().convertDiagramToCanvasCommand((ElementCommand)command, (Widget)swtElement.getCanvas());
                    response = this.getSWTProcessor().executeCommand((Command)redirectedCmd, mapper);
                }
            }
        }
        if (response != null) {
            return response;
        }
        return null;
    }

    protected Response handleGetPropertyValue(GetPropertyValue command) {
        Element element = command.getElement();
        if (element == null) {
            return null;
        }
        ObjectResponse result = ProtocolFactory.eINSTANCE.createObjectResponse();
        try {
            result.setResult(this.getPropertyValue(element, command.getName(), command.getIndex()));
        }
        catch (CoreException e) {
            result.setStatus(ResponseStatus.FAILED);
            result.setResult((Object)e.getStatus());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    private Object getPropertyValue(Element element, String property, Integer index) throws CoreException {
        FigureUIElement uiElement = (FigureUIElement)this.getMapper().get(element);
        RawFigureUIElement figureUiElement = (RawFigureUIElement)this.getFigureMapper().get(element);
        if (uiElement == null && figureUiElement == null) {
            return null;
        }
        Object model = uiElement != null ? this.getMappedModel(uiElement.getPart()) : GefModelMapper.figureMap(figureUiElement.getFigure());
        Object value = SWTUIProcessor.getAttrValue((EObject)model, (String)property, (Integer)index);
        if (value != null) {
            return value;
        }
        try {
            value = uiElement != null ? this.getPropertyValue(uiElement.getPart(), property) : GefModelMapper.getPropertyValue(figureUiElement.getFigure(), property);
            return value;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.tesla.swt", String.format("Failed to get propety '%s'", property), (Throwable)e));
        }
    }

    private Response handleGetRegionText(GetRegionText command) {
        SWTUIProcessor processor = (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
        Element element = command.getElement();
        FigureUIElement uiElement = (FigureUIElement)this.getMapper().get(element);
        if (uiElement == null) {
            return SWTUIProcessor.failResponse((String)TeslaGefMessages.CommandProcessor_CannotFindWidget);
        }
        EditPartDescriber describer = new EditPartDescriber(uiElement.getPart(), uiElement.getDiagram().getViewer());
        return processor.handleGetRegionText(command, (IWidgetDescriber)describer);
    }

    private Response handleAssert(Assert assertCmd) {
        SWTUIProcessor processor = (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
        Element element = assertCmd.getElement();
        FigureUIElement uiElement = (FigureUIElement)this.getMapper().get(element);
        RawFigureUIElement figureUiElement = (RawFigureUIElement)this.getFigureMapper().get(element);
        if (uiElement == null && figureUiElement == null) {
            return null;
        }
        if (assertCmd.getKind().equals((Object)AssertKind.CONTAINS_IMAGE) || assertCmd.getKind().equals((Object)AssertKind.IMAGE_CONTAINS_TEXT)) {
            return processor.doImageAssert(assertCmd, (IWidgetDescriber)new EditPartDescriber(uiElement.getPart(), uiElement.getDiagram().getViewer()));
        }
        Object model = uiElement != null ? this.getMappedModel(uiElement.getPart()) : GefModelMapper.figureMap(figureUiElement.getFigure());
        Object value = null;
        String attrValue = assertCmd.getValue();
        if (attrValue == null) {
            attrValue = "";
        }
        String attrName = assertCmd.getAttribute();
        if (!"property".equals(assertCmd.getCategory())) {
            value = SWTUIProcessor.getAttrValue((EObject)model, (String)attrName, (Integer)assertCmd.getIndex());
        }
        if (value == null) {
            try {
                value = uiElement != null ? this.getPropertyValue(uiElement.getPart(), attrName) : GefModelMapper.getPropertyValue(figureUiElement.getFigure(), attrName);
            }
            catch (Exception e) {
                Object reason = e.getMessage();
                if (reason == null || ((String)reason).length() == 0) {
                    StackTraceElement stackTraceElement = e.getStackTrace()[1];
                    reason = e.getClass().getSimpleName() + " in " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
                }
                reason = NLS.bind((String)TeslaGefMessages.GefProcessor_AssertFailed, (Object)assertCmd.getAttribute()) + " " + (String)reason;
                return SWTUIProcessor.failResponse((String)reason);
            }
        }
        if (value == null) {
            return SWTUIProcessor.failResponse((String)NLS.bind((String)TeslaGefMessages.CommandProcessor_CannotFindProperty, (Object)attrName));
        }
        String strValue = value.toString();
        if (value instanceof EObject) {
            strValue = SimpleCommandPrinter.toString((EObject)((EObject)value), (boolean)true, (String[])new String[0]).trim();
        }
        return processor.performAssert(assertCmd, attrValue, value, strValue);
    }

    private org.eclipse.rcptt.tesla.core.ui.Widget getMappedModel(EditPart part) {
        EditPartViewer viewer;
        SWTUIPlayer player;
        SWTUIElement semanticParent;
        SWTUIProcessor processor = (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
        List helpers = this.client.getProcessors(IGefReplayHelper.class);
        org.eclipse.rcptt.tesla.core.ui.Widget model = null;
        if (model == null) {
            for (IGefReplayHelper helper : helpers) {
                model = helper.getModel(part);
            }
        }
        if ((semanticParent = (player = processor.getPlayer()).getParentElement(player.wrap((Object)(viewer = part.getViewer()).getControl()))) instanceof WorkbenchUIElement) {
            DiagramItem map = GefModelMapper.basicMap(part);
            if (PropertySourceBasedModelMapper.map(((WorkbenchUIElement)semanticParent).reference.getPart(true), part, map)) {
                model = map;
            }
        }
        if (model == null) {
            model = GefModelMapper.map(part, this.getPlayer());
        }
        return model;
    }

    public String getPropertyValue(EditPart part, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String value;
        EditPartViewer viewer;
        SWTUIProcessor processor = (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
        SWTUIPlayer player = processor.getPlayer();
        SWTUIElement semanticParent = player.getParentElement(player.wrap((Object)(viewer = part.getViewer()).getControl()));
        if (semanticParent instanceof WorkbenchUIElement && PropertySourceBasedModelMapper.isPropertyBasedMapped(((WorkbenchUIElement)semanticParent).reference.getPart(true), part) && (value = PropertySourceBasedModelMapper.getPropertyValue(((WorkbenchUIElement)semanticParent).reference.getPart(true), part, nodePath)) != null) {
            return value;
        }
        List helpers = this.client.getProcessors(IGefReplayHelper.class);
        for (IGefReplayHelper helper : helpers) {
            if (!helper.isGMFMapped(part)) continue;
            return helper.getPropertyValue(part, nodePath);
        }
        return GefModelMapper.getPropertyValue(part, nodePath);
    }

    private Response handleAssertFigureExists(AssertFigureExists command) {
        Element element = command.getElement();
        DiagramViewerUIElement diagram = this.getDiagram(element);
        RootEditPart part = diagram.getViewer().getRootEditPart();
        EditPart requiredPart = this.getPart((List<Integer>)command.getPartPath(), (EditPart)part);
        if (requiredPart == null) {
            RootEditPart te = part;
            for (Integer integer : command.getPartPath()) {
                List children = GefProcessor.filterFigures(te.getChildren());
                if (children.size() <= integer) break;
                System.out.println("Failed parts:" + te.getClass().getName());
                te = (EditPart)children.get(integer);
            }
            Response response = RawFactory.eINSTANCE.createResponse();
            response.setStatus(ResponseStatus.FAILED);
            return response;
        }
        Response response = RawFactory.eINSTANCE.createResponse();
        response.setStatus(ResponseStatus.OK);
        return response;
    }

    private Response handleMouseCommand(final MouseCommand command) {
        Element element = command.getElement();
        DiagramViewerUIElement diagram = this.getDiagram(element);
        if (diagram == null) {
            return null;
        }
        final EventDispatcher dispatcher = diagram.getDispatcher();
        Event e = new Event();
        final Canvas canvas = diagram.getCanvas();
        e.widget = canvas;
        e.time = (int)System.currentTimeMillis();
        e.x = command.getX();
        e.y = command.getY();
        e.stateMask = command.getStateMask();
        e.button = command.getButton();
        final org.eclipse.swt.graphics.Rectangle oldBounds = canvas.getBounds();
        final MouseEvent mouseEvent = new MouseEvent(e);
        this.getPlayer().exec("Set bounds and location", new Runnable(){

            @Override
            public void run() {
                if (command.getBoundsHeight() != 0 && command.getBoundsWidth() != 0) {
                    canvas.setRedraw(false);
                    canvas.setBounds(0, 0, command.getBoundsWidth(), command.getBoundsHeight());
                }
            }
        });
        this.getPlayer().exec("Tesla Gef runnable", new Runnable(){

            @Override
            public void run() {
                GefProcessor.this.getPlayer().addMouseWidgetInfo((Widget)canvas, mouseEvent.x, mouseEvent.y);
                switch (command.getKind()) {
                    case DOWN: {
                        dispatcher.dispatchMousePressed(mouseEvent);
                        break;
                    }
                    case ENTER: {
                        dispatcher.dispatchMouseEntered(mouseEvent);
                        break;
                    }
                    case EXIT: {
                        dispatcher.dispatchMouseExited(mouseEvent);
                        break;
                    }
                    case UP: {
                        dispatcher.dispatchMouseReleased(mouseEvent);
                        break;
                    }
                    case MOVE: {
                        mouseEvent.stateMask = 0;
                        dispatcher.dispatchMouseMoved(mouseEvent);
                        break;
                    }
                    case DRAG: {
                        mouseEvent.stateMask = SWT.BUTTON_MASK;
                        dispatcher.dispatchMouseMoved(mouseEvent);
                        break;
                    }
                    case HOVER: {
                        dispatcher.dispatchMouseHover(mouseEvent);
                        break;
                    }
                    case DOUBLE_CLICK: {
                        dispatcher.dispatchMouseDoubleClicked(mouseEvent);
                        break;
                    }
                    case NATIVE_DRAG_FINISHED: {
                        break;
                    }
                }
                canvas.setBounds(oldBounds);
                canvas.setRedraw(true);
            }

            private void mouseHoverExec(final EventDispatcher dispatcher2, final MouseEvent mouseEvent2, final int tryCount) {
                if (tryCount == 0) {
                    return;
                }
                GefProcessor.this.getPlayer().exec("One more hover event", new Runnable(){

                    @Override
                    public void run() {
                        dispatcher2.dispatchMouseHover(mouseEvent2);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        this.mouseHoverExec(dispatcher2, mouseEvent2, tryCount - 1);
                    }
                });
            }
        });
        return RawFactory.eINSTANCE.createResponse();
    }

    private Response handleFigureMouseCommand(FigureMouseCommand command) {
        Element element = command.getElement();
        DiagramViewerUIElement diagram = this.getDiagram(element);
        if (diagram == null) {
            return this.proceedFigureCanvas(command, element);
        }
        GraphicalViewer viewer = diagram.getViewer();
        Canvas canvas = diagram.getCanvas();
        FigureUIElement mapped = (FigureUIElement)this.getMapper().get(element);
        RawFigureUIElement rawMapped = null;
        GraphicalEditPart part = mapped != null ? (GraphicalEditPart)mapped.getPart() : ((rawMapped = (RawFigureUIElement)this.getRawMapper().get(element)) != null ? (GraphicalEditPart)rawMapped.getPart() : this.getEditPartFromPath((List<Integer>)command.getPartPath(), viewer));
        if (part == null && command.getPartPath().size() > 0) {
            return GefProcessor.createFailed(TeslaGefMessages.GefProcessor_CannotFindEditPart);
        }
        IFigure partFigure = null;
        partFigure = part != null ? part.getFigure() : diagram.getFigureContents();
        EList figurePath = command.getFigurePath();
        IFigure figure = rawMapped != null ? rawMapped.getFigure() : this.getFigure((List<Integer>)figurePath, partFigure, part);
        if (figure == null) {
            return GefProcessor.createFailed(TeslaGefMessages.GefProcessor_CannotFindFigure);
        }
        GraphicalEditPart finalPart = part;
        this.getPlayer().exec("Tesla Gef runnable", new Runnable((EditPart)finalPart, viewer, canvas, figure, command, part){
            private final /* synthetic */ EditPart val$finalPart;
            private final /* synthetic */ GraphicalViewer val$viewer;
            private final /* synthetic */ Canvas val$canvas;
            private final /* synthetic */ IFigure val$figure;
            private final /* synthetic */ FigureMouseCommand val$command;
            private final /* synthetic */ GraphicalEditPart val$part;
            {
                this.val$finalPart = editPart;
                this.val$viewer = graphicalViewer;
                this.val$canvas = canvas;
                this.val$figure = iFigure;
                this.val$command = figureMouseCommand;
                this.val$part = graphicalEditPart;
            }

            @Override
            public void run() {
                DrawerEditPart drawer;
                Point p;
                int horizontalBarVisibility = -1;
                int verticalBarVisibility = -1;
                if (this.val$finalPart != null) {
                    DrawerEditPart drawer2 = GefProcessor.this.findContainingDrawer(this.val$finalPart.getParent());
                    if (drawer2 != null) {
                        horizontalBarVisibility = GefProcessor.this.getDrawerFigure(drawer2).getScrollpane().getHorizontalScrollBarVisibility();
                        verticalBarVisibility = GefProcessor.this.getDrawerFigure(drawer2).getScrollpane().getVerticalScrollBarVisibility();
                        GefProcessor.this.getDrawerFigure(drawer2).getScrollpane().setHorizontalScrollBarVisibility(0);
                        GefProcessor.this.getDrawerFigure(drawer2).getScrollpane().setVerticalScrollBarVisibility(0);
                    }
                    this.val$viewer.reveal(this.val$finalPart);
                } else if (this.val$canvas instanceof FigureCanvas) {
                    GefProcessor.this.scrollToFigure((FigureCanvas)this.val$canvas, this.val$figure);
                }
                Dimension origMinSize = GefProcessor.this.getMinSize(this.val$figure);
                Dimension origMaxSize = GefProcessor.this.getMaxSize(this.val$figure);
                Dimension origSize = GefProcessor.this.getSize(this.val$figure);
                int recordedWidth = this.val$command.getFigureWidth();
                int recordedHeight = this.val$command.getFigureHeight();
                boolean isSizeChanged = false;
                if (recordedWidth != 0 && recordedHeight != 0 && (origSize.width != recordedWidth || origSize.height != recordedHeight)) {
                    try {
                        if (origMinSize != null) {
                            this.val$figure.setMinimumSize(new Dimension(recordedWidth, recordedHeight));
                        }
                        if (origMaxSize != null) {
                            this.val$figure.setMaximumSize(new Dimension(recordedWidth, recordedHeight));
                        }
                        this.val$figure.setSize(recordedWidth, recordedHeight);
                        this.val$figure.validate();
                        if (GefProcessor.this.getSize(this.val$figure) != null && GefProcessor.this.getSize((IFigure)this.val$figure).width == recordedWidth && GefProcessor.this.getSize((IFigure)this.val$figure).height == recordedHeight) {
                            isSizeChanged = true;
                        }
                    }
                    catch (Exception e1) {
                        TeslaCore.log((Throwable)e1);
                    }
                }
                if (this.val$canvas instanceof FigureCanvas) {
                    ((FigureCanvas)this.val$canvas).getViewport();
                }
                Event e = new Event();
                Rectangle bounds = this.val$figure.getBounds().getCopy();
                int x = bounds.x + this.val$command.getX();
                int y = bounds.y + this.val$command.getY();
                if (!isSizeChanged) {
                    x = (int)((double)bounds.x + (double)bounds.width * (1.0 * (double)this.val$command.getX() / (double)this.val$command.getFigureWidth()));
                    y = (int)((double)bounds.y + (double)bounds.height * (1.0 * (double)this.val$command.getY() / (double)this.val$command.getFigureHeight()));
                }
                if (this.val$canvas instanceof FigureCanvas) {
                    GefProcessor.this.scrollToPosition((FigureCanvas)this.val$canvas, x, y);
                }
                if (this.val$canvas instanceof FigureCanvas && (p = GefProcessor.this.correctFigurePosition(x, y, this.val$part, this.val$figure, this.val$viewer, (FigureCanvas)this.val$canvas)) != null) {
                    x = p.x;
                    y = p.y;
                }
                Point translatedPoint = new Point(x, y);
                this.val$figure.translateToAbsolute((Translatable)translatedPoint);
                int nx = translatedPoint.x;
                int ny = translatedPoint.y;
                e.widget = this.val$canvas;
                e.time = (int)System.currentTimeMillis();
                e.x = nx;
                e.y = ny;
                e.stateMask = this.val$command.getStateMask();
                e.button = this.val$command.getButton();
                e.count = 1;
                GefProcessor.this.getPlayer().addMouseWidgetInfo((Widget)this.val$canvas, e.x, e.y);
                switch (this.val$command.getKind()) {
                    case DOWN: {
                        e.type = 3;
                        GefProcessor.this.getPlayer().getEvents().sendEvent((Widget)this.val$canvas, e);
                        if (this.val$finalPart != null) {
                            DNDSupport.fillDragParts(this.val$finalPart, GefProcessor.this.dragParts, (EditPartViewer)this.val$viewer, GefProcessor.this.client);
                            break;
                        }
                        DNDSupport.fillDragParts(null, GefProcessor.this.dragParts, (EditPartViewer)this.val$viewer, GefProcessor.this.client);
                        break;
                    }
                    case ENTER: {
                        e.type = 6;
                        GefProcessor.this.getPlayer().getEvents().sendEvent((Widget)this.val$canvas, e);
                        break;
                    }
                    case EXIT: {
                        e.type = 7;
                        GefProcessor.this.getPlayer().getEvents().sendEvent((Widget)this.val$canvas, e);
                        break;
                    }
                    case UP: {
                        e.type = 4;
                        GefProcessor.this.getPlayer().getEvents().sendEvent((Widget)this.val$canvas, e);
                        GefProcessor.this.dragParts.clear();
                        break;
                    }
                    case MOVE: {
                        e.type = 5;
                        GefProcessor.this.getPlayer().getEvents().sendEvent((Widget)this.val$canvas, e);
                        break;
                    }
                    case DRAG: {
                        if ((e.stateMask & SWT.BUTTON_MASK) == 0) {
                            e.stateMask |= SWT.BUTTON_MASK;
                        }
                        e.type = 5;
                        GefProcessor.this.getPlayer().getEvents().sendEvent((Widget)this.val$canvas, e);
                        break;
                    }
                    case HOVER: {
                        e.type = 32;
                        GefProcessor.this.getPlayer().getEvents().sendEvent((Widget)this.val$canvas, e);
                        break;
                    }
                    case DOUBLE_CLICK: {
                        e.type = 8;
                        GefProcessor.this.getPlayer().getEvents().sendEvent((Widget)this.val$canvas, e);
                        break;
                    }
                    case NATIVE_DRAG_FINISHED: {
                        break;
                    }
                }
                if (origMinSize != null && origMinSize != GefProcessor.this.getMinSize(this.val$figure)) {
                    try {
                        this.val$figure.setMinimumSize(origMinSize);
                    }
                    catch (Exception e1) {
                        TeslaCore.log((Throwable)e1);
                    }
                }
                if (origMaxSize != null && origMaxSize != GefProcessor.this.getMaxSize(this.val$figure)) {
                    try {
                        this.val$figure.setMaximumSize(origMaxSize);
                    }
                    catch (Exception e1) {
                        TeslaCore.log((Throwable)e1);
                    }
                }
                if (origSize != null && origSize != GefProcessor.this.getSize(this.val$figure)) {
                    try {
                        this.val$figure.setSize(origSize);
                    }
                    catch (Exception e1) {
                        TeslaCore.log((Throwable)e1);
                    }
                }
                if (this.val$finalPart != null && (drawer = GefProcessor.this.findContainingDrawer(this.val$finalPart.getParent())) != null && horizontalBarVisibility != -1 && verticalBarVisibility != -1) {
                    GefProcessor.this.getDrawerFigure(drawer).getScrollpane().setHorizontalScrollBarVisibility(horizontalBarVisibility);
                    GefProcessor.this.getDrawerFigure(drawer).getScrollpane().setVerticalScrollBarVisibility(verticalBarVisibility);
                }
            }
        });
        return RawFactory.eINSTANCE.createResponse();
    }

    private DrawerFigure getDrawerFigure(DrawerEditPart drawer) {
        return (DrawerFigure)drawer.getFigure();
    }

    private DrawerEditPart findContainingDrawer(EditPart part) {
        if (part == null) {
            return null;
        }
        if (part instanceof DrawerEditPart) {
            return (DrawerEditPart)part;
        }
        return this.findContainingDrawer(part.getParent());
    }

    private Dimension getMinSize(IFigure figure) {
        if (figure instanceof Label && figure.getFont() == null) {
            return null;
        }
        Dimension minSize = null;
        try {
            minSize = figure.getMinimumSize().getCopy();
        }
        catch (Exception e) {
            TeslaCore.log((Throwable)e);
        }
        return minSize;
    }

    private Dimension getMaxSize(IFigure figure) {
        if (figure instanceof Label && figure.getFont() == null) {
            return null;
        }
        Dimension maxSize = null;
        try {
            maxSize = figure.getMaximumSize().getCopy();
        }
        catch (Exception e) {
            TeslaCore.log((Throwable)e);
        }
        return maxSize;
    }

    private Dimension getSize(IFigure figure) {
        Dimension size = null;
        try {
            size = figure.getSize().getCopy();
        }
        catch (Exception e) {
            TeslaCore.log((Throwable)e);
        }
        return size;
    }

    protected Point correctFigurePosition(int nx, int ny, GraphicalEditPart part, IFigure figure, GraphicalViewer viewer, FigureCanvas canvas) {
        Point relativeEventPoint;
        int y;
        if (this.isPartFiltered(part)) {
            return null;
        }
        if (this.dragParts.contains(part)) {
            return null;
        }
        Rectangle bounds = this.getBounds(figure);
        if (this.isInside(canvas, viewer, part, figure, nx, ny)) {
            return null;
        }
        int newX = nx;
        if (nx < bounds.x) {
            newX = bounds.x + 1;
        } else if (nx > bounds.x + bounds.width) {
            newX = bounds.x + bounds.width - 1;
        }
        int newY = ny;
        if (ny < bounds.y) {
            newY = bounds.y + 1;
        } else if (ny > bounds.y + bounds.height) {
            newY = bounds.y + bounds.height - 1;
        }
        if (this.isInside(canvas, viewer, part, figure, newX, newY)) {
            return new Point(newX, newY);
        }
        Point absoluteEventPoint = new Point(nx, ny);
        figure.translateToAbsolute((Translatable)absoluteEventPoint);
        Rectangle absoluteBounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)absoluteBounds);
        int x = absoluteEventPoint.x;
        while (x > absoluteBounds.x) {
            y = absoluteEventPoint.y;
            while (y > absoluteBounds.y) {
                relativeEventPoint = new Point(x, y);
                figure.translateToRelative((Translatable)relativeEventPoint);
                if (this.isInside(canvas, viewer, part, figure, relativeEventPoint.x, relativeEventPoint.y)) {
                    return relativeEventPoint;
                }
                --y;
            }
            y = absoluteEventPoint.y;
            while (y < absoluteBounds.y + absoluteBounds.height) {
                relativeEventPoint = new Point(x, y);
                figure.translateToRelative((Translatable)relativeEventPoint);
                if (this.isInside(canvas, viewer, part, figure, relativeEventPoint.x, relativeEventPoint.y)) {
                    return relativeEventPoint;
                }
                ++y;
            }
            --x;
        }
        x = absoluteEventPoint.x;
        while (x < absoluteBounds.x + absoluteBounds.width) {
            y = absoluteEventPoint.y;
            while (y > absoluteBounds.y) {
                relativeEventPoint = new Point(x, y);
                figure.translateToRelative((Translatable)relativeEventPoint);
                if (this.isInside(canvas, viewer, part, figure, relativeEventPoint.x, relativeEventPoint.y)) {
                    return relativeEventPoint;
                }
                --y;
            }
            y = absoluteEventPoint.y;
            while (y < absoluteBounds.y + absoluteBounds.height) {
                relativeEventPoint = new Point(x, y);
                figure.translateToRelative((Translatable)relativeEventPoint);
                if (this.isInside(canvas, viewer, part, figure, relativeEventPoint.x, relativeEventPoint.y)) {
                    return relativeEventPoint;
                }
                ++y;
            }
            ++x;
        }
        return null;
    }

    private boolean isPartFiltered(GraphicalEditPart part) {
        if (part != null) {
            GraphicalEditPart editpart = part;
            while (editpart != null) {
                if (this.dragParts.contains(editpart)) {
                    return true;
                }
                editpart = (GraphicalEditPart)editpart.getParent();
            }
        }
        return false;
    }

    private Rectangle getBounds(IFigure figure) {
        IFigure p;
        Rectangle bounds = figure.getBounds();
        if (bounds.x == 0 && bounds.y == 0 && (p = figure.getParent()) != null) {
            return this.getBounds(p);
        }
        return bounds;
    }

    private boolean isInside(FigureCanvas canvas, GraphicalViewer viewer, GraphicalEditPart part, IFigure figure, int nx, int ny) {
        EditPart at;
        IFigure figureRoot;
        Point translatedPoint = new Point(nx, ny);
        figure.translateToAbsolute((Translatable)translatedPoint);
        if (figure instanceof Layer && figure.getBounds().contains(nx, ny)) {
            EditPart at2;
            return !(part != null ? (at2 = viewer.findObjectAt(new Point(translatedPoint.x, translatedPoint.y))) != null && !at2.equals(part) : (at = this.findAt(viewer, translatedPoint, Collections.emptySet())) != null && !at.equals(part) && !at.equals(viewer.getRootEditPart()));
        }
        if (!figure.containsPoint(nx, ny)) {
            return false;
        }
        IFigure iFigure = figureRoot = viewer.getRootEditPart() != null ? ((GraphicalEditPart)viewer.getContents()).getFigure() : canvas.getContents();
        if (part != null) {
            at = viewer.findObjectAt(new Point(translatedPoint.x, translatedPoint.y));
            if (at != null && !at.equals(part)) {
                return false;
            }
            figureRoot = part.getFigure();
        } else if (viewer.getRootEditPart() != null && (at = this.findAt(viewer, translatedPoint, Collections.emptySet())) != null) {
            EditPart parentPart = viewer.getContents();
            boolean partFound = at.equals(parentPart);
            while (!partFound && parentPart != null) {
                parentPart = parentPart.getParent();
                partFound = at.equals(parentPart);
            }
            return partFound;
        }
        IFigure figureAt = figureRoot.findFigureAt(nx, ny);
        while (figureAt instanceof FlowFigure) {
            if (figure.equals(figureAt = figureAt.getParent())) break;
        }
        boolean figureFind = figure.equals(figureAt);
        IFigure parentFugure = figureAt;
        while (!figureFind && parentFugure != null) {
            parentFugure = parentFugure.getParent();
            figureFind = figure.equals(parentFugure);
        }
        return figureFind;
    }

    private EditPart findAt(GraphicalViewer viewer, Point translatedPoint, Set<IFigure> exclude) {
        EditPart at = viewer.findObjectAtExcluding(new Point(translatedPoint.x, translatedPoint.y), exclude, this.findAtCondition);
        return at;
    }

    public GraphicalEditPart getEditPartFromPath(List<Integer> partPath, GraphicalViewer viewer) {
        GraphicalEditPart part = null;
        if (partPath.size() > 0) {
            if (partPath.get(0) == -2) {
                int index = partPath.get(1);
                ArrayList<Integer> address = new ArrayList<Integer>();
                ArrayList<Integer> subPart = new ArrayList<Integer>();
                this.fillAddresses(partPath, address, subPart);
                GraphicalEditPart sourcePart = (GraphicalEditPart)this.getPart(address, (EditPart)viewer.getRootEditPart());
                List list = sourcePart.getSourceConnections();
                if (list.size() <= index) {
                    return null;
                }
                part = (GraphicalEditPart)list.get(index);
                if (part != null && subPart.size() > 0) {
                    return (GraphicalEditPart)this.getPart(subPart, (EditPart)part);
                }
            } else if (partPath.get(0) == -3) {
                int index = partPath.get(1);
                ArrayList<Integer> address = new ArrayList<Integer>();
                ArrayList<Integer> subPart = new ArrayList<Integer>();
                this.fillAddresses(partPath, address, subPart);
                GraphicalEditPart sourcePart = (GraphicalEditPart)this.getPart(address, (EditPart)viewer.getRootEditPart());
                List list = sourcePart.getTargetConnections();
                if (list.size() <= index) {
                    return null;
                }
                part = (GraphicalEditPart)list.get(index);
                if (part != null && subPart.size() > 0) {
                    return (GraphicalEditPart)this.getPart(subPart, (EditPart)part);
                }
            } else {
                part = (GraphicalEditPart)this.getPart(partPath, (EditPart)viewer.getRootEditPart());
            }
        }
        return part;
    }

    private void fillAddresses(List<Integer> partPath, List<Integer> address, List<Integer> subPart) {
        boolean sub = false;
        int i = 2;
        while (i < partPath.size()) {
            Integer val = partPath.get(i);
            if (val == -1) {
                sub = true;
            } else if (!sub) {
                address.add(val);
            } else {
                subPart.add(val);
            }
            ++i;
        }
    }

    private Response proceedFigureCanvas(final FigureMouseCommand command, Element element) {
        Widget widget;
        RawFigureUIElement rawFigure;
        SWTUIElement canvasElement = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(element);
        IFigure resultFigure = null;
        if (canvasElement == null && (rawFigure = (RawFigureUIElement)this.getRawMapper().get(element)) != null) {
            resultFigure = rawFigure.getFigure();
            canvasElement = this.getPlayer().wrap((Object)rawFigure.getCanvas());
        }
        if (canvasElement != null && (widget = PlayerWrapUtils.unwrapWidget((SWTUIElement)canvasElement)) instanceof FigureCanvas) {
            final FigureCanvas canvas = (FigureCanvas)widget;
            final IFigure figure = resultFigure == null ? this.getFigure((List<Integer>)command.getFigurePath(), canvas.getContents(), null) : resultFigure;
            if (figure == null) {
                return GefProcessor.createFailed(TeslaGefMessages.GefProcessor_CannotFindFigure);
            }
            final EventDispatcher dispatcher = canvas.getLightweightSystem().getRootFigure().internalGetEventDispatcher();
            this.getPlayer().exec("Set bounds and location", new Runnable(){

                @Override
                public void run() {
                    GefProcessor.this.scrollToFigure(canvas, figure);
                }
            });
            this.getPlayer().exec("Tesla Gef runnable", new Runnable(){

                @Override
                public void run() {
                    Event e = new Event();
                    Rectangle bounds = figure.getBounds();
                    double px = 1.0 * (double)command.getX() / (double)command.getFigureWidth();
                    double py = 1.0 * (double)command.getY() / (double)command.getFigureHeight();
                    Point translatedPoint = new Point((int)((double)bounds.x + (double)bounds.width * px), (int)((double)bounds.y + (double)bounds.height * py));
                    figure.translateToAbsolute((Translatable)translatedPoint);
                    int nx = translatedPoint.x;
                    int ny = translatedPoint.y;
                    e.widget = canvas;
                    e.time = (int)System.currentTimeMillis();
                    e.x = nx;
                    e.y = ny;
                    e.stateMask = command.getStateMask();
                    e.button = command.getButton();
                    MouseEvent mouseEvent = new MouseEvent(e);
                    switch (command.getKind()) {
                        case DOWN: {
                            dispatcher.dispatchMousePressed(mouseEvent);
                            break;
                        }
                        case ENTER: {
                            dispatcher.dispatchMouseEntered(mouseEvent);
                            break;
                        }
                        case EXIT: {
                            dispatcher.dispatchMouseExited(mouseEvent);
                            break;
                        }
                        case UP: {
                            dispatcher.dispatchMouseReleased(mouseEvent);
                            break;
                        }
                        case MOVE: {
                            dispatcher.dispatchMouseMoved(mouseEvent);
                            break;
                        }
                        case DRAG: {
                            dispatcher.dispatchMouseMoved(mouseEvent);
                            break;
                        }
                        case HOVER: {
                            dispatcher.dispatchMouseHover(mouseEvent);
                            break;
                        }
                        case DOUBLE_CLICK: {
                            dispatcher.dispatchMouseDoubleClicked(mouseEvent);
                            break;
                        }
                        case NATIVE_DRAG_FINISHED: {
                            break;
                        }
                    }
                }
            });
            return RawFactory.eINSTANCE.createResponse();
        }
        return GefProcessor.createFailed(TeslaGefMessages.GefProcessor_CannotFindDiagramOrCanvas);
    }

    public static Response createFailed(String msg) {
        BooleanResponse response = ProtocolFactory.eINSTANCE.createBooleanResponse();
        response.setStatus(ResponseStatus.FAILED);
        response.setMessage(msg);
        return response;
    }

    public DiagramViewerUIElement getDiagram(Element element) {
        DiagramViewerUIElement diagram;
        FigureUIElement figureUIElement = (FigureUIElement)this.getMapper().get(element);
        if (figureUIElement != null) {
            diagram = figureUIElement.getDiagram();
        } else {
            GraphicalViewer viewer;
            RawFigureUIElement rawFigureUIElement = (RawFigureUIElement)this.getRawMapper().get(element);
            if (rawFigureUIElement != null && (viewer = rawFigureUIElement.getViewer()) != null) {
                return new DiagramViewerUIElement(this.getPlayer(), viewer);
            }
            SWTUIElement swtuiElement = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(element);
            if (swtuiElement instanceof DiagramViewerUIElement) {
                diagram = (DiagramViewerUIElement)swtuiElement;
            } else {
                return null;
            }
        }
        return diagram;
    }

    private EditPart getPart(List<Integer> partPath, EditPart rootPart) {
        EditPart te = rootPart;
        for (Integer integer : partPath) {
            List children = te.getChildren();
            List realChildren = this.getPartChildren(children);
            if (realChildren.size() <= integer || integer < 0) {
                return null;
            }
            te = (EditPart)realChildren.get(integer);
        }
        return te;
    }

    private List getPartChildren(List children) {
        ArrayList realChildren = new ArrayList();
        for (Object object : children) {
            IFigure figure;
            if (object instanceof GraphicalEditPart && !(figure = ((GraphicalEditPart)object).getFigure()).isVisible()) continue;
            realChildren.add(object);
        }
        return realChildren;
    }

    private IFigure getFigure(List<Integer> path, IFigure figure, GraphicalEditPart part) {
        IFigure te;
        Integer p0;
        ArrayList<Integer> copyList = new ArrayList<Integer>(path);
        if (copyList.size() > 0 && (p0 = (Integer)copyList.get(0)) < 0) {
            if (p0.equals(-1)) {
                while (figure.getParent() != null) {
                    figure = figure.getParent();
                }
                copyList.remove(0);
            }
            if (part != null) {
                List list = this.client.getProcessors(IGefReplayHelper.class);
                for (IGefReplayHelper helper : list) {
                    IFigure result = helper.getFigure(path, part);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        if ((te = this.getFigureFilter(figure, copyList, false)) == null) {
            te = this.getFigureFilter(figure, copyList, true);
        }
        return te;
    }

    private IFigure getFigureFilter(IFigure figure, List<Integer> copyList, boolean filter) {
        IFigure te = figure;
        for (Integer integer : copyList) {
            List children;
            List list = children = filter ? GefProcessor.filterFigures(te.getChildren()) : te.getChildren();
            if (children.size() <= integer && (children = te.getChildren()).size() <= integer) {
                return null;
            }
            te = (IFigure)children.get(integer);
        }
        return te;
    }

    private static List filterFigures(List children) {
        ArrayList result = new ArrayList();
        for (Object object : children) {
            if (object instanceof IFigure && !((IFigure)object).isVisible()) continue;
            result.add(object);
        }
        return result;
    }

    private Response handleGetTextCommand(GetText command) {
        return null;
    }

    private Response handleFigureResize(ResizeFigure command) {
        FigureUIElement element = (FigureUIElement)this.getMapper().get(command.getElement());
        EditPart part = element.getPart();
        if (part instanceof GraphicalEditPart) {
            GraphicalEditPart gep = (GraphicalEditPart)part;
            Rectangle bounds = gep.getFigure().getBounds();
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"resize");
            int x = command.getX();
            int y = command.getY();
            request.setSizeDelta(new Dimension(x != -1 ? x - bounds.width : 0, y != -1 ? y - bounds.height : 0));
            request.setEditParts(part);
            org.eclipse.gef.commands.Command cmd = part.getCommand((Request)request);
            if (cmd != null && cmd.canExecute()) {
                element.getDiagram().getDomain().getCommandStack().execute(cmd);
            }
            return RawFactory.eINSTANCE.createResponse();
        }
        return this.returnFailed(RawFactory.eINSTANCE.createResponse());
    }

    private Response handleFigureMove(MoveFigure command) {
        FigureUIElement element = (FigureUIElement)this.getMapper().get(command.getElement());
        EditPart part = element.getPart();
        if (part instanceof GraphicalEditPart) {
            GraphicalEditPart gep = (GraphicalEditPart)part;
            Rectangle bounds = gep.getFigure().getBounds();
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
            int x = command.getX();
            int y = command.getY();
            request.setMoveDelta(new Point(x != -1 ? x - bounds.x : 0, y != -1 ? y - bounds.y : 0));
            request.setEditParts(part);
            org.eclipse.gef.commands.Command cmd = part.getCommand((Request)request);
            if (cmd != null && cmd.canExecute()) {
                element.getDiagram().getDomain().getCommandStack().execute(cmd);
            }
            return RawFactory.eINSTANCE.createResponse();
        }
        return this.returnFailed(RawFactory.eINSTANCE.createResponse());
    }

    private Response handleCommitDirectEdit(CommitDirectEdit command) {
        SWTUIElement element = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(command.getElement());
        DirectEditorContainer[] editors = TeslaDirectEditManager.getInstance().getEditors();
        if (element != null) {
            if (element instanceof DiagramViewerUIElement) {
                DirectEditorContainer[] directEditorContainerArray = editors;
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    final DirectEditorContainer container = directEditorContainerArray[n2];
                    CellEditor editor = container.getCellEditor();
                    if (editor != null) {
                        TeslaDirectEditManager.getInstance().forceRemove(container.getManager());
                        if (container.getCellEditor().getControl() != null) {
                            this.getPlayer().exec("Commit direct edit", new Runnable(){

                                @Override
                                public void run() {
                                    container.commit();
                                }
                            });
                        }
                    }
                    ++n2;
                }
                return RawFactory.eINSTANCE.createResponse();
            }
            DirectEditorContainer[] directEditorContainerArray = editors;
            int n = editors.length;
            int n3 = 0;
            while (n3 < n) {
                Control control;
                final DirectEditorContainer container = directEditorContainerArray[n3];
                CellEditor editor = container.getCellEditor();
                if (editor != null && (control = editor.getControl()).equals(element.widget)) {
                    TeslaDirectEditManager.getInstance().forceRemove(container.getManager());
                    this.getPlayer().exec("Commit direct edit", new Runnable(){

                        @Override
                        public void run() {
                            container.commit();
                        }
                    });
                    return RawFactory.eINSTANCE.createResponse();
                }
                ++n3;
            }
        } else {
            DirectEditorContainer[] directEditorContainerArray = editors;
            int n = editors.length;
            int n4 = 0;
            while (n4 < n) {
                DirectEditorContainer container = directEditorContainerArray[n4];
                CellEditor editor = container.getCellEditor();
                if (editor != null) {
                    TeslaDirectEditManager.getInstance().forceRemove(container.getManager());
                    container.commit();
                }
                ++n4;
            }
            return RawFactory.eINSTANCE.createResponse();
        }
        return null;
    }

    private Response handleCancelDirectEdit(CancelDirectEdit command) {
        SWTUIElement element = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(command.getElement());
        DirectEditorContainer[] editors = TeslaDirectEditManager.getInstance().getEditors();
        if (element != null) {
            if (element instanceof DiagramViewerUIElement) {
                DirectEditorContainer[] directEditorContainerArray = editors;
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    final DirectEditorContainer container = directEditorContainerArray[n2];
                    CellEditor editor = container.getCellEditor();
                    if (editor != null) {
                        TeslaDirectEditManager.getInstance().forceRemove(container.getManager());
                        if (container.getCellEditor().getControl() != null) {
                            this.getPlayer().exec("Cancel direct edit", new Runnable(){

                                @Override
                                public void run() {
                                    container.bringDown();
                                }
                            });
                        }
                    }
                    ++n2;
                }
                return RawFactory.eINSTANCE.createResponse();
            }
            DirectEditorContainer[] directEditorContainerArray = editors;
            int n = editors.length;
            int n3 = 0;
            while (n3 < n) {
                Control control;
                final DirectEditorContainer container = directEditorContainerArray[n3];
                CellEditor editor = container.getCellEditor();
                if (editor != null && (control = editor.getControl()).equals(element.widget)) {
                    TeslaDirectEditManager.getInstance().forceRemove(container.getManager());
                    this.getPlayer().exec("Cancel direct edit", new Runnable(){

                        @Override
                        public void run() {
                            container.bringDown();
                        }
                    });
                    return RawFactory.eINSTANCE.createResponse();
                }
                ++n3;
            }
        } else {
            DirectEditorContainer[] directEditorContainerArray = editors;
            int n = editors.length;
            int n4 = 0;
            while (n4 < n) {
                DirectEditorContainer container = directEditorContainerArray[n4];
                CellEditor editor = container.getCellEditor();
                if (editor != null) {
                    TeslaDirectEditManager.getInstance().forceRemove(container.getManager());
                    container.bringDown();
                }
                ++n4;
            }
            return RawFactory.eINSTANCE.createResponse();
        }
        return null;
    }

    private Response handleActivateDirectEdit(ActivateDirectEdit command, IElementProcessorMapper mapper) {
        SWTUIElement swtuiElement = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(command.getElement());
        if (swtuiElement != null && swtuiElement instanceof DiagramViewerUIElement) {
            DiagramViewerUIElement diagram = (DiagramViewerUIElement)swtuiElement;
            GraphicalViewer viewer = diagram.getViewer();
            if (command.getPartPath().size() > 0) {
                GraphicalEditPart part = this.getEditPartFromPath((List<Integer>)command.getPartPath(), viewer);
                if (part == null) {
                    return GefProcessor.createFailed(TeslaGefMessages.GefProcessor_CannotFindEditPart);
                }
                this.performDirectEdit(mapper, (Canvas)((FigureCanvas)viewer.getControl()), (EditPart)part);
            }
            return RawFactory.eINSTANCE.createResponse();
        }
        FigureUIElement figure = (FigureUIElement)this.getMapper().get(command.getElement());
        if (figure == null) {
            return this.returnFailed(null);
        }
        EditPart part = figure.getPart();
        SelectResponse response = this.performDirectEdit(mapper, figure.getDiagram().getCanvas(), part);
        if (response != null) {
            return response;
        }
        return this.returnFailed(null);
    }

    private SelectResponse performDirectEdit(final IElementProcessorMapper mapper, final Canvas canvas, final EditPart part) {
        EditPolicy policy = part.getEditPolicy((Object)"DirectEditPolicy");
        DirectEditorContainer[] editorContainers = TeslaDirectEditManager.getInstance().getEditors();
        boolean activeDE = false;
        Object partModel = part.getModel();
        DirectEditorContainer[] directEditorContainerArray = editorContainers;
        int n = editorContainers.length;
        int n2 = 0;
        while (n2 < n) {
            DirectEditorContainer directEditorContainer = directEditorContainerArray[n2];
            CellEditor cellEditor = directEditorContainer.getCellEditor();
            if (!(cellEditor != null && cellEditor.getControl() != null && cellEditor.getControl().isDisposed() || cellEditor == null)) {
                Object model;
                DirectEditManager manager = directEditorContainer.getManager();
                EditPart sourcePart = this.getSourceEditPart(manager);
                Object object = model = sourcePart != null ? sourcePart.getModel() : null;
                if (sourcePart != null && sourcePart.getParent().equals(part.getParent())) {
                    Object model2 = sourcePart.getParent().getModel();
                    Object model3 = part.getParent().getModel();
                    if (model2 != null && model2.equals(model3)) {
                        activeDE = true;
                        break;
                    }
                }
                if (sourcePart != null && sourcePart.equals(part) || model != null && partModel != null && model instanceof EObject && partModel instanceof EObject && EcoreUtil.equals((EObject)((EObject)model), (EObject)((EObject)partModel))) {
                    activeDE = true;
                    break;
                }
                if (cellEditor.getControl().getParent().equals(canvas)) {
                    directEditorContainer.bringDown();
                }
            }
            ++n2;
        }
        if (policy != null) {
            final GefProcessor This = this;
            if (!activeDE) {
                this.getPlayer().exec("Perform direct edit", new Runnable(){

                    @Override
                    public void run() {
                        DirectEditorContainer[] editors;
                        Request request = new Request((Object)"direct edit");
                        part.performRequest(request);
                        DirectEditorContainer[] directEditorContainerArray = editors = TeslaDirectEditManager.getInstance().getEditors();
                        int n = editors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control control;
                            DirectEditorContainer container = directEditorContainerArray[n2];
                            CellEditor editor = container.getCellEditor();
                            if (editor != null && editor.getControl() != null && !(control = editor.getControl()).isDisposed() && control.getParent().equals(canvas)) {
                                TeslaDirectEditManager.getInstance().forceEdit(container.getManager());
                                Element element = SWTElementMapper.getMapper((String)GefProcessor.this.id).get((IBasicMappingNode)GefProcessor.this.getPlayer().wrap((Object)control));
                                mapper.map(element, (ITeslaCommandProcessor)This);
                                mapper.map(element, (ITeslaCommandProcessor)GefProcessor.this.client.getProcessor(SWTUIProcessor.class));
                            }
                            ++n2;
                        }
                    }
                });
            }
        } else if (!activeDE) {
            this.getPlayer().exec("Perform direct edit", new Runnable(){

                @Override
                public void run() {
                    Request request = new Request((Object)"direct edit");
                    part.performRequest(request);
                }
            });
        }
        SelectResponse response = ProtocolFactory.eINSTANCE.createSelectResponse();
        return response;
    }

    private EditPart getSourceEditPart(DirectEditManager manager) {
        return TeslaGefAccess.getSourceEditPart(manager);
    }

    private Response handleSetFigureSelection(SetFigureSelection command) {
        return null;
    }

    private Response handleParentCommand(ElementCommand command, IElementProcessorMapper mapper) {
        FigureUIElement editPart = (FigureUIElement)this.getMapper().get(command.getElement());
        if (editPart != null) {
            ParentResponse response = ProtocolFactory.eINSTANCE.createParentResponse();
            EditPart parent = editPart.getPart().getParent();
            if (editPart.getDiagram().getViewer().getRootEditPart().equals(parent)) {
                Element element = SWTElementMapper.getMapper((String)this.id).get((IBasicMappingNode)editPart.getDiagram());
                response.setParent(element);
                mapper.map(element, (ITeslaCommandProcessor)this);
            } else {
                Element element = this.getMapper().get(new FigureUIElement(parent, editPart.getDiagram()));
                response.setParent(element);
                mapper.map(element, (ITeslaCommandProcessor)this);
            }
            return response;
        }
        return null;
    }

    private Response handleChildrenCommand(ElementCommand command, IElementProcessorMapper mapper) {
        Element element = command.getElement();
        SWTUIElement uiElement = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(element);
        FigureUIElement editPart = (FigureUIElement)this.getMapper().get(element);
        if (uiElement != null && uiElement instanceof DiagramViewerUIElement) {
            DiagramViewerUIElement e = (DiagramViewerUIElement)uiElement;
            List children = e.getViewer().getContents().getChildren();
            ChildrenResponse response = ProtocolFactory.eINSTANCE.createChildrenResponse();
            for (Object object : children) {
                if (!(object instanceof EditPart)) continue;
                Element child = this.getMapper().get(new FigureUIElement((EditPart)object, e));
                response.getChildren().add((Object)child);
                mapper.map(child, (ITeslaCommandProcessor)this);
            }
            return response;
        }
        if (editPart != null) {
            List children = editPart.getPart().getChildren();
            ChildrenResponse response = ProtocolFactory.eINSTANCE.createChildrenResponse();
            for (Object object : children) {
                if (!(object instanceof EditPart)) continue;
                Element child = this.getMapper().get(new FigureUIElement((EditPart)object, editPart.getDiagram()));
                response.getChildren().add((Object)child);
                mapper.map(child, (ITeslaCommandProcessor)this);
            }
            return response;
        }
        return null;
    }

    private Response handleCreateFigure(CreateFigure command, IElementProcessorMapper mapper) {
        String pattern;
        DiagramViewerUIElement viewer;
        SWTUIElement element = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(command.getElement());
        CreateFigureResponse response = DiagramFactory.eINSTANCE.createCreateFigureResponse();
        FigureUIElement e = (FigureUIElement)this.getMapper().get(command.getElement());
        if (element instanceof DiagramViewerUIElement) {
            viewer = (DiagramViewerUIElement)element;
        } else if (e != null) {
            viewer = e.getDiagram();
        } else {
            return this.returnFailed((Response)response);
        }
        if (viewer == null || viewer.isDisposed()) {
            return this.returnFailed((Response)response);
        }
        List<ToolEntry> list = viewer.listToolbarEntries();
        ToolEntry requiredEntry = this.searchToolEntry(list, pattern = command.getPattern());
        if (requiredEntry == null) {
            return this.returnFailed((Response)response);
        }
        Tool tool = requiredEntry.createTool();
        if (!(tool instanceof CreationTool)) {
            return this.returnFailed((Response)response);
        }
        CreationTool createTool = (CreationTool)tool;
        EditDomain domain = viewer.getDomain();
        Canvas canvas = viewer.getCanvas();
        Display display = canvas.getDisplay();
        EventDispatcher dispatcher = viewer.getDispatcher();
        int x = command.getX();
        int y = command.getY();
        EditPart performAt = viewer.getViewer().findObjectAt(new Point(x, y));
        if (element instanceof DiagramViewerUIElement) {
            if (canvas instanceof FigureCanvas) {
                Viewport viewport = ((FigureCanvas)canvas).getViewport();
                Point loc = viewport.getViewLocation();
                x -= loc.x;
                y -= loc.y;
            }
            performAt = viewer.getViewer().getRootEditPart();
        } else {
            if (e.getPart() instanceof GraphicalEditPart) {
                GraphicalEditPart gep = (GraphicalEditPart)e.getPart();
                Rectangle bounds = gep.getFigure().getBounds();
                x += bounds.x + 1;
                y += bounds.y + 1;
            }
            performAt = e.getPart();
        }
        EditPartChangeCollector collector = new EditPartChangeCollector();
        RootEditPart root = viewer.getViewer().getRootEditPart();
        collector.associate((EditPart)root);
        boolean fine = false;
        try {
            fine = TeslaGefAccess.createTargetRequest(createTool, x, y, performAt);
        }
        catch (Throwable e1) {
            e1.printStackTrace();
            fine = false;
        }
        if (!fine || collector.getAddedParts().isEmpty()) {
            domain.setActiveTool((Tool)createTool);
            dispatcher.dispatchMouseMoved(new MouseEvent(this.getPlayer().getEvents().createMouseEvent(display, (Widget)canvas, x, y, 0, 0, 0)));
            dispatcher.dispatchMousePressed(new MouseEvent(this.getPlayer().getEvents().createMouseEvent(display, (Widget)canvas, x, y, 1, 524288, 1)));
            dispatcher.dispatchMouseReleased(new MouseEvent(this.getPlayer().getEvents().createMouseEvent(display, (Widget)canvas, x, y, 1, 524288, 1)));
            domain.setActiveTool(domain.getDefaultTool());
        }
        collector.deAssociate();
        List<EditPart> addedParts = collector.getAddedParts();
        for (EditPart editPart : addedParts) {
            FigureUIElement ee = new FigureUIElement(editPart, viewer);
            Element fig = this.getMapper().get(ee);
            mapper.map(fig, (ITeslaCommandProcessor)this);
            response.getFigure().add((Object)fig);
        }
        viewer.getViewer().deselectAll();
        this.getPlayer().exec("Hide direct editors", new Runnable(){

            @Override
            public void run() {
                DirectEditorContainer[] editors;
                DirectEditorContainer[] directEditorContainerArray = editors = TeslaDirectEditManager.getInstance().getEditors();
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control;
                    DirectEditorContainer container = directEditorContainerArray[n2];
                    CellEditor editor = container.getCellEditor();
                    if (editor != null && (control = editor.getControl()) != null && control.getParent().equals(viewer.getCanvas())) {
                        container.bringDown();
                    }
                    ++n2;
                }
            }
        });
        return response;
    }

    private Response handleCreateConnection(CreateConnection command, IElementProcessorMapper mapper) {
        String pattern;
        DiagramViewerUIElement viewer;
        SWTUIElement element = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(command.getElement());
        CreateConnectionResponse response = DiagramFactory.eINSTANCE.createCreateConnectionResponse();
        FigureUIElement e = (FigureUIElement)this.getMapper().get(command.getElement());
        FigureUIElement source = (FigureUIElement)this.getMapper().get(command.getFrom());
        FigureUIElement target = (FigureUIElement)this.getMapper().get(command.getTo());
        if (element instanceof DiagramViewerUIElement) {
            viewer = (DiagramViewerUIElement)element;
        } else if (e != null) {
            viewer = e.getDiagram();
        } else {
            return this.returnFailed((Response)response);
        }
        if (viewer == null || viewer.isDisposed()) {
            return this.returnFailed((Response)response);
        }
        List<ToolEntry> list = viewer.listToolbarEntries();
        ToolEntry requiredEntry = this.searchToolEntry(list, pattern = command.getPattern());
        if (requiredEntry == null) {
            return this.returnFailed((Response)response);
        }
        Tool tool = requiredEntry.createTool();
        if (!(tool instanceof ConnectionCreationTool)) {
            return this.returnFailed((Response)response);
        }
        ConnectionCreationTool createTool = (ConnectionCreationTool)tool;
        EditDomain domain = viewer.getDomain();
        EditPartChangeCollector collector = new EditPartChangeCollector();
        RootEditPart root = viewer.getViewer().getRootEditPart();
        collector.associate((EditPart)root);
        EditPart performAt = target.getPart();
        boolean fine = false;
        try {
            fine = TeslaGefAccess.createTargetRequest(source, target, createTool, domain, performAt);
        }
        catch (Throwable e1) {
            e1.printStackTrace();
            fine = false;
        }
        if (fine) {
            collector.getAddedConnections().isEmpty();
        }
        collector.deAssociate();
        List<ConnectionEditPart> addedParts = collector.getAddedConnections();
        for (EditPart editPart : addedParts) {
            FigureUIElement ee = new FigureUIElement(editPart, viewer);
            Element fig = this.getMapper().get(ee);
            mapper.map(fig, (ITeslaCommandProcessor)this);
            response.getFigure().add((Object)fig);
        }
        viewer.getViewer().deselectAll();
        this.getPlayer().exec("Hide direct editors", new Runnable(){

            @Override
            public void run() {
                DirectEditorContainer[] editors;
                DirectEditorContainer[] directEditorContainerArray = editors = TeslaDirectEditManager.getInstance().getEditors();
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control;
                    DirectEditorContainer container = directEditorContainerArray[n2];
                    CellEditor editor = container.getCellEditor();
                    if (editor != null && (control = editor.getControl()) != null && control.getParent().equals(viewer.getCanvas())) {
                        container.bringDown();
                    }
                    ++n2;
                }
            }
        });
        return response;
    }

    private Response returnFailed(Response response) {
        if (response == null) {
            response = RawFactory.eINSTANCE.createResponse();
        }
        response.setStatus(ResponseStatus.FAILED);
        return response;
    }

    private ToolEntry searchToolEntry(List<ToolEntry> list, String pattern) {
        ToolEntry requiredEntry = null;
        for (ToolEntry toolEntry : list) {
            String label = toolEntry.getLabel();
            if (!label.equals(pattern) && !label.matches(pattern)) continue;
            requiredEntry = toolEntry;
            break;
        }
        return requiredEntry;
    }

    public boolean isSelectorSupported(String kind) {
        return kind.equals(ElementKind.DiagramViewer.name()) || kind.equals(ElementKind.DiagramFigure.name()) || kind.equals(ElementKind.PaletteViewer.name()) || kind.equals(ElementKind.PaletteEntry.name());
    }

    public SelectResponse select(SelectCommand cmd, ElementGenerator generator, IElementProcessorMapper mapper) {
        String kind = cmd.getData().getKind();
        if (kind.equals(ElementKind.DiagramViewer.name())) {
            return this.selectDiagramViewer(cmd);
        }
        if (kind.equals(ElementKind.PaletteViewer.name())) {
            return this.selectPalette(cmd);
        }
        if (kind.equals(ElementKind.DiagramFigure.name())) {
            return this.selectDiagramFigure(cmd);
        }
        if (kind.equals(ElementKind.PaletteEntry.name())) {
            return this.selectPaletteEntry(cmd);
        }
        return this.createFailedSelect(TeslaGefMessages.GefProcessor_CannotSelect);
    }

    private SelectResponse selectPaletteEntry(SelectCommand cmd) {
        GraphicalViewer viewer;
        Element parent = cmd.getData().getParent();
        DiagramViewerUIElement uiEl = (DiagramViewerUIElement)SWTElementMapper.getMapper((String)this.id).get(parent);
        String pattern = cmd.getData().getPattern();
        if (uiEl != null && (viewer = uiEl.getViewer()) instanceof PaletteViewer) {
            EditPart part;
            boolean patternExists;
            PaletteViewer palette = (PaletteViewer)viewer;
            ArrayList<PaletteEntry> entries = new ArrayList<PaletteEntry>();
            GefProcessor.fillPaletteEntries(entries, (PaletteContainer)palette.getPaletteRoot());
            PaletteEntry requiredEntry = null;
            int index = 0;
            Integer dataIndex = cmd.getData().getIndex();
            for (PaletteEntry paletteEntry : entries) {
                String label = paletteEntry.getLabel();
                if ((label == null || !label.equals(pattern)) && !PlayerTextUtils.safeMatches((String)label, (String)pattern)) continue;
                if (dataIndex != null && dataIndex == index || dataIndex == null) {
                    requiredEntry = paletteEntry;
                    break;
                }
                ++index;
            }
            boolean bl = patternExists = pattern != null && pattern.length() > 0;
            if (!(requiredEntry == null && patternExists || (part = this.findPaletteEntry((EditPart)palette.getRootEditPart(), requiredEntry)) == null)) {
                Element element = this.getMapper().get(new PaletteUIElement(part, uiEl));
                return this.toResponse(element);
            }
        }
        return this.createFailedSelect(NLS.bind((String)TeslaGefMessages.GefProcessor_CannotFindPaletteTool, (Object)pattern));
    }

    public static void fillPaletteEntries(List<PaletteEntry> list, PaletteContainer container) {
        List children = container.getChildren();
        for (Object object : children) {
            if (!(object instanceof PaletteEntry) || !((PaletteEntry)object).isVisible()) continue;
            if (object instanceof PaletteContainer) {
                list.add((PaletteEntry)object);
                GefProcessor.fillPaletteEntries(list, (PaletteContainer)object);
                continue;
            }
            list.add((PaletteEntry)object);
        }
    }

    private EditPart findPaletteEntry(EditPart entry, PaletteEntry pattern) {
        Object model;
        if (pattern == null) {
            return entry;
        }
        if (TeslaGefAccess.isPalleteEditPart(entry) && (model = entry.getModel()) != null && model instanceof PaletteEntry && model.equals(pattern)) {
            return entry;
        }
        List children = entry.getChildren();
        for (Object object : children) {
            EditPart res;
            if (!(object instanceof EditPart) || (res = this.findPaletteEntry((EditPart)object, pattern)) == null) continue;
            return res;
        }
        return null;
    }

    private SelectResponse selectDiagramFigure(SelectCommand cmd) {
        SelectData data;
        Element parent = cmd.getData().getParent();
        FigureUIElement figureParent = (FigureUIElement)this.getMapper().get(parent);
        DiagramViewerUIElement uiEl = this.getDiagram(parent);
        if (figureParent != null) {
            data = cmd.getData();
            String classPattern = data.getClassPattern();
            DiagramViewerUIElement diagram = figureParent.getDiagram();
            GraphicalEditPart part = (GraphicalEditPart)figureParent.getPart();
            if (classPattern != null) {
                return this.selectEditPartByClassPattern(cmd, classPattern, diagram, part);
            }
            EList path = data.getPath();
            if (path.size() == 2) {
                String p0 = (String)path.get(0);
                String p1 = (String)path.get(1);
                EList indexes = data.getIndexes();
                if (p0.equals("editpart") && p1.equals("address")) {
                    GraphicalEditPart editPart = (GraphicalEditPart)this.getPart((List<Integer>)indexes, (EditPart)part);
                    return this.selectEditPart(uiEl, "by address: " + Arrays.toString(indexes.toArray()), editPart);
                }
                if (p0.equals("editpart") && p1.equals("name")) {
                    List children = part.getChildren();
                    return this.selectByName(uiEl, data, children);
                }
                if (p0.equals("editpart") && p1.equals("text")) {
                    List children = part.getChildren();
                    return this.selectByText(uiEl, data, children);
                }
                if (p0.equals("editpart") && p1.equals("customId")) {
                    if (!TeslaFeatures.isIdentifyMethodsProvided()) {
                        String failMessage = NLS.bind((String)TeslaGefMessages.GefProcessor_CannotFindEditPart_DetailedMsg, (Object)TeslaMessages.TeslaFeatures_IdentifyMethodsNotProvided);
                        return this.createFailedSelect(failMessage);
                    }
                    List children = part.getChildren();
                    return this.selectByCustomId(uiEl, data, children);
                }
                if (p0.equals("editpart") && p1.equals("classname")) {
                    List children = part.getChildren();
                    return this.selectByClassName(uiEl, data, children);
                }
                if (p0.equals("handle") && p1.equals("class")) {
                    return this.selectHandle(part, data.getPattern(), data.getIndex());
                }
                if (p0.equals("editpart.feature")) {
                    List children = part.getChildren();
                    return this.selectByFeature(p1, uiEl, data, children);
                }
                if (p0.equals("editpart.source.connection") && p1.equals("address")) {
                    List connections = part.getSourceConnections();
                    if (connections.size() <= (Integer)indexes.get(0)) {
                        return this.createFailedSelect(TeslaGefMessages.GefProcessor_CannotSelect);
                    }
                    GraphicalEditPart editPart = (GraphicalEditPart)connections.get((Integer)indexes.get(0));
                    return this.selectEditPart(uiEl, "by address: " + Arrays.toString(indexes.toArray()), editPart);
                }
                if (p0.equals("editpart.target.connection") && p1.equals("address")) {
                    List connections = part.getTargetConnections();
                    if (connections.size() <= (Integer)indexes.get(0)) {
                        return this.createFailedSelect(TeslaGefMessages.GefProcessor_CannotSelect);
                    }
                    GraphicalEditPart editPart = (GraphicalEditPart)connections.get((Integer)indexes.get(0));
                    return this.selectEditPart(uiEl, "by address: " + Arrays.toString(indexes.toArray()), editPart);
                }
                if (p0.equals("rawFigure") && p1.equals("address")) {
                    return this.selectRawFigure((List<Integer>)indexes, this.getFigure((List<Integer>)indexes, part.getFigure(), part), (EditPart)part, diagram.getViewer());
                }
            }
        }
        if (uiEl != null) {
            data = cmd.getData();
            EList path = data.getPath();
            if (path.size() == 2) {
                List children;
                String p0 = (String)path.get(0);
                String p1 = (String)path.get(1);
                if (p0.equals("editpart") && p1.equals("address")) {
                    GraphicalEditPart part = this.getEditPartFromPath((List<Integer>)data.getIndexes(), uiEl.getViewer());
                    return this.selectEditPart(uiEl, "by address: " + Arrays.toString(data.getIndexes().toArray()), part);
                }
                if (p0.equals("editpart") && p1.equals("name")) {
                    children = uiEl.getViewer().getRootEditPart().getChildren();
                    return this.selectByName(uiEl, data, children);
                }
                if (p0.equals("editpart") && p1.equals("text")) {
                    children = uiEl.getViewer().getRootEditPart().getChildren();
                    return this.selectByText(uiEl, data, children);
                }
                if (p0.equals("handle") && p1.equals("class")) {
                    return this.selectHandle((GraphicalEditPart)uiEl.getViewer().getRootEditPart(), data.getPattern(), data.getIndex());
                }
                if (p0.equals("editpart.feature")) {
                    children = uiEl.getViewer().getRootEditPart().getChildren();
                    return this.selectByFeature(p1, uiEl, data, children);
                }
                if (p0.equals("editpart") && p1.equals("customId")) {
                    if (!TeslaFeatures.isIdentifyMethodsProvided()) {
                        String failMessage = NLS.bind((String)TeslaGefMessages.GefProcessor_CannotFindEditPart_DetailedMsg, (Object)TeslaMessages.TeslaFeatures_IdentifyMethodsNotProvided);
                        return this.createFailedSelect(failMessage);
                    }
                    children = uiEl.getViewer().getRootEditPart().getChildren();
                    return this.selectByCustomId(uiEl, data, children);
                }
                if (p0.equals("editpart") && p1.equals("classname")) {
                    children = uiEl.getViewer().getRootEditPart().getChildren();
                    return this.selectByClassName(uiEl, data, children);
                }
                if (p0.equals("rawFigure") && p1.equals("address")) {
                    IFigure figure = this.getFigure((List<Integer>)data.getIndexes(), uiEl.getFigureContents(), null);
                    return this.selectRawFigure((List<Integer>)data.getIndexes(), figure, null, uiEl.getViewer());
                }
            }
        } else {
            data = cmd.getData();
            SWTUIElement canvasElement = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(parent);
            if (canvasElement != null) {
                if (!(canvasElement.unwrap() instanceof FigureCanvas)) {
                    return this.createFailedSelect(TeslaGefMessages.GefProcessor_CannotSelect);
                }
                return this.selectCanvasFigure(data, canvasElement);
            }
        }
        return this.createFailedSelect(TeslaGefMessages.GefProcessor_CannotSelect);
    }

    private SelectResponse selectHandle(GraphicalEditPart part, String pattern, Integer index) {
        EditPartViewer viewer = part.getViewer();
        List<AbstractHandle> handles = GefProcessor.findAbstractHandles((GraphicalViewer)viewer);
        int ind = 0;
        AbstractHandle result = null;
        for (AbstractHandle object : handles) {
            EditPart editPart = TeslaGefAccess.getEditPart(object);
            if (!part.equals(editPart) || !object.getClass().getSimpleName().equals(pattern)) continue;
            if (index == null || index == ind) {
                result = object;
                break;
            }
            ++ind;
        }
        if (result != null) {
            Element element = this.getRawMapper().get(new RawFigureUIElement((EditPart)viewer.getRootEditPart(), (IFigure)result, (GraphicalViewer)viewer));
            return this.toResponse(element);
        }
        return this.createFailedSelect(NLS.bind((String)TeslaGefMessages.GefProcessor_CannotFindHandle, (Object)pattern, (Object)ind));
    }

    public static List<AbstractHandle> findAbstractHandles(GraphicalViewer viewer) {
        GraphicalEditPart part = (GraphicalEditPart)viewer.getRootEditPart();
        IFigure figure = part.getFigure();
        return GefProcessor.traverseFigures(figure);
    }

    public static List<AbstractHandle> traverseFigures(IFigure figure) {
        ArrayList<AbstractHandle> result = new ArrayList<AbstractHandle>();
        List children = figure.getChildren();
        for (Object object : children) {
            if (object instanceof AbstractHandle) {
                result.add((AbstractHandle)object);
            }
            if (!(object instanceof IFigure)) continue;
            result.addAll(GefProcessor.traverseFigures((IFigure)object));
        }
        return result;
    }

    private SelectResponse selectBy(DiagramViewerUIElement uiEl, SelectData data, List<EditPart> children, String selectorName, Function<EditPart, String> toStr) {
        int index = data.getIndex() == null ? 0 : data.getIndex();
        String pattern = PlayerTextUtils.unifyMultilines((String)data.getPattern());
        EditPart result = GefProcessor.find(ListUtil.filter(children, (Predicate)new Predicate<EditPart>(){

            public boolean apply(EditPart input) {
                return input instanceof GraphicalEditPart;
            }
        }), pattern, index, toStr);
        String indexInfo = data.getIndex() == null ? "" : String.format(" by index: %d", data.getIndex());
        return this.selectEditPart(uiEl, String.format("by %s: %s%s", selectorName, pattern, indexInfo), (GraphicalEditPart)result);
    }

    private static final <T> T find(Collection<T> values, final String pattern, int index, final Function<T, String> toStr) {
        Predicate exact = new Predicate<T>(){

            public boolean apply(T input) {
                return pattern.equals(PlayerTextUtils.unifyMultilines((String)((String)toStr.apply(input))));
            }
        };
        Predicate regex = new Predicate<T>(){

            public boolean apply(T input) {
                String str = PlayerTextUtils.unifyMultilines((String)((String)toStr.apply(input)));
                return str != null && PlayerTextUtils.safeMatches((String)str, (String)pattern);
            }
        };
        List matches = ListUtil.filter(values, (Predicate)exact);
        if (matches.isEmpty()) {
            matches = ListUtil.filter(values, (Predicate)regex);
        }
        if (matches.isEmpty()) {
            return null;
        }
        Iterator iterator = matches.iterator();
        while (index > 0) {
            if (!iterator.hasNext()) {
                return null;
            }
            iterator.next();
            --index;
        }
        try {
            return (T)iterator.next();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private SelectResponse selectByName(DiagramViewerUIElement uiEl, SelectData data, List children) {
        return this.selectBy(uiEl, data, children, "name", new Function<EditPart, String>(){

            public String apply(EditPart input) {
                return GefProcessor.getPartEMFName(GefProcessor.this.getModelObject(input), "name", true);
            }
        });
    }

    private SelectResponse selectByText(DiagramViewerUIElement uiEl, SelectData data, List children) {
        return this.selectBy(uiEl, data, children, "text", new Function<EditPart, String>(){

            public String apply(EditPart input) {
                return GefProcessor.getPartText(GefProcessor.this.getMappedModel(input));
            }
        });
    }

    private SelectResponse selectByCustomId(DiagramViewerUIElement uiEl, SelectData data, List children) {
        return this.selectBy(uiEl, data, children, "customId", new Function<EditPart, String>(){

            public String apply(EditPart input) {
                return GefProcessor.getPartCustomId(input);
            }
        });
    }

    private SelectResponse selectByClassName(DiagramViewerUIElement uiEl, SelectData data, List children) {
        return this.selectBy(uiEl, data, children, "classname", new Function<EditPart, String>(){

            public String apply(EditPart input) {
                return GefProcessor.getPartClassName(input);
            }
        });
    }

    private SelectResponse selectByFeature(final String feature, DiagramViewerUIElement uiEl, SelectData data, List children) {
        return this.selectBy(uiEl, data, children, String.format("feature %s", feature), new Function<EditPart, String>(){

            public String apply(EditPart input) {
                return GefProcessor.getPartEMFName(GefProcessor.this.getModelObject(input), feature, false);
            }
        });
    }

    public static String getPartEMFName(EObject modelObject, String feature, boolean noCase) {
        if (modelObject != null) {
            EClass eClass = modelObject.eClass();
            EList attributes = eClass.getEAllAttributes();
            for (EAttribute eAttribute : attributes) {
                Object value;
                String fName = eAttribute.getName();
                if ((!noCase || !fName.equalsIgnoreCase(feature)) && (noCase || !fName.equals(feature)) || (value = modelObject.eGet((EStructuralFeature)eAttribute)) == null || !(value instanceof String)) continue;
                return (String)value;
            }
        }
        return null;
    }

    private EObject getModelObject(EditPart part) {
        List list = this.client.getProcessors(IGefReplayHelper.class);
        Object model = part.getModel();
        EObject modelObject = null;
        if (model != null && model instanceof EObject) {
            modelObject = (EObject)model;
        }
        for (IGefReplayHelper helper : list) {
            EObject emfModel = helper.getEMFMode(part);
            if (emfModel == null) continue;
            modelObject = emfModel;
        }
        return modelObject;
    }

    public EObject getElementModel(Element element) {
        FigureUIElement uiElement = (FigureUIElement)this.getMapper().get(element);
        RawFigureUIElement figureUiElement = (RawFigureUIElement)this.getFigureMapper().get(element);
        if (uiElement == null && figureUiElement == null) {
            return null;
        }
        Object model = uiElement != null ? this.getMappedModel(uiElement.getPart()) : GefModelMapper.figureMap(figureUiElement.getFigure());
        return model;
    }

    private SelectResponse selectEditPartByClassPattern(SelectCommand cmd, String classPattern, DiagramViewerUIElement diagram, GraphicalEditPart part) {
        String className;
        List children = this.getPartChildren(part.getChildren());
        Integer intIndex = cmd.getData().getIndex();
        int i = 0;
        for (Object object : children) {
            if (!(object instanceof EditPart) || !(className = object.getClass().getSimpleName()).equals(classPattern) && !className.matches(".*" + classPattern + ".*")) continue;
            if (intIndex == null || i == intIndex) {
                return this.toResponse(this.getMapper().get(new FigureUIElement((EditPart)object, diagram)));
            }
            ++i;
        }
        children = this.getPartChildren(part.getChildren());
        intIndex = cmd.getData().getIndex();
        i = 0;
        for (Object object : children) {
            if (!(object instanceof EditPart) || !(className = object.getClass().getSimpleName()).equals(classPattern) && !className.matches(".*" + classPattern + ".*")) continue;
            if (intIndex == null || i == intIndex) {
                return this.toResponse(this.getMapper().get(new FigureUIElement((EditPart)object, diagram)));
            }
            ++i;
        }
        return this.createFailedSelect(NLS.bind((String)TeslaGefMessages.GefProcessor_CannotFindEditPartByClass, (Object)classPattern));
    }

    private SelectResponse selectCanvasFigure(SelectData data, SWTUIElement canvasElement) {
        FigureCanvas figureCanvas = (FigureCanvas)canvasElement.unwrap();
        IFigure figure = this.getFigure((List<Integer>)data.getIndexes(), figureCanvas.getContents(), null);
        if (figure != null) {
            RawFigureUIElement result = new RawFigureUIElement(null, figure, null);
            result.setCanvas((Canvas)figureCanvas);
            Element element = this.getRawMapper().get(result);
            return this.toResponse(element);
        }
        return this.createFailedSelect(NLS.bind((String)TeslaGefMessages.GefProcessor_CannotFindFigureByAddress, (Object)Arrays.toString(data.getIndexes().toArray())));
    }

    private SelectResponse selectRawFigure(List<Integer> indexes, IFigure figure, EditPart part, GraphicalViewer viewer) {
        if (figure != null) {
            Element element = this.getRawMapper().get(new RawFigureUIElement(part, figure, viewer));
            return this.toResponse(element);
        }
        return this.createFailedSelect(NLS.bind((String)TeslaGefMessages.GefProcessor_CannotFindFigureByAddress, (Object)Arrays.toString(indexes.toArray())));
    }

    private SelectResponse selectEditPart(DiagramViewerUIElement uiEl, String failMessage, GraphicalEditPart editPart) {
        if (editPart != null) {
            Element element = this.getMapper().get(new FigureUIElement((EditPart)editPart, uiEl));
            return this.toResponse(element);
        }
        return this.createFailedSelect(NLS.bind((String)TeslaGefMessages.GefProcessor_CannotFindFigure_DetailedMsg, (Object)failMessage));
    }

    private SelectResponse selectPalette(SelectCommand cmd) {
        DiagramViewerUIElement element;
        SelectData data = cmd.getData();
        SWTUIElement result = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(data.getParent());
        if (result != null && result instanceof WorkbenchUIElement && (element = GefProcessor.getPaletteViewerElement((WorkbenchUIElement)result)) != null) {
            return this.toResponse(SWTElementMapper.getMapper((String)this.id).get((IBasicMappingNode)element));
        }
        if (result != null) {
            SWTUIElement[] children = this.getPlayer().children.collectFor(result, null, true, new Class[]{FigureCanvas.class});
            SWTUIElement figureCanvas = null;
            int index = -1;
            if (data.getIndex() != null) {
                index = data.getIndex();
            }
            if (index != -1 && children.length > index) {
                figureCanvas = children[index];
            }
            if (figureCanvas != null) {
                return this.toResponse(this.findDiagramViewerElement(figureCanvas, PaletteViewer.class, null, this.getPlayer()));
            }
            SWTUIElement[] sWTUIElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                SWTUIElement canvas = sWTUIElementArray[n2];
                Element e = this.findDiagramViewerElement(canvas, PaletteViewer.class, null, this.getPlayer());
                if (e != null) {
                    return this.toResponse(e);
                }
                ++n2;
            }
        }
        return this.createFailedSelect(TeslaGefMessages.GefProcessor_CannotFindPalette);
    }

    private SelectResponse selectDiagramViewer(SelectCommand cmd) {
        DiagramViewerUIElement element;
        SelectData data = cmd.getData();
        SWTUIElement result = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(data.getParent());
        if (result != null && result instanceof WorkbenchUIElement && (element = GefProcessor.getDiagramViewerElement((WorkbenchUIElement)result)) != null) {
            return this.toResponse(SWTElementMapper.getMapper((String)this.id).get((IBasicMappingNode)element));
        }
        if (result != null) {
            ArrayList<SWTUIElement> children = new ArrayList<SWTUIElement>(Arrays.asList(this.getPlayer().children.collectFor(result, null, true, new Class[]{FigureCanvas.class, Canvas.class})));
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                GraphicalViewer vv;
                SWTUIElement swtuiElement = (SWTUIElement)iterator.next();
                Widget widget = swtuiElement.unwrap();
                if (widget instanceof FigureCanvas || (vv = (GraphicalViewer)TeslaSWTAccess.getThis(GraphicalViewer.class, (Widget)widget, (int)12)) != null) continue;
                iterator.remove();
            }
            SWTUIElement figureCanvas = null;
            int index = -1;
            if (data.getIndex() != null) {
                index = data.getIndex();
            }
            if (index != -1 && children.size() > index) {
                figureCanvas = (SWTUIElement)children.get(index);
            }
            if (figureCanvas != null) {
                return this.toResponse(this.findDiagramViewerElement(figureCanvas, GraphicalViewer.class, PaletteViewer.class, this.getPlayer()));
            }
            for (SWTUIElement canvas : children) {
                Element e = this.findDiagramViewerElement(canvas, GraphicalViewer.class, PaletteViewer.class, this.getPlayer());
                if (e == null) continue;
                return this.toResponse(e);
            }
        }
        return this.createFailedSelect(TeslaGefMessages.GefProcessor_CannotFindDiagram);
    }

    private SelectResponse createFailedSelect(String msg) {
        SelectResponse response = ProtocolFactory.eINSTANCE.createSelectResponse();
        response.setStatus(ResponseStatus.FAILED);
        response.setMessage(msg);
        return response;
    }

    public static GraphicalViewer findDiagramViewer(SWTUIElement figureCanvas, Class cl, Class notcl) {
        Object viewer = null;
        viewer = GefProcessor.getViewer(figureCanvas.widget);
        if (viewer == null) {
            Listener[] listeners;
            Listener[] listenerArray = listeners = figureCanvas.widget.getListeners(12);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                Object eventListener = TeslaSWTAccess.tryUnwrapEventListener((Listener)listener);
                Object o = GefProcessor.getViewer(eventListener);
                if (cl.isInstance(o) && (notcl == null || !notcl.isInstance(o))) {
                    viewer = o;
                    break;
                }
                ++n2;
            }
        }
        if (cl.isInstance(viewer) && (notcl == null || !notcl.isInstance(viewer))) {
            return (GraphicalViewer)viewer;
        }
        return null;
    }

    public Element findDiagramViewerElement(SWTUIElement figureCanvas, Class cl, Class notcl, SWTUIPlayer player) {
        DiagramViewerUIElement element;
        GraphicalViewer graphicalViewer = GefProcessor.findDiagramViewer(figureCanvas, cl, notcl);
        if (graphicalViewer != null && (element = new DiagramViewerUIElement(player, graphicalViewer)) != null) {
            return SWTElementMapper.getMapper((String)this.id).get((IBasicMappingNode)element);
        }
        return null;
    }

    private static Object getViewer(Object widget) {
        Object viewer = TeslaGefAccess.getThis(widget);
        if (viewer != null) {
            return viewer;
        }
        return TeslaGefAccess.getArg(widget);
    }

    public static DiagramViewerUIElement getDiagramViewerElement(WorkbenchUIElement result) {
        GraphicalEditor editor = GefProcessor.getGraphicalEditor(result);
        if (editor != null) {
            GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
            return new DiagramViewerUIElement(result.getPlayer(), viewer);
        }
        return null;
    }

    public static DiagramViewerUIElement getPaletteViewerElement(WorkbenchUIElement result) {
        GraphicalEditor editor = GefProcessor.getGraphicalEditor(result);
        if (editor != null) {
            GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
            PaletteViewer paletteViewer = viewer.getEditDomain().getPaletteViewer();
            return new DiagramViewerUIElement(result.getPlayer(), (GraphicalViewer)paletteViewer);
        }
        return null;
    }

    private SWTUIPlayer getPlayer() {
        return ((SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class)).getPlayer();
    }

    private static GraphicalEditor getGraphicalEditor(WorkbenchUIElement swtuiElement) {
        WorkbenchUIElement e = swtuiElement;
        IWorkbenchPartReference reference = e.getReference();
        IWorkbenchPart part = reference.getPart(true);
        if (part instanceof GraphicalEditor) {
            return (GraphicalEditor)part;
        }
        return null;
    }

    public void postSelect(Element element, IElementProcessorMapper mapper) {
        SWTUIProcessor processor = (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
        SWTElementMapper elementMapper = SWTElementMapper.getMapper((String)processor.getId());
        SWTUIElement swtuiElement = (SWTUIElement)elementMapper.get(element);
        if (swtuiElement != null && swtuiElement.widget instanceof FigureCanvas) {
            mapper.map(element, (ITeslaCommandProcessor)this);
        }
    }

    public boolean isInactivityRequired() {
        return true;
    }

    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        return true;
    }

    public void clean() {
        this.getMapper().clear();
        this.getRawMapper().clear();
        this.openedDirectEdits.clear();
        this.dragParts.clear();
        AutoExpandLevels.clear();
        TeslaDirectEditManager.getInstance().clean();
    }

    public FigureElementMapper getMapper() {
        return FigureElementMapper.getMapper(this.getFeatureID());
    }

    public RawFigureElementMapper getFigureMapper() {
        return RawFigureElementMapper.getMapper(this.getFeatureID());
    }

    public void terminate() {
        FigureElementMapper.remove(this.getFeatureID());
        RawFigureElementMapper.remove(this.getFeatureID());
        this.client = null;
        this.dragParts.clear();
        this.openedDirectEdits.clear();
    }

    private void scrollToPosition(FigureCanvas canvas, int targetX, int targetY) {
        Rectangle clientArea = canvas.getViewport().getClientArea();
        if (targetX < clientArea.x || targetY < clientArea.y || targetX > clientArea.x + clientArea.width || targetY > clientArea.y + clientArea.height) {
            if (targetX < clientArea.x) {
                targetX = Math.max(0, targetX - 5);
            }
            if (targetX > clientArea.x + clientArea.width) {
                targetX = Math.min(clientArea.x + clientArea.width, targetX + 5);
            }
            if (targetY < clientArea.y) {
                targetY = Math.max(0, targetY - 5);
            }
            if (targetY > clientArea.y + clientArea.height) {
                targetY = Math.min(clientArea.y + clientArea.height, targetY + 5);
            }
            canvas.scrollSmoothTo(targetX, targetY);
        }
    }

    private void scrollToFigure(FigureCanvas canvas, IFigure figure) {
        Viewport port = canvas.getViewport();
        IFigure target = figure;
        Rectangle exposeRegion = target.getBounds().getCopy();
        target = target.getParent();
        while (target != null && target != port) {
            target.translateToParent((Translatable)exposeRegion);
            target = target.getParent();
        }
        exposeRegion.expand(5, 5);
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
        Point finalLocation = new Point();
        finalLocation.x = viewportSize.width < exposeRegion.width ? Math.min(bottomRight.x, Math.max(topLeft.x, port.getViewLocation().x)) : Math.min(topLeft.x, Math.max(bottomRight.x, port.getViewLocation().x));
        finalLocation.y = viewportSize.height < exposeRegion.height ? Math.min(bottomRight.y, Math.max(topLeft.y, port.getViewLocation().y)) : Math.min(topLeft.y, Math.max(bottomRight.y, port.getViewLocation().y));
        canvas.scrollSmoothTo(finalLocation.x, finalLocation.y);
    }

    public RawFigureElementMapper getRawMapper() {
        return RawFigureElementMapper.getMapper(this.getFeatureID());
    }

    public void checkHang() {
    }

    public void collectInformation(AdvancedInformation information, Command lastCommand) {
        InfoUtils.Node root = InfoUtils.newNode((String)"gef.editparts").add(information);
        Element element = null;
        if (lastCommand instanceof ElementCommand) {
            element = ((ElementCommand)lastCommand).getElement();
        } else if (lastCommand instanceof Assert) {
            element = ((Assert)lastCommand).getElement();
        } else if (lastCommand instanceof SelectCommand) {
            element = ((SelectCommand)lastCommand).getData().getParent();
        }
        if (element != null) {
            DiagramViewerUIElement diagram;
            FigureUIElement figureUIElement = (FigureUIElement)this.getMapper().get(element);
            if (figureUIElement != null) {
                diagram = figureUIElement.getDiagram();
            } else {
                SWTUIElement swtuiElement = (SWTUIElement)SWTElementMapper.getMapper((String)this.id).get(element);
                if (swtuiElement instanceof DiagramViewerUIElement) {
                    diagram = (DiagramViewerUIElement)swtuiElement;
                } else {
                    return;
                }
            }
            if (diagram != null) {
                GraphicalViewer viewer = diagram.getViewer();
                RootEditPart part = viewer.getRootEditPart();
                HashMap<IFigure, EditPart> allEditPartFigures = new HashMap<IFigure, EditPart>();
                this.fillEditPartFigures(allEditPartFigures, viewer.getContents());
                this.collectPartInfo(root, (EditPart)part, allEditPartFigures);
            }
        }
    }

    private void fillEditPartFigures(Map<IFigure, EditPart> allEditPartFigures, EditPart contents) {
        List children = contents.getChildren();
        for (EditPart editPart : children) {
            if (editPart instanceof GraphicalEditPart) {
                allEditPartFigures.put(((GraphicalEditPart)editPart).getFigure(), editPart);
            }
            this.fillEditPartFigures(allEditPartFigures, editPart);
        }
    }

    private void collectPartInfo(InfoUtils.Node root, EditPart part, Map<IFigure, EditPart> allEditPartFigures) {
        GraphicalEditPart p;
        IFigure figure;
        if (part instanceof GraphicalEditPart && (figure = (p = (GraphicalEditPart)part).getFigure()) != null) {
            List<Integer> address = GefUtils.getAddressRaw((EditPart)p);
            InfoUtils.Node infoNode = root.child("edit part:" + Arrays.toString(address.toArray()));
            infoNode.property("class", part.getClass().getSimpleName());
            if (figure.isVisible() != figure.isShowing()) {
                infoNode.property("visible.not.showing", "true");
            }
            if (!figure.isVisible()) {
                infoNode.property("visible", (Object)figure.isVisible());
            }
            if (!figure.isShowing()) {
                infoNode.property("showing", (Object)figure.isShowing());
            }
            if (figure.isOpaque()) {
                infoNode.property("opaque", (Object)figure.isOpaque());
            }
            this.processFigures(infoNode.child("figures"), figure, figure, allEditPartFigures, false);
        }
        List children = part.getChildren();
        for (Object object : children) {
            if (!(object instanceof EditPart)) continue;
            this.collectPartInfo(root, (EditPart)object, allEditPartFigures);
        }
    }

    private void processFigures(InfoUtils.Node figuresNode, IFigure iFigure, IFigure parent, Map<IFigure, EditPart> allEditPartFigures, boolean filter) {
        Class<?> clazz = iFigure.getClass();
        String simpleName = clazz.getSimpleName();
        List<Integer> address = GefUtils.getAddress(iFigure, parent);
        InfoUtils.Node child = figuresNode.child("figure:" + Arrays.toString(address.toArray()));
        child.property("class ", simpleName);
        if (iFigure instanceof Label) {
            child.property("text", ((Label)iFigure).getText());
        }
        if (iFigure instanceof TextFlow) {
            child.property("text", ((TextFlow)iFigure).getText());
        }
        List children = iFigure.getChildren();
        for (Object object : children) {
            if (allEditPartFigures.containsKey(object) && filter) continue;
            this.processFigures(figuresNode, (IFigure)object, parent, allEditPartFigures, true);
        }
    }

    public static String getPartCustomId(EditPart part) {
        try {
            return IdentifyObjectUtil.getObjectIdByClassMethods((Object)part);
        }
        catch (CoreException e) {
            GefActivator.log(e);
            return null;
        }
    }

    public static String getPartClassName(EditPart part) {
        String className = part.getClass().getSimpleName();
        return className;
    }

    public static String getPartText(org.eclipse.rcptt.tesla.core.ui.Widget model) {
        DiagramItem item;
        String text;
        if (model instanceof DiagramItem && (text = (item = (DiagramItem)model).getText()) != null && !text.trim().isEmpty()) {
            return text;
        }
        return null;
    }

    public void notifyUI() {
    }
}

