/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.ifeature;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.core.ifeature.IEnvironment;

class EnvironmentHelper {
    private static final Pattern ENVIRONMENT_FILTER_ELEMENT_SEPARATOR = Pattern.compile(",");

    private EnvironmentHelper() {
    }

    static boolean matchesTargetEnvironment(IEnvironment environment, ITargetDefinition target) {
        return EnvironmentHelper.matchesProperty(environment.getOS(), target, ITargetDefinition::getOS, Platform::getOS) && EnvironmentHelper.matchesProperty(environment.getWS(), target, ITargetDefinition::getWS, Platform::getWS) && EnvironmentHelper.matchesProperty(environment.getArch(), target, ITargetDefinition::getArch, Platform::getOSArch) && EnvironmentHelper.matchesProperty(environment.getNL(), target, ITargetDefinition::getNL, Platform::getNL);
    }

    private static boolean matchesProperty(String filter, ITargetDefinition target, Function<ITargetDefinition, String> targetGetter, Supplier<String> defaultValue) {
        if (filter == null) {
            return true;
        }
        String targetEnvironment = targetGetter.apply(target);
        if (targetEnvironment == null) {
            targetEnvironment = defaultValue.get();
        }
        return ENVIRONMENT_FILTER_ELEMENT_SEPARATOR.splitAsStream(filter).map(String::strip).anyMatch(targetEnvironment::equals);
    }
}

