/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.commands.SelectColumns;
import org.eclipse.rcptt.ecl.data.internal.EclDataPlugin;
import org.eclipse.rcptt.ecl.data.objects.ObjectsFactory;
import org.eclipse.rcptt.ecl.data.objects.Row;
import org.eclipse.rcptt.ecl.data.objects.Table;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class SelectColumnsService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws CoreException {
        if (!(command instanceof SelectColumns)) {
            return Status.CANCEL_STATUS;
        }
        SelectColumns ec = (SelectColumns)command;
        Table source = ec.getTable();
        EList<String> srcColumns = source.getColumns();
        EList<String> destColumns = ec.getColumns();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int i = 0;
        while (i < destColumns.size()) {
            String destColumn = (String)destColumns.get(i);
            int index = srcColumns.indexOf(destColumn);
            if (index == -1) {
                return EclDataPlugin.createErr("Source table does not contain column '%s'", destColumn);
            }
            indices.add(index);
            ++i;
        }
        Table result = ObjectsFactory.eINSTANCE.createTable();
        result.getColumns().addAll(destColumns);
        for (Row row : source.getRows()) {
            result.getRows().add((Object)SelectColumnsService.extractSubrow(row, indices));
        }
        context.getOutput().write((Object)result);
        return Status.OK_STATUS;
    }

    static Row extractSubrow(Row src, List<Integer> indices) {
        Row result = ObjectsFactory.eINSTANCE.createRow();
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            result.getValues().add((Object)((String)src.getValues().get(index)));
        }
        for (Row child : src.getChildren()) {
            result.getChildren().add((Object)SelectColumnsService.extractSubrow(child, indices));
        }
        return result;
    }
}

