/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.nls.ExternalizeStringsProcessor;
import org.eclipse.pde.internal.ui.nls.ExternalizeStringsWizard;
import org.eclipse.pde.internal.ui.nls.GetNonExternalizedStringsOperation;
import org.eclipse.pde.internal.ui.nls.ModelChangeTable;
import org.eclipse.pde.internal.ui.refactoring.PDERefactor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class GetNonExternalizedStringsAction
extends AbstractHandler {
    private boolean fExternalizeSelectedPluginsOnly = false;
    private boolean fSkipMessageDialog = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.runGetNonExternalizedStringsAction(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        return null;
    }

    public void runGetNonExternalizedStringsAction(ISelection selection) {
        GetNonExternalizedStringsOperation runnable = new GetNonExternalizedStringsOperation(selection, this.fExternalizeSelectedPluginsOnly);
        try {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                if (runnable.wasCanceled()) {
                    return;
                }
                ModelChangeTable changeTable = runnable.getChangeTable();
                if (!changeTable.isEmpty()) {
                    ExternalizeStringsProcessor processor = new ExternalizeStringsProcessor();
                    PDERefactor refactor = new PDERefactor(processor);
                    ExternalizeStringsWizard wizard = new ExternalizeStringsWizard(changeTable, refactor);
                    RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                    try {
                        op.run(PDEPlugin.getActiveWorkbenchShell(), "");
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (!this.fSkipMessageDialog) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedTitle, (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedMessage);
                }
            }
        }
        finally {
            if (runnable.wasCanceled()) {
                return;
            }
            ModelChangeTable changeTable = runnable.getChangeTable();
            if (!changeTable.isEmpty()) {
                ExternalizeStringsProcessor processor = new ExternalizeStringsProcessor();
                PDERefactor refactor = new PDERefactor(processor);
                ExternalizeStringsWizard wizard = new ExternalizeStringsWizard(changeTable, refactor);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                try {
                    op.run(PDEPlugin.getActiveWorkbenchShell(), "");
                }
                catch (InterruptedException interruptedException) {}
            } else if (!this.fSkipMessageDialog) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedTitle, (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedMessage);
            }
        }
    }

    public void setExternalizeSelectedPluginsOnly(boolean externalizeSelectedPluginsOnly) {
        this.fExternalizeSelectedPluginsOnly = externalizeSelectedPluginsOnly;
    }

    public boolean isExternalizeSelectedPluginsOnly() {
        return this.fExternalizeSelectedPluginsOnly;
    }

    public void setSkipMessageDialog(boolean skipMessageDialog) {
        this.fSkipMessageDialog = skipMessageDialog;
    }

    public boolean isSkipMessageDialog() {
        return this.fSkipMessageDialog;
    }
}

