/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.http;

import java.io.IOException;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.http.client.query.AbstractHTTPQuery;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.explanation.Explanation;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.http.HTTPQueryEvaluationException;
import org.eclipse.rdf4j.repository.http.HTTPRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class HTTPGraphQuery
extends AbstractHTTPQuery
implements GraphQuery {
    private final HTTPRepositoryConnection conn;

    public HTTPGraphQuery(HTTPRepositoryConnection conn, QueryLanguage ql, String queryString, String baseURI) {
        super(conn.getSesameSession(), ql, queryString, baseURI);
        this.conn = conn;
    }

    @Override
    public GraphQueryResult evaluate() throws QueryEvaluationException {
        SPARQLProtocolSession client = this.getHttpClient();
        try {
            this.conn.flushTransactionState(Protocol.Action.QUERY);
            return client.sendGraphQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.getIncludeInferred(), this.getMaxExecutionTime(), this.getBindingsArray());
        }
        catch (IOException | MalformedQueryException | RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }

    @Override
    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        SPARQLProtocolSession client = this.getHttpClient();
        try {
            this.conn.flushTransactionState(Protocol.Action.QUERY);
            client.sendGraphQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.includeInferred, this.getMaxExecutionTime(), handler, this.getBindingsArray());
        }
        catch (IOException | MalformedQueryException | RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }

    @Override
    public Explanation explain(Explanation.Level level) {
        throw new UnsupportedOperationException();
    }
}

