/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class Floor
implements Function {
    @Override
    public String getURI() {
        return FN.NUMERIC_FLOOR.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("FLOOR requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            CoreDatatype.XSD datatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
            if (datatype != null && datatype.isNumericDatatype()) {
                if (datatype.isIntegerDatatype()) {
                    return literal;
                }
                if (datatype.isDecimalDatatype()) {
                    BigDecimal floor = literal.decimalValue().setScale(0, RoundingMode.FLOOR);
                    return valueFactory.createLiteral(floor.toPlainString(), datatype);
                }
                if (datatype.isFloatingPointDatatype()) {
                    double floor = Math.floor(literal.doubleValue());
                    return valueFactory.createLiteral(Double.toString(floor), datatype);
                }
                throw new ValueExprEvaluationException("unexpected datatype for function operand: " + args[0]);
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

