/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.CloseablePeakableIteration;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unique
implements PlanNode {
    private final Logger logger = LoggerFactory.getLogger(Unique.class);
    private final boolean compress;
    private StackTraceElement[] stackTrace;
    private final PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    private Unique(PlanNode parent, boolean compress, ConnectionsGroup connectionsGroup) {
        PlanNode tempParent = PlanNodeHelper.handleSorting(this, parent, connectionsGroup);
        if (tempParent instanceof Unique) {
            Unique parentUnique = (Unique)tempParent;
            tempParent = parentUnique.parent;
            if (!compress) {
                compress = parentUnique.compress;
            }
        }
        this.parent = tempParent;
        this.compress = compress;
    }

    public static PlanNode getInstance(PlanNode parent, boolean compress, ConnectionsGroup connectionsGroup) {
        if (parent.isGuaranteedEmpty()) {
            return parent;
        }
        if (parent instanceof Unique && (!compress || ((Unique)parent).compress == compress)) {
            return parent;
        }
        return new Unique(parent, compress, connectionsGroup);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseablePeakableIteration<? extends ValidationTuple> parentIterator;
            Set<ValidationTupleValueAndActiveTarget> targetAndValueDedupeSet;
            boolean propertyShapeWithValue;
            ValidationTuple next;
            ValidationTuple previous;

            @Override
            protected void init() {
                this.parentIterator = Unique.this.compress ? new CloseablePeakableIteration<ValidationTuple>(new TargetAndValueSortIterator(new CloseablePeakableIteration<ValidationTuple>(Unique.this.parent.iterator()))) : new CloseablePeakableIteration<ValidationTuple>(Unique.this.parent.iterator());
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                while (this.next == null && this.parentIterator.hasNext()) {
                    ValidationTuple temp = this.parentIterator.next();
                    assert (!this.propertyShapeWithValue || temp.getScope() == ConstraintComponent.Scope.propertyShape && temp.hasValue());
                    if (temp.getScope() == ConstraintComponent.Scope.propertyShape && temp.hasValue()) {
                        this.propertyShapeWithValue = true;
                    }
                    if (Unique.this.compress) {
                        HashSet<ValidationTuple> tuples = new HashSet<ValidationTuple>();
                        if (this.propertyShapeWithValue) {
                            if (this.parentIterator.hasNext()) {
                                this.parentIterator.peek();
                            }
                            while (this.parentIterator.hasNext() && this.parentIterator.peek().getValue().equals(temp.getValue()) && this.parentIterator.peek().sameTargetAs(temp)) {
                                tuples.add(this.parentIterator.next());
                            }
                        } else {
                            while (this.parentIterator.hasNext() && this.parentIterator.peek().sameTargetAs(temp)) {
                                tuples.add(this.parentIterator.next());
                            }
                        }
                        if (tuples.isEmpty()) {
                            this.next = temp;
                        } else if (tuples.size() == 1 && tuples.contains(temp)) {
                            this.next = temp;
                        } else {
                            tuples.add(temp);
                            this.next = new ValidationTuple(temp, tuples);
                        }
                    } else if (this.previous == null) {
                        this.next = temp;
                    } else if (this.propertyShapeWithValue) {
                        if (this.targetAndValueDedupeSet == null || !this.previous.sameTargetAs(temp)) {
                            this.targetAndValueDedupeSet = new HashSet<ValidationTupleValueAndActiveTarget>();
                            if (this.previous.sameTargetAs(temp)) {
                                this.targetAndValueDedupeSet.add(new ValidationTupleValueAndActiveTarget(this.previous));
                            }
                        }
                        if (!this.targetAndValueDedupeSet.contains(new ValidationTupleValueAndActiveTarget(temp))) {
                            this.next = temp;
                            this.targetAndValueDedupeSet.add(new ValidationTupleValueAndActiveTarget(this.next));
                        }
                    } else if (!this.previous.sameTargetAs(temp)) {
                        this.next = temp;
                    }
                    if (this.next != null) {
                        this.previous = this.next;
                        continue;
                    }
                    if (!Unique.this.validationExecutionLogger.isEnabled()) continue;
                    Unique.this.validationExecutionLogger.log(Unique.this.depth(), Unique.this.getClass().getSimpleName() + ":IgnoredNotUnique ", temp, Unique.this, Unique.this.getId(), Unique.this.stackTrace != null ? Unique.this.stackTrace[2].toString() : null);
                }
            }

            @Override
            public void localClose() {
                if (this.parentIterator != null) {
                    this.parentIterator.close();
                }
                this.targetAndValueDedupeSet = null;
                this.next = null;
                this.previous = null;
            }

            @Override
            protected boolean localHasNext() {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            protected ValidationTuple loggingNext() {
                this.calculateNext();
                assert (this.previous == null || this.next.compareActiveTarget(this.previous) >= 0);
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Unique unique = (Unique)o;
        return this.parent.equals(unique.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent);
    }

    public String toString() {
        return "Unique{compress=" + this.compress + "}";
    }

    static class TargetAndValueSortIterator
    implements CloseableIteration<ValidationTuple> {
        private final CloseablePeakableIteration<? extends ValidationTuple> iterator;
        private Iterator<ValidationTuple> next = Collections.emptyIterator();

        public TargetAndValueSortIterator(CloseablePeakableIteration<? extends ValidationTuple> iterator) {
            this.iterator = iterator;
        }

        private void calculateNext() {
            if (this.next.hasNext()) {
                return;
            }
            if (!this.iterator.hasNext()) {
                return;
            }
            ArrayList<ValidationTuple> validationTuples = new ArrayList<ValidationTuple>();
            ValidationTuple temp = this.iterator.next();
            if (temp.getScope() == ConstraintComponent.Scope.propertyShape && temp.hasValue()) {
                while (this.iterator.hasNext() && temp.sameTargetAs(this.iterator.peek()) && this.iterator.peek().getScope() == ConstraintComponent.Scope.propertyShape && this.iterator.peek().hasValue()) {
                    validationTuples.add(this.iterator.next());
                }
            }
            if (validationTuples.isEmpty()) {
                this.next = Collections.singletonList(temp).iterator();
            } else {
                validationTuples.add(temp);
                ValueComparator valueComparator = new ValueComparator();
                validationTuples.sort((a, b) -> valueComparator.compare(a.getValue(), b.getValue()));
                this.next = validationTuples.iterator();
            }
        }

        @Override
        public void close() throws SailException {
            this.iterator.close();
        }

        @Override
        public boolean hasNext() throws SailException {
            this.calculateNext();
            return this.next.hasNext();
        }

        @Override
        public ValidationTuple next() throws SailException {
            this.calculateNext();
            return this.next.next();
        }

        @Override
        public void remove() throws SailException {
            throw new UnsupportedOperationException();
        }
    }

    static class ValidationTupleValueAndActiveTarget {
        private final ValidationTuple validationTuple;

        public ValidationTupleValueAndActiveTarget(ValidationTuple validationTuple) {
            this.validationTuple = validationTuple;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidationTupleValueAndActiveTarget oValidationTuple = (ValidationTupleValueAndActiveTarget)o;
            if (this.validationTuple.hasValue() || oValidationTuple.validationTuple.hasValue()) {
                assert (this.validationTuple.hasValue() && oValidationTuple.validationTuple.hasValue());
                return this.validationTuple.getValue().equals(oValidationTuple.validationTuple.getValue()) && this.validationTuple.getActiveTarget().equals(oValidationTuple.validationTuple.getActiveTarget());
            }
            return this.validationTuple.getActiveTarget().equals(oValidationTuple.validationTuple.getActiveTarget());
        }

        public int hashCode() {
            return Objects.hash(this.validationTuple.getActiveTarget(), this.validationTuple.getValue());
        }
    }
}

