/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.ArrayBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.PeekMarkIterator;

@Experimental
public class InnerMergeJoinIterator
implements CloseableIteration<BindingSet> {
    private final PeekMarkIterator<BindingSet> leftIterator;
    private final PeekMarkIterator<BindingSet> rightIterator;
    private final Comparator<Value> cmp;
    private final Function<BindingSet, Value> valueFunction;
    private final QueryEvaluationContext context;
    private BindingSet next;
    private BindingSet currentLeft;
    private Value currentLeftValue;
    private Value leftPeekValue;
    int currentLeftValueAndPeekEquals = -1;
    private boolean closed = false;

    InnerMergeJoinIterator(CloseableIteration<BindingSet> leftIterator, CloseableIteration<BindingSet> rightIterator, Comparator<Value> cmp, Function<BindingSet, Value> valueFunction, QueryEvaluationContext context) throws QueryEvaluationException {
        this.leftIterator = new PeekMarkIterator<BindingSet>(leftIterator);
        this.rightIterator = new PeekMarkIterator<BindingSet>(rightIterator);
        this.cmp = cmp;
        this.valueFunction = valueFunction;
        this.context = context;
    }

    public static CloseableIteration<BindingSet> getInstance(QueryEvaluationStep leftPrepared, QueryEvaluationStep preparedRight, BindingSet bindings, Comparator<Value> cmp, Function<BindingSet, Value> value, QueryEvaluationContext context) {
        CloseableIteration<BindingSet> leftIter = leftPrepared.evaluate(bindings);
        if (leftIter == QueryEvaluationStep.EMPTY_ITERATION) {
            return leftIter;
        }
        CloseableIteration<BindingSet> rightIter = preparedRight.evaluate(bindings);
        if (rightIter == QueryEvaluationStep.EMPTY_ITERATION) {
            leftIter.close();
            return rightIter;
        }
        return new InnerMergeJoinIterator(leftIter, rightIter, cmp, value, context);
    }

    private BindingSet join(BindingSet left, BindingSet right, boolean createNewBindingSet) {
        MutableBindingSet joined = !createNewBindingSet && left instanceof MutableBindingSet ? (MutableBindingSet)left : this.context.createBindingSet(left);
        if (joined instanceof ArrayBindingSet && right instanceof ArrayBindingSet) {
            ((ArrayBindingSet)joined).addAll((ArrayBindingSet)right);
            return joined;
        }
        for (Binding binding : right) {
            if (joined.hasBinding(binding.getName())) continue;
            joined.addBinding(binding);
        }
        return joined;
    }

    private void calculateNext() {
        if (this.next != null) {
            return;
        }
        if (this.currentLeft == null && this.leftIterator.hasNext()) {
            this.currentLeft = this.leftIterator.next();
            this.currentLeftValue = null;
            this.leftPeekValue = null;
            this.currentLeftValueAndPeekEquals = -1;
        }
        if (this.currentLeft == null) {
            return;
        }
        this.loop();
    }

    private void loop() {
        while (this.next == null) {
            if (this.rightIterator.hasNext()) {
                int compare;
                BindingSet peekRight = this.rightIterator.peek();
                if (this.currentLeftValue == null) {
                    this.currentLeftValue = this.valueFunction.apply(this.currentLeft);
                    this.leftPeekValue = null;
                    this.currentLeftValueAndPeekEquals = -1;
                }
                if ((compare = this.compare(this.currentLeftValue, this.valueFunction.apply(peekRight))) == 0) {
                    this.equal();
                    return;
                }
                if (compare < 0) {
                    if (this.leftIterator.hasNext()) {
                        this.lessThan();
                        continue;
                    }
                    this.close();
                    return;
                }
                this.rightIterator.next();
                continue;
            }
            if (this.rightIterator.isResettable() && this.leftIterator.hasNext()) {
                this.rightIterator.reset();
                this.currentLeft = this.leftIterator.next();
                this.currentLeftValue = null;
                this.leftPeekValue = null;
                this.currentLeftValueAndPeekEquals = -1;
                continue;
            }
            this.close();
            return;
        }
    }

    private int compare(Value left, Value right) {
        int compareTo = left == right ? 0 : this.cmp.compare(left, right);
        return compareTo;
    }

    private void lessThan() {
        Value oldLeftValue = this.currentLeftValue;
        this.currentLeft = this.leftIterator.next();
        this.currentLeftValue = this.leftPeekValue != null ? this.leftPeekValue : this.valueFunction.apply(this.currentLeft);
        this.leftPeekValue = null;
        this.currentLeftValueAndPeekEquals = -1;
        if (oldLeftValue.equals(this.currentLeftValue)) {
            if (this.rightIterator.isResettable()) {
                this.rightIterator.reset();
            }
        } else {
            this.rightIterator.unmark();
        }
    }

    private void equal() {
        if (this.rightIterator.isResettable()) {
            this.next = this.join(this.currentLeft, this.rightIterator.next(), true);
        } else {
            this.doLeftPeek();
            if (this.currentLeftValueAndPeekEquals == 0) {
                this.rightIterator.mark();
                this.next = this.join(this.currentLeft, this.rightIterator.next(), true);
            } else {
                this.next = this.join(this.rightIterator.next(), this.currentLeft, false);
            }
        }
    }

    private void doLeftPeek() {
        if (this.leftPeekValue == null) {
            BindingSet leftPeek = this.leftIterator.peek();
            this.leftPeekValue = leftPeek != null ? this.valueFunction.apply(leftPeek) : null;
            this.currentLeftValueAndPeekEquals = -1;
        }
        if (this.currentLeftValueAndPeekEquals == -1) {
            boolean equals = this.currentLeftValue.equals(this.leftPeekValue);
            if (equals) {
                this.currentLeftValue = this.leftPeekValue;
                this.currentLeftValueAndPeekEquals = 0;
            } else {
                this.currentLeftValueAndPeekEquals = 1;
            }
        }
    }

    public final boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        this.calculateNext();
        return this.next != null;
    }

    public final BindingSet next() {
        BindingSet result;
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        this.calculateNext();
        if (this.next == null) {
            this.close();
        }
        if ((result = this.next) != null) {
            this.next = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.leftIterator.close();
            }
            finally {
                this.rightIterator.close();
            }
        }
    }
}

