/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.mapdb.elsa.ElsaSerializerPojo;

public class ElsaObjectOutputStream
extends ObjectOutputStream {
    protected final DataOutput out;
    protected final ElsaSerializerPojo serializer;

    public ElsaObjectOutputStream(DataOutput out, ElsaSerializerPojo serializer) throws IOException {
        this.out = out;
        this.serializer = serializer;
    }

    public ElsaObjectOutputStream(OutputStream out) throws IOException {
        this(new DataOutputStream(out), new ElsaSerializerPojo());
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        this.serializer.serialize(this.out, obj);
    }

    @Override
    public void close() throws IOException {
        if (this.out instanceof Closeable) {
            ((Closeable)((Object)this.out)).close();
        }
    }
}

