/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.http.config;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.http.config.HTTPRepositorySchema;

public class HTTPRepositoryConfig
extends AbstractRepositoryImplConfig {
    private String url;
    private String username;
    private String password;

    public HTTPRepositoryConfig() {
        super("openrdf:HTTPRepository");
    }

    public HTTPRepositoryConfig(String url) {
        this();
        this.setURL(url);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.url == null) {
            throw new RepositoryConfigException("No URL specified for HTTP repository");
        }
    }

    public Resource export(Model graph) {
        if (Configurations.useLegacyConfig()) {
            return this.exportLegacy(graph);
        }
        Resource implNode = super.export(graph);
        if (this.url != null) {
            graph.setNamespace(CONFIG.NS);
            graph.add(implNode, CONFIG.Http.url, (Value)SimpleValueFactory.getInstance().createIRI(this.url), new Resource[0]);
        }
        return implNode;
    }

    private Resource exportLegacy(Model graph) {
        Resource implNode = super.export(graph);
        if (this.url != null) {
            graph.setNamespace("http", "http://www.openrdf.org/config/repository/http#");
            graph.add(implNode, HTTPRepositorySchema.REPOSITORYURL, (Value)SimpleValueFactory.getInstance().createIRI(this.url), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Model model, Resource implNode) throws RepositoryConfigException {
        super.parse(model, implNode);
        try {
            Configurations.getIRIValue((Model)model, (Resource)implNode, (IRI)CONFIG.Http.url, (IRI)HTTPRepositorySchema.REPOSITORYURL).ifPresent(iri -> this.setURL(iri.stringValue()));
            Configurations.getLiteralValue((Model)model, (Resource)implNode, (IRI)CONFIG.Http.username, (IRI)HTTPRepositorySchema.USERNAME).ifPresent(username -> this.setUsername(username.getLabel()));
            Configurations.getLiteralValue((Model)model, (Resource)implNode, (IRI)CONFIG.Http.password, (IRI)HTTPRepositorySchema.PASSWORD).ifPresent(password -> this.setPassword(password.getLabel()));
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

