/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;

public class DescribeIteration
extends LookAheadIteration<BindingSet> {
    protected static final String VARNAME_SUBJECT = "subject";
    protected static final String VARNAME_PREDICATE = "predicate";
    protected static final String VARNAME_OBJECT = "object";
    private final List<String> describeExprNames;
    private final EvaluationStrategy strategy;
    private Value startValue;
    private final Queue<BNode> nodeQueue = new ArrayDeque<BNode>();
    private final Set<BNode> processedNodes = new HashSet<BNode>();
    private CloseableIteration<BindingSet> currentDescribeExprIter;
    private Mode currentMode = Mode.OUTGOING_LINKS;
    private final CloseableIteration<BindingSet> sourceIter;
    private BindingSet currentBindings;
    private int describeExprsIndex;
    protected BindingSet parentBindings;

    public DescribeIteration(CloseableIteration<BindingSet> sourceIter, EvaluationStrategy strategy, Set<String> describeExprNames, BindingSet parentBindings) {
        this.strategy = strategy;
        this.sourceIter = sourceIter;
        this.describeExprNames = new ArrayList<String>(describeExprNames);
        this.parentBindings = parentBindings;
    }

    private void resetCurrentDescribeExprIter() throws QueryEvaluationException {
        while (this.currentDescribeExprIter == null) {
            String nextValueExpr;
            if (this.currentBindings == null && this.startValue == null) {
                if (this.sourceIter.hasNext()) {
                    this.currentBindings = (BindingSet)this.sourceIter.next();
                } else {
                    return;
                }
            }
            if (this.startValue == null && (nextValueExpr = this.describeExprNames.get(this.describeExprsIndex++)) != null) {
                this.startValue = this.currentBindings.getValue(nextValueExpr);
                if (this.describeExprsIndex == this.describeExprNames.size()) {
                    this.currentBindings = null;
                    this.describeExprsIndex = 0;
                }
                this.currentMode = Mode.OUTGOING_LINKS;
            }
            switch (this.currentMode) {
                case OUTGOING_LINKS: {
                    this.currentDescribeExprIter = this.createNextIteration(this.startValue, null);
                    if (this.currentDescribeExprIter.hasNext()) break;
                    this.currentDescribeExprIter.close();
                    this.currentDescribeExprIter = null;
                    this.currentMode = Mode.INCOMING_LINKS;
                    break;
                }
                case INCOMING_LINKS: {
                    this.currentDescribeExprIter = this.createNextIteration(null, this.startValue);
                    if (this.currentDescribeExprIter.hasNext()) break;
                    this.currentDescribeExprIter.close();
                    this.currentDescribeExprIter = null;
                    this.startValue = null;
                    this.currentMode = Mode.OUTGOING_LINKS;
                }
            }
        }
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        this.resetCurrentDescribeExprIter();
        if (this.currentDescribeExprIter == null) {
            return null;
        }
        while (!this.currentDescribeExprIter.hasNext() && !this.nodeQueue.isEmpty()) {
            BNode nextNode = this.nodeQueue.poll();
            this.currentDescribeExprIter.close();
            switch (this.currentMode) {
                case OUTGOING_LINKS: {
                    this.currentDescribeExprIter = this.createNextIteration(nextNode, null);
                    break;
                }
                case INCOMING_LINKS: {
                    this.currentDescribeExprIter = this.createNextIteration(null, nextNode);
                }
            }
            this.processedNodes.add(nextNode);
            if (!this.nodeQueue.isEmpty() || this.currentDescribeExprIter.hasNext()) continue;
            this.currentDescribeExprIter.close();
            this.currentDescribeExprIter = null;
            if (this.currentMode == Mode.OUTGOING_LINKS) {
                this.currentMode = Mode.INCOMING_LINKS;
            } else {
                this.currentMode = Mode.OUTGOING_LINKS;
                this.startValue = null;
            }
            this.resetCurrentDescribeExprIter();
            if (this.currentDescribeExprIter != null) continue;
            return null;
        }
        if (this.currentDescribeExprIter.hasNext()) {
            String varname;
            BindingSet bs = (BindingSet)this.currentDescribeExprIter.next();
            Value v = bs.getValue(varname = this.currentMode == Mode.OUTGOING_LINKS ? VARNAME_OBJECT : VARNAME_SUBJECT);
            if (v instanceof BNode && !this.processedNodes.contains(v)) {
                this.nodeQueue.add((BNode)v);
            }
            if (!this.currentDescribeExprIter.hasNext() && this.nodeQueue.isEmpty()) {
                this.currentDescribeExprIter.close();
                this.currentDescribeExprIter = null;
                if (this.currentMode == Mode.OUTGOING_LINKS) {
                    this.currentMode = Mode.INCOMING_LINKS;
                } else {
                    this.currentMode = Mode.OUTGOING_LINKS;
                    this.startValue = null;
                }
            }
            return bs;
        }
        return null;
    }

    protected CloseableIteration<BindingSet> createNextIteration(Value subject, Value object) throws QueryEvaluationException {
        if (subject == null && object == null) {
            return QueryEvaluationStep.EMPTY_ITERATION;
        }
        Var subjVar = new Var(VARNAME_SUBJECT, subject);
        Var predVar = new Var(VARNAME_PREDICATE);
        Var objVar = new Var(VARNAME_OBJECT, object);
        StatementPattern pattern = new StatementPattern(subjVar, predVar, objVar);
        return this.strategy.evaluate(pattern, this.parentBindings);
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            if (this.currentDescribeExprIter != null) {
                this.currentDescribeExprIter.close();
            }
        }
        finally {
            this.sourceIter.close();
        }
    }

    private static enum Mode {
        OUTGOING_LINKS,
        INCOMING_LINKS;

    }
}

