/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.rdf4j.common.exception.ValidationException;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.console.VerificationListener;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;
import org.eclipse.rdf4j.console.setting.WorkDir;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;

public class Verify
extends ConsoleCommand {
    @Override
    public String getName() {
        return "verify";
    }

    @Override
    public String getHelpShort() {
        return "Verifies the syntax of an RDF data file, takes a file path or URL as argument";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nverify <location> [<shacl-location> <report.ttl>]\n  <location>                               The file path or URL identifying the data file\n  <location> <shacl-location> <report.ttl> Validate using shacl file and create a report\nVerifies the validity of the specified data file\n";
    }

    @Override
    public String[] usesSettings() {
        return new String[]{"workdir"};
    }

    public Verify(ConsoleIO consoleIO, Map<String, ConsoleSetting> settings) {
        super(consoleIO, null, settings);
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length != 2 && tokens.length != 4) {
            this.writeln(this.getHelpLong());
            return;
        }
        String dataPath = this.parseDataPath(tokens[1]);
        this.verify(dataPath);
        if (tokens.length == 4) {
            String shaclPath = this.parseDataPath(tokens[2]);
            String reportFile = tokens[3];
            this.shacl(dataPath, shaclPath, reportFile);
        }
    }

    private Path getWorkDir() {
        return (Path)((WorkDir)this.settings.get("workdir")).get();
    }

    private void verify(String dataPath) {
        try {
            URL dataURL = new URL(dataPath);
            RDFFormat format = (RDFFormat)Rio.getParserFormatForFileName((String)dataPath).orElseThrow(Rio.unsupportedFormat((String)dataPath));
            RDFParser parser = Rio.createParser((RDFFormat)format);
            this.writeln("RDF Format is " + parser.getRDFFormat().getName());
            VerificationListener listener = new VerificationListener(this.consoleIO);
            parser.set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
            parser.set((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
            parser.set((RioSetting)BasicParserSettings.VERIFY_LANGUAGE_TAGS, (Object)true);
            parser.set((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
            parser.set((RioSetting)BasicParserSettings.VERIFY_RELATIVE_URIS, (Object)true);
            parser.set((RioSetting)BasicParserSettings.VERIFY_URI_SYNTAX, (Object)true);
            parser.setParseErrorListener((ParseErrorListener)listener);
            parser.setRDFHandler((RDFHandler)listener);
            this.writeln("Verifying data...");
            try (InputStream dataStream = dataURL.openStream();){
                parser.parse(dataStream, "urn://openrdf.org/RioVerifier/");
            }
            int warnings = listener.getWarnings();
            int errors = listener.getErrors();
            if (warnings + errors > 0) {
                this.writeError("Found " + warnings + " warnings and " + errors + " errors");
            } else {
                this.writeln("Data verified, no errors were found");
            }
            if (errors == 0) {
                this.writeln("File contains " + listener.getStatements() + " statements");
            }
        }
        catch (MalformedURLException e) {
            this.writeError("Malformed URL: " + dataPath);
        }
        catch (IOException e) {
            this.writeError("Failed to load data", e);
        }
        catch (UnsupportedRDFormatException e) {
            this.writeError("No parser available for this RDF format", (Exception)((Object)e));
        }
        catch (RDFParseException e) {
            this.writeError("Unexpected RDFParseException", (Exception)((Object)e));
        }
        catch (RDFHandlerException e) {
            this.writeError("Unable to verify", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shacl(String dataPath, String shaclPath, String reportFile) {
        SailRepository repo = new SailRepository((Sail)new ShaclSail((NotifyingSail)new MemoryStore()));
        repo.init();
        try {
            SailRepositoryConnection conn;
            Object format;
            boolean loaded = false;
            try {
                this.writeln("Loading shapes from " + shaclPath);
                URL shaclURL = new URL(shaclPath);
                format = Rio.getParserFormatForFileName((String)reportFile).orElse(RDFFormat.TURTLE);
                conn = repo.getConnection();
                try {
                    conn.begin(new TransactionSetting[]{IsolationLevels.NONE, ShaclSail.TransactionSettings.ValidationApproach.Disabled});
                    conn.add(shaclURL, "", format, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH});
                    conn.commit();
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
                loaded = true;
            }
            catch (MalformedURLException e) {
                this.writeError("Malformed URL: " + shaclPath, e);
            }
            catch (IOException e) {
                this.writeError("Failed to load shacl shapes", e);
            }
            if (!loaded) {
                this.writeError("No shapes found");
                return;
            }
            try {
                URL dataURL = new URL(dataPath);
                format = (RDFFormat)Rio.getParserFormatForFileName((String)dataPath).orElseThrow(Rio.unsupportedFormat((String)dataPath));
                conn = repo.getConnection();
                try {
                    conn.begin(new TransactionSetting[]{IsolationLevels.NONE, ShaclSail.TransactionSettings.ValidationApproach.Disabled});
                    conn.add(dataURL, "", format, new Resource[0]);
                    conn.commit();
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            catch (MalformedURLException e) {
                this.writeError("Malformed URL: " + dataPath);
            }
            catch (IOException e) {
                this.writeError("Failed to load data", e);
            }
            catch (RepositoryException e) {
                format = e.getCause();
            }
            try {
                try (SailRepositoryConnection conn2 = repo.getConnection();){
                    conn2.begin(new TransactionSetting[]{IsolationLevels.NONE, ShaclSail.TransactionSettings.ValidationApproach.Bulk});
                    conn2.commit();
                }
                this.writeln("SHACL validation OK");
            }
            catch (RepositoryException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ValidationException) {
                    this.writeError("SHACL validation failed, writing report to " + reportFile);
                    ValidationException sv = (ValidationException)cause;
                    this.writeReport(sv.validationReportAsModel(), reportFile);
                }
            }
        }
        finally {
            repo.shutDown();
        }
    }

    private String parseDataPath(String str) {
        Object path = str;
        try {
            new URL(str);
        }
        catch (MalformedURLException e) {
            path = "file:" + Util.getNormalizedPath(this.getWorkDir(), str);
        }
        return path;
    }

    private void writeReport(Model model, String reportFile) {
        WriterConfig cfg = new WriterConfig();
        cfg.set((RioSetting)BasicWriterSettings.PRETTY_PRINT, (Object)true);
        cfg.set((RioSetting)BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
        RDFFormat format = Rio.getParserFormatForFileName((String)reportFile).orElse(RDFFormat.TURTLE);
        try (BufferedWriter w = Files.newBufferedWriter(Paths.get(reportFile, new String[0]), new OpenOption[0]);){
            Rio.write((Iterable)model, (Writer)w, (RDFFormat)format, (WriterConfig)cfg);
        }
        catch (IOException ex) {
            this.writeError("Could not write report to " + reportFile, ex);
        }
    }
}

