/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.model;

import com.google.common.net.UrlEscapers;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.sail.nativerdf.ValueStoreRevision;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptValue;

public class CorruptIRI
extends CorruptValue
implements IRI {
    private static final long serialVersionUID = -6995615243794525852L;
    private final String namespace;

    public CorruptIRI(ValueStoreRevision revision, int internalID, String namespace, byte[] data) {
        super(revision, internalID, data);
        this.namespace = namespace;
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public String stringValue() {
        try {
            return this.getNamespace() + ":" + this.getLocalName();
        }
        catch (Throwable throwable) {
            return "CorruptIRI_with_ID_" + this.getInternalID();
        }
    }

    public String getNamespace() {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            return this.namespace;
        }
        return "urn:CorruptIRI:";
    }

    public String getLocalName() {
        byte[] data = this.getData();
        if (data != null && data.length < 1024) {
            try {
                String localName = new String(data, 5, data.length - 5, StandardCharsets.UTF_8);
                return "CORRUPT_" + UrlEscapers.urlPathSegmentEscaper().escape(localName);
            }
            catch (Throwable throwable) {
                return "CORRUPT_" + Hex.encodeHexString((byte[])data);
            }
        }
        return "CORRUPT";
    }

    @Override
    public boolean equals(Object o) {
        CorruptIRI otherCorruptValue;
        if (this == o) {
            return true;
        }
        if (o instanceof CorruptIRI && this.getInternalID() != -1 && (otherCorruptValue = (CorruptIRI)o).getInternalID() != -1 && this.getValueStoreRevision().equals(otherCorruptValue.getValueStoreRevision())) {
            return this.getInternalID() == otherCorruptValue.getInternalID();
        }
        return super.equals(o);
    }
}

