/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.collection.factory.mapdb;

import java.io.IOException;
import java.util.Optional;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.serializer.SerializerIntegerPacked;
import org.mapdb.serializer.SerializerString;

class ValueSerializer
implements Serializer<Value> {
    private static final int IS_NEW_COREDATATYPE = 5;
    private static final int IS_RDF_DATATYPE = 4;
    private static final int IS_GEO_DATATYPE = 3;
    private static final int IS_XSD_DATATYPE = 2;
    private static final int NOT_COREDATYPE = 1;
    private static final int IS_LANGUAGE = 0;
    private static final int IS_BNODE = 0;
    private static final int IS_IRI = 1;
    private static final int IS_LITERAL = 2;
    private static final int IS_TRIPLE = 3;
    private static final int IS_NULL = 4;
    private final SerializerIntegerPacked si = new SerializerIntegerPacked();
    private final SerializerString ss = new SerializerString();
    private final ValueFactory vf;

    public ValueSerializer() {
        this(SimpleValueFactory.getInstance());
    }

    public ValueSerializer(ValueFactory vf) {
        this.vf = vf;
    }

    public void serialize(DataOutput2 out, Value value) throws IOException {
        if (value instanceof BNode) {
            this.si.serialize(out, Integer.valueOf(0));
            this.serializeBNode(out, (BNode)value);
        } else if (value instanceof IRI) {
            this.si.serialize(out, Integer.valueOf(1));
            this.serializeIRI(out, (IRI)value);
        } else if (value instanceof Literal) {
            this.si.serialize(out, Integer.valueOf(2));
            this.serializeLiteral(out, (Literal)value);
        } else if (value instanceof Triple) {
            this.si.serialize(out, Integer.valueOf(3));
            this.serializeTriple(out, (Triple)value);
        } else {
            this.si.serialize(out, Integer.valueOf(4));
        }
    }

    private void serializeBNode(DataOutput2 out, BNode bnode) throws IOException {
        this.ss.serialize(out, bnode.getID());
    }

    private void serializeLiteral(DataOutput2 out, Literal value) throws IOException {
        Optional<String> language = value.getLanguage();
        if (language.isPresent()) {
            this.si.serialize(out, Integer.valueOf(0));
            this.ss.serialize(out, value.stringValue());
            this.ss.serialize(out, language.get());
        } else {
            CoreDatatype cd = value.getCoreDatatype();
            if (cd == null) {
                this.si.serialize(out, Integer.valueOf(1));
                this.serializeIRI(out, value.getDatatype());
            } else if (cd.isXSDDatatype()) {
                this.si.serialize(out, Integer.valueOf(2));
                this.si.serialize(out, Integer.valueOf(((CoreDatatype.XSD)cd).ordinal()));
            } else if (cd.isGEODatatype()) {
                this.si.serialize(out, Integer.valueOf(3));
                this.si.serialize(out, Integer.valueOf(((CoreDatatype.GEO)cd).ordinal()));
            } else if (cd.isRDFDatatype()) {
                this.si.serialize(out, Integer.valueOf(4));
                this.si.serialize(out, Integer.valueOf(((CoreDatatype.RDF)cd).ordinal()));
            } else {
                this.si.serialize(out, Integer.valueOf(5));
                this.serializeIRI(out, value.getDatatype());
            }
            this.ss.serialize(out, value.stringValue());
        }
    }

    private void serializeIRI(DataOutput2 out, IRI value) throws IOException {
        this.ss.serialize(out, value.stringValue());
    }

    private void serializeTriple(DataOutput2 out, Triple value) throws IOException {
        this.serialize(out, value.getSubject());
        this.serialize(out, value.getPredicate());
        this.serialize(out, value.getObject());
    }

    public Value deserialize(DataInput2 input, int available) throws IOException {
        int t = this.si.deserialize(input, available);
        switch (t) {
            case 0: {
                return this.deserializeBnode(input, available);
            }
            case 1: {
                return this.deserializeIRI(input, available);
            }
            case 2: {
                return this.deserializeLiteral(input, available);
            }
            case 3: {
                return this.deserializeTriple(input, available);
            }
        }
        return null;
    }

    private Value deserializeTriple(DataInput2 input, int available) throws IOException {
        Resource subj = (Resource)this.deserialize(input, available);
        IRI pred = (IRI)this.deserialize(input, available);
        Value obj = this.deserialize(input, available);
        return this.vf.createTriple(subj, pred, obj);
    }

    private Value deserializeLiteral(DataInput2 input, int available) throws IOException {
        int t = this.si.deserialize(input, available);
        switch (t) {
            case 0: {
                String language = this.ss.deserialize(input, available);
                String value = this.ss.deserialize(input, available);
                return this.vf.createLiteral(value, language);
            }
            case 1: {
                IRI datatype = this.deserializeIRI(input, available);
                String value = this.ss.deserialize(input, available);
                return this.vf.createLiteral(value, datatype);
            }
            case 2: {
                CoreDatatype.XSD datatype = CoreDatatype.XSD.values()[this.si.deserialize(input, available)];
                String value = this.ss.deserialize(input, available);
                return this.vf.createLiteral(value, (CoreDatatype)datatype);
            }
            case 3: {
                CoreDatatype.GEO datatype = CoreDatatype.GEO.values()[this.si.deserialize(input, available)];
                String value = this.ss.deserialize(input, available);
                return this.vf.createLiteral(value, datatype);
            }
            case 4: {
                CoreDatatype.RDF datatype = CoreDatatype.RDF.values()[this.si.deserialize(input, available)];
                String value = this.ss.deserialize(input, available);
                return this.vf.createLiteral(value, datatype);
            }
            case 5: {
                IRI datatype = this.deserializeIRI(input, available);
                String value = this.ss.deserialize(input, available);
                return this.vf.createLiteral(value, datatype);
            }
        }
        return null;
    }

    private IRI deserializeIRI(DataInput2 input, int available) throws IOException {
        return this.vf.createIRI(this.ss.deserialize(input, available));
    }

    private BNode deserializeBnode(DataInput2 input, int available) throws IOException {
        return this.vf.createBNode(this.ss.deserialize(input, available));
    }
}

