/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrFilter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class ReorderFiltersInOptionalBodiesTransform
extends BaseTransform {
    private ReorderFiltersInOptionalBodiesTransform() {
    }

    public static IrBGP apply(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (IrNode n : bgp.getLines()) {
            if (n instanceof IrOptional) {
                IrOptional opt = (IrOptional)n;
                IrBGP inner = ReorderFiltersInOptionalBodiesTransform.apply(opt.getWhere(), r);
                inner = ReorderFiltersInOptionalBodiesTransform.reorderFiltersWithin(inner, r);
                IrOptional no = new IrOptional(inner, opt.isNewScope());
                no.setNewScope(opt.isNewScope());
                out.add(no);
                continue;
            }
            IrNode rec = BaseTransform.rewriteContainers(n, child -> ReorderFiltersInOptionalBodiesTransform.apply(child, r));
            out.add(rec);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    public static IrBGP reorderFiltersWithin(IrBGP inner, TupleExprIRRenderer r) {
        if (inner == null) {
            return null;
        }
        List<IrNode> lines = inner.getLines();
        int firstOpt = -1;
        for (int i = 0; i < lines.size(); ++i) {
            if (!(lines.get(i) instanceof IrOptional)) continue;
            firstOpt = i;
            break;
        }
        if (firstOpt < 0) {
            return inner;
        }
        ArrayList<IrNode> head = new ArrayList<IrNode>(lines.subList(0, firstOpt));
        ArrayList<IrNode> tail = new ArrayList<IrNode>(lines.subList(firstOpt, lines.size()));
        ArrayList<IrNode> filters = new ArrayList<IrNode>();
        ArrayList<IrNode> newHead = new ArrayList<IrNode>();
        for (IrNode irNode : head) {
            if (irNode instanceof IrFilter) {
                filters.add(irNode);
                continue;
            }
            newHead.add(irNode);
        }
        ArrayList<IrNode> newTail = new ArrayList<IrNode>();
        for (IrNode ln : tail) {
            if (ln instanceof IrFilter) {
                filters.add(ln);
                continue;
            }
            newTail.add(ln);
        }
        if (filters.isEmpty()) {
            return inner;
        }
        Set<String> set = ReorderFiltersInOptionalBodiesTransform.collectVarsFromLines(newHead, r);
        ArrayList<IrNode> safeFilters = new ArrayList<IrNode>();
        ArrayList<IrNode> unsafeFilters = new ArrayList<IrNode>();
        for (IrNode irNode : filters) {
            if (!(irNode instanceof IrFilter)) {
                unsafeFilters.add(irNode);
                continue;
            }
            String txt = ((IrFilter)irNode).getConditionText();
            if (txt == null) {
                unsafeFilters.add(irNode);
                continue;
            }
            Set<String> fv = ReorderFiltersInOptionalBodiesTransform.extractVarsFromText(txt);
            if (set.containsAll(fv)) {
                safeFilters.add(irNode);
                continue;
            }
            unsafeFilters.add(irNode);
        }
        ArrayList<IrNode> merged = new ArrayList<IrNode>();
        newHead.forEach(merged::add);
        safeFilters.forEach(merged::add);
        newTail.forEach(merged::add);
        unsafeFilters.forEach(merged::add);
        return BaseTransform.bgpWithLines(inner, merged);
    }

    public static Set<String> collectVarsFromLines(List<IrNode> lines, TupleExprIRRenderer r) {
        LinkedHashSet<String> out = new LinkedHashSet<String>();
        if (lines == null) {
            return out;
        }
        for (IrNode ln : lines) {
            if (ln instanceof IrStatementPattern) {
                IrStatementPattern sp = (IrStatementPattern)ln;
                ReorderFiltersInOptionalBodiesTransform.addVarName(out, sp.getSubject());
                ReorderFiltersInOptionalBodiesTransform.addVarName(out, sp.getObject());
                continue;
            }
            if (ln instanceof IrPathTriple) {
                IrPathTriple pt = (IrPathTriple)ln;
                ReorderFiltersInOptionalBodiesTransform.addVarName(out, pt.getSubject());
                ReorderFiltersInOptionalBodiesTransform.addVarName(out, pt.getObject());
                continue;
            }
            if (!(ln instanceof IrGraph)) continue;
            IrGraph g = (IrGraph)ln;
            out.addAll(ReorderFiltersInOptionalBodiesTransform.collectVarsFromLines(g.getWhere() == null ? Collections.emptyList() : g.getWhere().getLines(), r));
        }
        return out;
    }

    public static Set<String> extractVarsFromText(String s) {
        LinkedHashSet<String> out = new LinkedHashSet<String>();
        if (s == null) {
            return out;
        }
        Matcher m = Pattern.compile("\\?([A-Za-z_][\\w]*)").matcher(s);
        while (m.find()) {
            out.add(m.group(1));
        }
        return out;
    }

    public static void addVarName(Set<String> out, Var v) {
        if (v == null || v.hasValue()) {
            return;
        }
        String n = v.getName();
        if (n != null && !n.isEmpty()) {
            out.add(n);
        }
    }
}

