/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrFilter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class MergeOptionalIntoPrecedingGraphTransform
extends BaseTransform {
    private MergeOptionalIntoPrecedingGraphTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (int i = 0; i < in.size(); ++i) {
            IrNode n = in.get(i);
            if (n instanceof IrGraph && i + 1 < in.size() && in.get(i + 1) instanceof IrOptional) {
                IrGraph g = (IrGraph)n;
                IrBGP gInner = g.getWhere();
                if (gInner == null || gInner.getLines().size() != 1) {
                    out.add(n);
                    continue;
                }
                IrOptional opt = (IrOptional)in.get(i + 1);
                IrBGP ow = opt.getWhere();
                IrBGP simpleOw = null;
                if (ow != null && ow.getLines().size() == 1 && ow.getLines().get(0) instanceof IrGraph) {
                    IrGraph inner = (IrGraph)ow.getLines().get(0);
                    if (MergeOptionalIntoPrecedingGraphTransform.sameVarOrValue(g.getGraph(), inner.getGraph()) && MergeOptionalIntoPrecedingGraphTransform.isSimpleOptionalBody(inner.getWhere())) {
                        simpleOw = inner.getWhere();
                    }
                } else if (ow != null && !ow.getLines().isEmpty()) {
                    IrGraph innerGraph = null;
                    ArrayList filters = new ArrayList();
                    boolean ok = true;
                    for (IrNode ln : ow.getLines()) {
                        if (ln instanceof IrGraph) {
                            if (innerGraph != null) {
                                ok = false;
                                break;
                            }
                            innerGraph = (IrGraph)ln;
                            if (MergeOptionalIntoPrecedingGraphTransform.sameVarOrValue(g.getGraph(), innerGraph.getGraph())) continue;
                            ok = false;
                            break;
                        }
                        if (ln instanceof IrFilter) {
                            filters.add((IrFilter)ln);
                            continue;
                        }
                        ok = false;
                        break;
                    }
                    if (ok && innerGraph != null && MergeOptionalIntoPrecedingGraphTransform.isSimpleOptionalBody(innerGraph.getWhere())) {
                        IrBGP body = new IrBGP(bgp.isNewScope());
                        for (IrNode gln : innerGraph.getWhere().getLines()) {
                            body.add(gln);
                        }
                        Iterator<IrNode> iterator = filters.iterator();
                        while (iterator.hasNext()) {
                            IrFilter fl = (IrFilter)iterator.next();
                            body.add(fl);
                        }
                        simpleOw = body;
                    }
                }
                if (simpleOw != null) {
                    IrBGP merged = new IrBGP(bgp.isNewScope());
                    for (IrNode gl : g.getWhere().getLines()) {
                        merged.add(gl);
                    }
                    IrOptional no = new IrOptional(simpleOw, opt.isNewScope());
                    no.setNewScope(opt.isNewScope());
                    merged.add(no);
                    out.add(new IrGraph(g.getGraph(), merged, g.isNewScope()));
                    ++i;
                    continue;
                }
            }
            if (n instanceof IrBGP || n instanceof IrGraph || n instanceof IrOptional || n instanceof IrUnion || n instanceof IrMinus || n instanceof IrService || n instanceof IrSubSelect) {
                n = n.transformChildren(child -> {
                    if (child instanceof IrBGP) {
                        return MergeOptionalIntoPrecedingGraphTransform.apply((IrBGP)child);
                    }
                    return child;
                });
            }
            out.add(n);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    public static boolean isSimpleOptionalBody(IrBGP ow) {
        if (ow == null) {
            return false;
        }
        if (ow.getLines().isEmpty()) {
            return false;
        }
        for (IrNode ln : ow.getLines()) {
            if (ln instanceof IrStatementPattern || ln instanceof IrPathTriple) continue;
            return false;
        }
        return true;
    }
}

