/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.sail.nativerdf.TxnStatusFile;

@Experimental
class MemoryMappedTxnStatusFile
extends TxnStatusFile {
    public static final String FILE_NAME = "txn-status";
    private static final int MAPPED_SIZE = 1;
    private static final String ALWAYS_FORCE_SYNC_PROP = "org.eclipse.rdf4j.sail.nativerdf.MemoryMappedTxnStatusFile.alwaysForceSync";
    static boolean ALWAYS_FORCE_SYNC = Boolean.getBoolean("org.eclipse.rdf4j.sail.nativerdf.MemoryMappedTxnStatusFile.alwaysForceSync");
    private final File statusFile;
    private final FileChannel channel;
    private final MappedByteBuffer mapped;

    public MemoryMappedTxnStatusFile(File dataDir) throws IOException {
        this.statusFile = new File(dataDir, FILE_NAME);
        ALWAYS_FORCE_SYNC = !Boolean.getBoolean(ALWAYS_FORCE_SYNC_PROP);
        EnumSet<StandardOpenOption> openOptions = EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        this.channel = FileChannel.open(this.statusFile.toPath(), openOptions.toArray(new StandardOpenOption[0]));
        long size = this.channel.size();
        if (size < 1L) {
            this.channel.position(0L);
            int write = this.channel.write(ByteBuffer.wrap(TxnStatusFile.TxnStatus.NONE.getOnDisk()));
            if (write != 1) {
                throw new IOException("Failed to initialize transaction status file");
            }
            this.channel.force(true);
        }
        this.mapped = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, 1L);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public void setTxnStatus(TxnStatusFile.TxnStatus txnStatus, boolean forceSync) {
        if (this.disabled) {
            return;
        }
        this.mapped.put(0, txnStatus.getOnDisk()[0]);
        if (ALWAYS_FORCE_SYNC || forceSync) {
            this.mapped.force();
        }
    }

    @Override
    public TxnStatusFile.TxnStatus getTxnStatus() throws IOException {
        if (this.disabled) {
            return TxnStatusFile.TxnStatus.NONE;
        }
        try {
            return statusMapping[this.mapped.get(0)];
        }
        catch (IndexOutOfBoundsException e) {
            return this.getTxnStatusDeprecated();
        }
    }

    private TxnStatusFile.TxnStatus getTxnStatusDeprecated() throws IOException {
        if (this.disabled) {
            return TxnStatusFile.TxnStatus.NONE;
        }
        byte[] bytes = Files.readAllBytes(this.statusFile.toPath());
        if (bytes.length == 0) {
            return TxnStatusFile.TxnStatus.NONE;
        }
        String s = new String(bytes, StandardCharsets.US_ASCII);
        try {
            return TxnStatusFile.TxnStatus.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            s = new String(bytes);
            try {
                return TxnStatusFile.TxnStatus.valueOf(s);
            }
            catch (IllegalArgumentException e2) {
                return TxnStatusFile.TxnStatus.UNKNOWN;
            }
        }
    }
}

