/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.impl.internal;

import java.util.Arrays;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.MethodSource;
import org.eclipse.birt.data.oda.pojo.util.MethodParameterType;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class MethodIdentifier {
    private String name;
    private Class[] params;

    public MethodIdentifier(String name, Class[] params) {
        assert (name != null && params != null);
        this.name = name;
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public Class[] getParams() {
        return this.params;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodIdentifier other = (MethodIdentifier)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return Arrays.equals(this.params, other.params);
    }

    public static MethodIdentifier newInstance(MethodSource ms, ClassLoader pojoClassLoader) throws OdaException {
        String methodName = ms.getName();
        Class[] params = new Class[ms.getParameters().length];
        int i = 0;
        IMethodParameter[] iMethodParameterArray = ms.getParameters();
        int n = iMethodParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodParameter mp = iMethodParameterArray[n2];
            MethodParameterType mpt = MethodParameterType.getInstance(mp.getDataType(), pojoClassLoader);
            params[i++] = mpt.getJavaType();
            ++n2;
        }
        return new MethodIdentifier(methodName, params);
    }
}

