/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.resize.mode;

import java.util.HashSet;
import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.painter.IOverlayPainter;
import net.sourceforge.nattable.resize.command.RowResizeCommand;
import net.sourceforge.nattable.ui.action.IDragMode;
import net.sourceforge.nattable.ui.util.CellEdgeDetectUtil;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class RowResizeDragMode
implements IDragMode {
    private static final int DEFAULT_ROW_HEIGHT_MINIMUM = 18;
    private int gridRowPositionToResize;
    private int originalRowHeight;
    private int startY;
    private int currentY;
    private int lastY = -1;
    private int gridRowStartY;
    private IOverlayPainter overlayPainter = new RowResizeOverlayPainter();

    public void mouseDown(NatTable natTable, MouseEvent event) {
        natTable.forceFocus();
        this.gridRowPositionToResize = CellEdgeDetectUtil.getRowPositionToResize(natTable, new Point(event.x, event.y));
        if (this.gridRowPositionToResize > 0) {
            this.gridRowStartY = natTable.getStartYOfRowPosition(this.gridRowPositionToResize);
            this.originalRowHeight = natTable.getRowHeightByPosition(this.gridRowPositionToResize);
            this.startY = event.y;
            natTable.addOverlayPainter(this.overlayPainter);
        }
    }

    public void mouseMove(NatTable natTable, MouseEvent event) {
        if (event.y > natTable.getHeight()) {
            return;
        }
        this.currentY = event.y;
        if (this.currentY < this.gridRowStartY + this.getRowHeightMinimum()) {
            this.currentY = this.gridRowStartY + this.getRowHeightMinimum();
        } else {
            int overlayExtent = 1;
            HashSet<Integer> rowsToRepaint = new HashSet<Integer>();
            rowsToRepaint.add(natTable.getRowPositionByY(this.currentY - overlayExtent));
            rowsToRepaint.add(natTable.getRowPositionByY(this.currentY + overlayExtent));
            if (this.lastY >= 0) {
                rowsToRepaint.add(natTable.getRowPositionByY(this.lastY - overlayExtent));
                rowsToRepaint.add(natTable.getRowPositionByY(this.lastY + overlayExtent));
            }
            for (Integer rowToRepaint : rowsToRepaint) {
                natTable.repaintRow(rowToRepaint);
            }
            this.lastY = this.currentY;
        }
    }

    public void mouseUp(NatTable natTable, MouseEvent event) {
        natTable.removeOverlayPainter(this.overlayPainter);
        this.updateRowHeight(natTable, event);
    }

    private void updateRowHeight(ILayer natLayer, MouseEvent e) {
        int dragHeight = e.y - this.startY;
        int newRowHeight = this.originalRowHeight + dragHeight;
        if (newRowHeight < this.getRowHeightMinimum()) {
            newRowHeight = this.getRowHeightMinimum();
        }
        natLayer.doCommand(new RowResizeCommand(natLayer, this.gridRowPositionToResize, newRowHeight));
    }

    public int getRowHeightMinimum() {
        return 18;
    }

    private class RowResizeOverlayPainter
    implements IOverlayPainter {
        static final int ROW_RESIZE_OVERLAY_HEIGHT = 2;

        private RowResizeOverlayPainter() {
        }

        public void paintOverlay(GC gc, ILayer layer) {
            Color originalBackgroundColor = gc.getBackground();
            gc.setBackground(GUIHelper.COLOR_DARK_GRAY);
            gc.fillRectangle(0, RowResizeDragMode.this.currentY - 1, layer.getWidth(), 2);
            gc.setBackground(originalBackgroundColor);
        }
    }
}

