/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection;

import net.sourceforge.nattable.command.AbstractContextFreeCommand;
import net.sourceforge.nattable.command.ILayerCommandHandler;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.command.AbstractSelectionCommand;
import net.sourceforge.nattable.selection.command.MoveSelectionCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MoveSelectionCommandHandler<T extends MoveSelectionCommand>
implements ILayerCommandHandler<T> {
    protected final SelectionLayer selectionLayer;

    public MoveSelectionCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, T command) {
        if (((AbstractContextFreeCommand)command).convertToTargetLayer(this.selectionLayer)) {
            this.moveSelection(((MoveSelectionCommand)command).getDirection(), ((MoveSelectionCommand)command).getStepSize(), ((AbstractSelectionCommand)command).isShiftMask(), ((AbstractSelectionCommand)command).isControlMask());
            return true;
        }
        return false;
    }

    protected void moveSelection(SelectionLayer.MoveDirectionEnum moveDirection, int stepSize, boolean withShiftMask, boolean withControlMask) {
        switch (moveDirection) {
            case UP: {
                this.moveLastSelectedUp(stepSize, withShiftMask, withControlMask);
                break;
            }
            case DOWN: {
                this.moveLastSelectedDown(stepSize, withShiftMask, withControlMask);
                break;
            }
            case LEFT: {
                this.moveLastSelectedLeft(stepSize, withShiftMask, withControlMask);
                break;
            }
            case RIGHT: {
                this.moveLastSelectedRight(stepSize, withShiftMask, withControlMask);
                break;
            }
        }
    }

    protected abstract void moveLastSelectedRight(int var1, boolean var2, boolean var3);

    protected abstract void moveLastSelectedLeft(int var1, boolean var2, boolean var3);

    protected abstract void moveLastSelectedUp(int var1, boolean var2, boolean var3);

    protected abstract void moveLastSelectedDown(int var1, boolean var2, boolean var3);
}

