/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.ui.mode;

import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.ui.NatEventData;
import net.sourceforge.nattable.ui.action.IDragMode;
import net.sourceforge.nattable.ui.action.IKeyAction;
import net.sourceforge.nattable.ui.action.IMouseAction;
import net.sourceforge.nattable.ui.binding.IUiBindingRegistry;
import net.sourceforge.nattable.ui.mode.AbstractModeEventHandler;
import net.sourceforge.nattable.ui.mode.ModeSupport;
import net.sourceforge.nattable.ui.mode.MouseModeEventHandler;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class ConfigurableModeEventHandler
extends AbstractModeEventHandler {
    private final NatTable natTable;
    private IUiBindingRegistry uiBindingRegistry;

    public ConfigurableModeEventHandler(ModeSupport modeSupport, NatTable natTable) {
        super(modeSupport);
        this.natTable = natTable;
        this.uiBindingRegistry = natTable.getUiBindingRegistry();
    }

    public void keyPressed(KeyEvent event) {
        IKeyAction keyAction = this.uiBindingRegistry.getKeyEventAction(event);
        if (keyAction != null) {
            this.natTable.forceFocus();
            keyAction.run(this.natTable, event);
        }
    }

    public void mouseDown(MouseEvent event) {
        IMouseAction mouseDownAction = this.uiBindingRegistry.getMouseDownAction(event);
        if (mouseDownAction != null) {
            event.data = NatEventData.createInstanceFromEvent(event);
            mouseDownAction.run(this.natTable, event);
        }
        IMouseAction singleClickAction = this.uiBindingRegistry.getSingleClickAction(event);
        IMouseAction doubleClickAction = this.uiBindingRegistry.getDoubleClickAction(event);
        IDragMode dragMode = this.uiBindingRegistry.getDragMode(event);
        if (singleClickAction != null || doubleClickAction != null || dragMode != null) {
            this.switchMode(new MouseModeEventHandler(this.getModeSupport(), this.natTable, event, singleClickAction, doubleClickAction, dragMode));
        }
    }

    public synchronized void mouseMove(MouseEvent event) {
        IMouseAction mouseMoveAction = this.uiBindingRegistry.getMouseMoveAction(event);
        if (mouseMoveAction != null) {
            event.data = NatEventData.createInstanceFromEvent(event);
            mouseMoveAction.run(this.natTable, event);
        }
    }
}

