/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.ast.core;

import org.eclipse.acceleo.compatibility.model.mt.core.CoreFactory;
import org.eclipse.acceleo.compatibility.model.mt.core.FilePath;
import org.eclipse.acceleo.compatibility.model.mt.core.ScriptDescriptor;
import org.eclipse.acceleo.compatibility.model.mt.core.Template;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Expression;
import org.eclipse.acceleo.internal.compatibility.AcceleoCompatibilityMessages;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.ExpressionParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.statements.StatementParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TextSearch;

public final class ScriptDescriptorParser {
    private ScriptDescriptorParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScriptDescriptor createScriptDescriptor(int offset, String buffer, Region range, Template template) throws TemplateSyntaxException {
        FilePath templateFile = CoreFactory.eINSTANCE.createFilePath();
        Expression templatePost = null;
        String templateType = null;
        String templateName = null;
        String templateDescription = null;
        Region rangeFileTemplate = null;
        Region rangePostExpression = null;
        Region[] properties = TextSearch.splitPositionsIn(buffer, range, TemplateConstants.getDefault().getScriptPropertiesSeparator(), false, TemplateConstants.getDefault().getSpec(), TemplateConstants.getDefault().getInhibsScriptDecla());
        int i = 0;
        while (i < properties.length) {
            String key = buffer.substring(properties[i].b(), properties[i].e());
            if (i + 1 >= properties.length) throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingKeyValue", new Object[]{key}), template, properties[i].e());
            String value = buffer.substring(properties[i + 1].b(), properties[i + 1].e());
            if (value.length() < 2 || !value.startsWith(TemplateConstants.getDefault().getLiteral()[0]) || !value.endsWith(TemplateConstants.getDefault().getLiteral()[1])) throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.InvalidKeyValue", new Object[]{key}), template, properties[i].e());
            value = value.substring(1, value.length() - 1);
            if (key.equals(TemplateConstants.getDefault().getScriptType())) {
                templateType = value;
            } else if (key.equals(TemplateConstants.getDefault().getScriptName())) {
                templateName = value;
            } else if (key.equals(TemplateConstants.getDefault().getScriptDesc())) {
                templateDescription = value;
            } else if (key.equals(TemplateConstants.getDefault().getScriptFile())) {
                rangeFileTemplate = new Region(properties[i + 1].b() + 1, properties[i + 1].e() - 1);
                templateFile.getStatements().addAll(StatementParser.createStatement(offset, buffer, rangeFileTemplate, template));
            } else {
                if (!key.equals(TemplateConstants.getDefault().getScriptPost())) throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.InvalidKey", new Object[]{key}), template, properties[i].b());
                rangePostExpression = new Region(properties[i + 1].b() + 1, properties[i + 1].e() - 1);
                templatePost = ExpressionParser.createExpression(offset, buffer, rangePostExpression, template);
            }
            i += 2;
        }
        if (templateType == null) {
            throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingType"), template, range.b());
        }
        if (templateName == null) {
            throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingName"), template, range.b());
        }
        ScriptDescriptor scriptDescriptor = CoreFactory.eINSTANCE.createScriptDescriptor();
        scriptDescriptor.setType(templateType);
        scriptDescriptor.setName(templateName);
        scriptDescriptor.setDescription(templateDescription);
        scriptDescriptor.setFile(templateFile);
        scriptDescriptor.setPost(templatePost);
        scriptDescriptor.setBegin(range.b());
        scriptDescriptor.setEnd(range.e());
        return scriptDescriptor;
    }
}

