/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.fieldassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.ui.swt.fieldassist.IContentChangeListener;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class CTextContentAdapter
extends TextContentAdapter {
    private List<IContentChangeListener> listeners = new ArrayList<IContentChangeListener>(2);

    CTextContentAdapter() {
    }

    public void setControlContents(Control control, String text, int cursorPosition) {
        String oldValue = ((Text)control).getText();
        ((Text)control).setText(text);
        ((Text)control).setSelection(cursorPosition, cursorPosition);
        this.notifyContentChanged(control, ((Text)control).getText(), oldValue);
    }

    public void insertControlContents(Control control, String text, int cursorPosition) {
        String oldValue = ((Text)control).getText();
        Point selection = ((Text)control).getSelection();
        ((Text)control).insert(text);
        if (cursorPosition < text.length()) {
            ((Text)control).setSelection(selection.x + cursorPosition, selection.x + cursorPosition);
        }
        this.notifyContentChanged(control, ((Text)control).getText(), oldValue);
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(0, listener);
        }
    }

    public void removeContentChangeListener(IContentChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyContentChanged(Control control, Object newValue, Object oldValue) {
        Object[] s = this.listeners.toArray();
        int i = 0;
        while (i < s.length) {
            ((IContentChangeListener)s[i]).contentChanged(control, newValue, oldValue);
            ++i;
        }
    }
}

