/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;

public class DrilledInfo {
    private int[] sortType;
    private List<AggregationDefinition> originalAggregationList;
    private DimLevel[] targetLevels;
    private ICubeQueryDefinition cubeQueryDefinition;

    public DrilledInfo(DimLevel[] targetLevels, ICubeQueryDefinition cubeQueryDefinition) {
        this.targetLevels = targetLevels;
        this.cubeQueryDefinition = cubeQueryDefinition;
        this.originalAggregationList = new ArrayList<AggregationDefinition>();
        if (targetLevels == null) {
            this.sortType = new int[0];
            return;
        }
        this.sortType = new int[targetLevels.length];
        int index = 0;
        while (index < targetLevels.length) {
            try {
                this.sortType[index] = CubeQueryDefinitionUtil.getSortDirection(targetLevels[index], cubeQueryDefinition);
            }
            catch (DataException dataException) {
                this.sortType[index] = -1;
            }
            ++index;
        }
    }

    public void addOriginalAggregation(AggregationDefinition aggregation) {
        this.originalAggregationList.add(aggregation);
    }

    public List<AggregationDefinition> getOriginalAggregation() {
        return this.originalAggregationList;
    }

    public boolean usedByAggregation(AggregationDefinition aggregation) {
        AggregationFunctionDefinition[] functions;
        HashSet<String> aggregtionFunctionNames = new HashSet<String>();
        AggregationFunctionDefinition[] aggregationFunctionDefinitionArray = functions = aggregation.getAggregationFunctions();
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            AggregationFunctionDefinition defn = aggregationFunctionDefinitionArray[n2];
            aggregtionFunctionNames.add(defn.getName());
            ++n2;
        }
        int i = 0;
        while (i < this.originalAggregationList.size()) {
            AggregationFunctionDefinition[] functions1;
            AggregationFunctionDefinition[] aggregationFunctionDefinitionArray2 = functions1 = this.originalAggregationList.get(i).getAggregationFunctions();
            int n3 = functions1.length;
            int n4 = 0;
            while (n4 < n3) {
                AggregationFunctionDefinition defn = aggregationFunctionDefinitionArray2[n4];
                if (aggregtionFunctionNames.contains(defn.getName())) {
                    return true;
                }
                ++n4;
            }
            ++i;
        }
        return this.originalAggregationList.contains(aggregation);
    }

    public boolean matchTargetlevels(DimLevel[] levels) {
        if (levels == this.targetLevels) {
            return true;
        }
        if (this.targetLevels == null) {
            return false;
        }
        if (levels == null) {
            return false;
        }
        if (this.targetLevels.length != levels.length) {
            return false;
        }
        int i = 0;
        while (i < this.targetLevels.length) {
            if (!this.targetLevels[i].equals(levels[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public DimLevel[] getTargetLevels() {
        return this.targetLevels;
    }

    public int[] getSortType() {
        return this.sortType;
    }

    public AggregationFunctionDefinition[] getAggregationFunctionDefinition() {
        AggregationFunctionDefinition[] aggr;
        HashMap<String, AggregationFunctionDefinition> functionMap = new HashMap<String, AggregationFunctionDefinition>();
        int i = 0;
        while (i < this.originalAggregationList.size()) {
            aggr = this.originalAggregationList.get(i);
            int j = 0;
            while (j < aggr.getAggregationFunctions().length) {
                if (!functionMap.containsKey(aggr.getAggregationFunctions()[j].getName())) {
                    functionMap.put(aggr.getAggregationFunctions()[j].getName(), aggr.getAggregationFunctions()[j]);
                }
                ++j;
            }
            ++i;
        }
        Iterator iter = functionMap.entrySet().iterator();
        aggr = new AggregationFunctionDefinition[functionMap.size()];
        int index = 0;
        while (iter.hasNext()) {
            aggr[index] = (AggregationFunctionDefinition)iter.next().getValue();
            ++index;
        }
        return aggr;
    }

    public DrilledInfo copy() {
        DrilledInfo drilledInfo = new DrilledInfo(this.targetLevels, this.cubeQueryDefinition);
        int i = 0;
        while (i < this.originalAggregationList.size()) {
            drilledInfo.addOriginalAggregation(this.originalAggregationList.get(i));
            ++i;
        }
        return drilledInfo;
    }
}

