/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.model;

import org.eclipse.birt.report.data.bidi.utils.core.BidiTransform;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.IDBNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.provider.JdbcMetaDataProvider;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

public class TableColumnNode
implements IDBNode,
Comparable<TableColumnNode> {
    private static String COLUMN_ICON = String.valueOf(TableColumnNode.class.getName()) + ".ColumnIcon";
    private String schemaName;
    private String tableName;
    private String columnName;
    private String typeName;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(COLUMN_ICON, ImageDescriptor.createFromFile(JdbcPlugin.class, (String)"icons/column.gif"));
    }

    public TableColumnNode(String schemaName, String tableName, String columnName, String typeName) {
        assert (columnName != null && tableName != null);
        this.columnName = columnName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.typeName = typeName;
    }

    @Override
    public String getDisplayName(String metadataBidiFormatStr) {
        return String.valueOf(BidiTransform.transform((String)this.columnName, (String)metadataBidiFormatStr, (String)"ILYNN")) + " (" + this.typeName + ")";
    }

    @Override
    public Image getImage() {
        return JFaceResources.getImage((String)COLUMN_ICON);
    }

    @Override
    public String getQualifiedNameInSQL(boolean useIdentifierQuoteString, boolean includeSchema, String metadataBidiFormatStr) {
        StringBuffer sb = new StringBuffer();
        String quoteFlag = "";
        if (useIdentifierQuoteString) {
            quoteFlag = JdbcMetaDataProvider.getInstance().getIdentifierQuoteString();
        }
        String schemaNameStr = this.schemaName;
        String tableNameStr = this.tableName;
        String columnNameStr = this.columnName;
        if (includeSchema && this.schemaName != null) {
            if (metadataBidiFormatStr != null) {
                schemaNameStr = BidiTransform.transform((String)this.schemaName, (String)metadataBidiFormatStr, (String)"ILYNN");
                tableNameStr = BidiTransform.transform((String)tableNameStr, (String)metadataBidiFormatStr, (String)"ILYNN");
                columnNameStr = BidiTransform.transform((String)columnNameStr, (String)metadataBidiFormatStr, (String)"ILYNN");
            }
            sb.append(Utility.quoteString(schemaNameStr, quoteFlag)).append(".");
        }
        sb.append(Utility.quoteString(tableNameStr, quoteFlag)).append(".");
        sb.append(Utility.quoteString(columnNameStr, quoteFlag));
        return sb.toString();
    }

    @Override
    public int compareTo(TableColumnNode o) {
        return this.columnName.compareTo(o.columnName);
    }
}

