/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public final class Utils {
    public static final String GEN_TAG = "//@generated:";
    public static final String GEN_TAG_MID = "//";
    public static final String GEN_TAG_END = "//@generated:end";
    public static final String EMBEDDED_SMAP_PREFIX = "//!SMAP!";

    public static IConfigurationElement[] getConfigurationElements(String extensionPointId) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.bpel.common.ui", extensionPointId);
        if (extensionPoint == null) {
            return null;
        }
        return extensionPoint.getConfigurationElements();
    }

    public static String getGeneratedCode(String string) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        boolean inside = false;
        while (stringTokenizer.hasMoreTokens()) {
            String s = stringTokenizer.nextToken();
            if (s.startsWith(GEN_TAG_MID) && !s.startsWith(EMBEDDED_SMAP_PREFIX)) {
                if (inside && s.startsWith(GEN_TAG_END)) {
                    inside = false;
                    continue;
                }
                if (s.startsWith(GEN_TAG)) {
                    inside = true;
                    continue;
                }
            } else if (!s.startsWith(EMBEDDED_SMAP_PREFIX)) {
                sb.append(s);
                sb.append("\n");
                continue;
            }
            if (inside || s.startsWith(EMBEDDED_SMAP_PREFIX)) continue;
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String getGeneratorId(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String s = stringTokenizer.nextToken();
                if (!s.startsWith(GEN_TAG_MID) || !s.startsWith(GEN_TAG)) continue;
                return s.substring(GEN_TAG.length());
            }
        }
        return null;
    }
}

