/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.configuration;

import com.google.common.base.Objects;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.configuration.GradleArguments;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.internal.configuration.RunConfiguration;
import org.eclipse.buildship.core.internal.configuration.RunConfigurationProperties;

class DefaultRunConfiguration
implements RunConfiguration {
    private final ProjectConfiguration projectConfiguration;
    private final RunConfigurationProperties properties;

    public DefaultRunConfiguration(ProjectConfiguration projectConfiguration, RunConfigurationProperties properties) {
        this.projectConfiguration = projectConfiguration;
        this.properties = properties;
    }

    @Override
    public ProjectConfiguration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    @Override
    public List<String> getTasks() {
        return this.properties.getTasks();
    }

    @Override
    public GradleDistribution getGradleDistribution() {
        if (this.properties.isOverrideBuildSettings()) {
            return this.properties.getGradleDistribution();
        }
        return this.projectConfiguration.getBuildConfiguration().getGradleDistribution();
    }

    @Override
    public File getGradleUserHome() {
        if (this.properties.isOverrideBuildSettings()) {
            return this.properties.getGradleUserHome();
        }
        return this.projectConfiguration.getBuildConfiguration().getGradleUserHome();
    }

    @Override
    public File getJavaHome() {
        return this.properties.getJavaHome();
    }

    @Override
    public List<String> getJvmArguments() {
        return this.properties.getJvmArguments();
    }

    @Override
    public List<String> getArguments() {
        return this.properties.getArguments();
    }

    private boolean isBuildScansEnabled() {
        if (this.properties.isOverrideBuildSettings()) {
            return this.properties.isBuildScansEnabled();
        }
        return this.projectConfiguration.getBuildConfiguration().isBuildScansEnabled();
    }

    private boolean isOfflineMode() {
        if (this.properties.isOverrideBuildSettings()) {
            return this.properties.isOfflineMode();
        }
        return this.projectConfiguration.getBuildConfiguration().isOfflineMode();
    }

    @Override
    public boolean isShowExecutionView() {
        return this.properties.isShowExecutionView();
    }

    @Override
    public boolean isShowConsoleView() {
        return this.properties.isShowConsoleView();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultRunConfiguration) {
            DefaultRunConfiguration other = (DefaultRunConfiguration)obj;
            return Objects.equal((Object)this.projectConfiguration, (Object)other.projectConfiguration) && Objects.equal((Object)this.properties, (Object)other.properties);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectConfiguration, this.properties});
    }

    @Override
    public GradleArguments toGradleArguments() {
        return GradleArguments.from(this.getProjectConfiguration().getProjectDir(), this.getGradleDistribution(), this.getGradleUserHome(), this.getJavaHome(), this.isBuildScansEnabled(), this.isOfflineMode(), this.getArguments(), this.getJvmArguments());
    }
}

