/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.resources.RefreshExclusion;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.ui.resources.RefreshExclusionContributionManager;
import org.eclipse.cdt.ui.resources.RefreshExclusionContributor;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RefreshPolicyExceptionDialog
extends Dialog {
    private Combo fExceptionTypeCombo;
    private Group fExceptionPropertiesGroup;
    private Shell fShell;
    private IResource fResourceRoot = null;
    private RefreshExclusion fExclusionRoot = null;
    private RefreshExclusion fNewExclusion = null;
    private RefreshExclusionContributionManager fContrManager;
    private boolean fAddException = true;
    private List<RefreshExclusionContributor> fExclusionContributors;

    private RefreshPolicyExceptionDialog(Shell parent, boolean addException) {
        super(parent);
        this.setShellStyle(this.getShellStyle());
        this.fContrManager = RefreshExclusionContributionManager.getInstance();
        this.fAddException = addException;
        this.fExclusionContributors = new LinkedList<RefreshExclusionContributor>(this.fContrManager.getContributors());
    }

    public RefreshPolicyExceptionDialog(Shell parent, IResource resource, List<RefreshExclusion> exclusions, boolean addException) {
        this(parent, addException);
        this.fResourceRoot = resource;
        if (this.fAddException) {
            this.removeExistingContributors(exclusions);
        }
    }

    public RefreshPolicyExceptionDialog(Shell parent, RefreshExclusion exclusion, boolean addException) {
        this(parent, addException);
        this.fExclusionRoot = exclusion;
        if (this.fAddException) {
            this.removeExistingContributors(exclusion.getNestedExclusions());
        }
    }

    private void removeExistingContributors(List<RefreshExclusion> exclusions) {
        if (exclusions != null) {
            for (RefreshExclusion exclusion : exclusions) {
                RefreshExclusionContributor contributor = this.fContrManager.getContributor(exclusion.getContributorId());
                if (!this.fExclusionContributors.contains(contributor)) continue;
                this.fExclusionContributors.remove(contributor);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.fAddException) {
            newShell.setText(Messages.RefreshPolicyExceptionDialog_addDialogLabel);
        } else {
            newShell.setText(Messages.RefreshPolicyExceptionDialog_editDialogLabel);
        }
        this.fShell = newShell;
    }

    protected Control createDialogArea(Composite parent) {
        final Composite comp = (Composite)super.createDialogArea(parent);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(1808));
        if (this.fExclusionContributors.size() == 0) {
            this.fShell.setText(Messages.RefreshPolicyExceptionDialog_AddExceptionInfoDialog_title);
            Label information = new Label(comp, 0);
            information.setText(Messages.RefreshPolicyExceptionDialog_AddExceptionInfoDialog_message);
            information = new Label(comp, 0);
            this.fNewExclusion = null;
        } else {
            Label exceptionType = new Label(comp, 0);
            exceptionType.setText(Messages.RefreshPolicyExceptionDialog_exceptionTypeDropdownLabel);
            this.fExceptionTypeCombo = new Combo(comp, 8);
            GridData gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            this.fExceptionTypeCombo.setLayoutData((Object)gridData);
            if (this.fAddException) {
                for (RefreshExclusionContributor contributor : this.fExclusionContributors) {
                    this.fExceptionTypeCombo.add(contributor.getName());
                }
            } else {
                this.fExceptionTypeCombo.add(this.fContrManager.getContributor(this.fExclusionRoot.getContributorId()).getName());
            }
            this.fExceptionTypeCombo.select(0);
            this.fExceptionTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (RefreshPolicyExceptionDialog.this.fExceptionPropertiesGroup != null) {
                        RefreshPolicyExceptionDialog.this.fExceptionPropertiesGroup.dispose();
                    }
                    RefreshPolicyExceptionDialog.this.generateExceptionPropertiesGroup(comp, RefreshPolicyExceptionDialog.this.fExceptionTypeCombo.getSelectionIndex());
                    comp.layout();
                }
            });
            this.generateExceptionPropertiesGroup(comp, this.fExceptionTypeCombo.getSelectionIndex());
        }
        return comp;
    }

    private void generateExceptionPropertiesGroup(Composite parent, int selectionIndex) {
        this.fExceptionPropertiesGroup = new Group(parent, 0);
        this.fExceptionPropertiesGroup.setText(Messages.RefreshPolicyExceptionDialog_exceptionPropertiesGroupLabel);
        this.fExceptionPropertiesGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(1808);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        this.fExceptionPropertiesGroup.setLayoutData((Object)gd);
        if (this.fAddException) {
            if (this.fNewExclusion == null || this.fNewExclusion.getContributorId() != this.fExclusionContributors.get(selectionIndex).getID()) {
                this.fNewExclusion = this.fExclusionContributors.get(selectionIndex).createExclusion();
            }
            if (this.fResourceRoot != null) {
                this.fNewExclusion.setParentResource(this.fResourceRoot);
            } else {
                this.fNewExclusion.setParentExclusion(this.fExclusionRoot);
            }
            this.fExclusionContributors.get(selectionIndex).createProperiesUI((Composite)this.fExceptionPropertiesGroup, this.fNewExclusion);
        } else {
            this.fContrManager.getContributor(this.fExclusionRoot.getContributorId()).createProperiesUI((Composite)this.fExceptionPropertiesGroup, this.fExclusionRoot);
        }
    }

    public RefreshExclusion getResult() {
        if (this.fAddException) {
            return this.fNewExclusion;
        }
        return this.fExclusionRoot;
    }
}

