/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.actions.MultiGroupExecuteJob;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.ConnectionInfoDialog;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.FilesConnectionInfoDialog;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.Messages;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.BaseExecuteAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ExecuteSQLFileActionDelegate
extends BaseExecuteAction
implements IObjectActionDelegate {
    public static final int DEFAULT_FILE_SIZE = 15360;
    private DatabaseIdentifier _databaseIdentifier;
    private String _sql;
    private ISelection _selection = null;

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._databaseIdentifier;
    }

    public String getSQLStatements() {
        return this._sql;
    }

    public Runnable getPostRun() {
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this._selection != null) {
            int size = ((IStructuredSelection)this._selection).size();
            IFile file = (IFile)((IStructuredSelection)this._selection).getFirstElement();
            Object[] fileObjs = ((IStructuredSelection)this._selection).toArray();
            IFile[] files = new IFile[fileObjs.length];
            System.arraycopy(fileObjs, 0, files, 0, fileObjs.length);
            try {
                ConnectionInfoDialog dlg;
                ISQLEditorConnectionInfo connInfo = SQLFileUtil.getConnectionInfo(file);
                if (connInfo.equals(SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO)) {
                    connInfo = SQLFileUtil.getDefaultConnectionInfo();
                }
                if (size == 1) {
                    if (!connInfo.isConnected()) {
                        dlg = new ConnectionInfoDialog(SqlscrapbookPlugin.getActiveWorkbenchShell(), connInfo, false, Messages.ConnectionInfoDialog_title_for_file);
                        dlg.setMustConnect(true);
                        if (dlg.open() == 1) {
                            return;
                        }
                        connInfo = dlg.getConnectionInfo();
                        if (!connInfo.isConnected()) {
                            return;
                        }
                        SQLFileUtil.setEncodedConnectionInfo(file, connInfo.encode());
                    }
                } else if (size > 1) {
                    dlg = new FilesConnectionInfoDialog(SqlscrapbookPlugin.getActiveWorkbenchShell(), connInfo, true, files, Messages.ConnectionInfoDialog_title_for_file);
                    dlg.setMustConnect(true);
                    if (dlg.open() == 1) {
                        return;
                    }
                    fileObjs = ((FilesConnectionInfoDialog)dlg).getCheckedFiles();
                    files = new IFile[fileObjs.length];
                    System.arraycopy(fileObjs, 0, files, 0, fileObjs.length);
                    if (dlg.overrideConnectionInfo()) {
                        int i = 0;
                        while (i < files.length) {
                            IFile f = files[i];
                            SQLFileUtil.setEncodedConnectionInfo(f, connInfo.encode());
                            ++i;
                        }
                    }
                    if (!(connInfo = dlg.getConnectionInfo()).isConnected()) {
                        return;
                    }
                }
                this._databaseIdentifier = new DatabaseIdentifier(connInfo.getConnectionProfileName(), connInfo.getDatabaseName());
                String[] sqls = new String[files.length];
                String[] targets = new String[files.length];
                int i = 0;
                while (i < files.length) {
                    sqls[i] = this.readFile(files[i], null);
                    targets[i] = files[i].getFullPath().makeRelative().toString();
                    ++i;
                }
                MultiGroupExecuteJob job = new MultiGroupExecuteJob(Messages.FileExecution_job_name, this._databaseIdentifier, sqls, targets);
                job.setUser(true);
                job.schedule();
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.datatools.sqltools.result.resultView");
            }
            catch (PartInitException e) {
                this.processError("ExecuteSQLActionDelegate.error.initview", (Exception)((Object)e), null);
            }
            catch (CoreException e) {
                this.processError("ExecuteSQLFileActionDelegate.error.msg", (Exception)((Object)e), e.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this._selection = selection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFile(IFile file, String encoding) throws CoreException {
        String string;
        Reader in = null;
        InputStream contentStream = file.getContents();
        try {
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            in = new BufferedReader(new InputStreamReader(contentStream, encoding), 15360);
            StringBuffer buffer = new StringBuffer(15360);
            char[] readBuffer = new char[2048];
            int n = in.read(readBuffer);
            while (true) {
                if (n <= 0) {
                    string = buffer.toString();
                    if (in == null) return string;
                    break;
                }
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
        }
        catch (IOException x) {
            try {
                String message = x.getMessage() != null ? x.getMessage() : "";
                Status s = new Status(4, "org.eclipse.datatools.sqltools.sqlscrapbook", 0, message, (Throwable)x);
                throw new CoreException((IStatus)s);
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            in.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    public void init(IAction action) {
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void update() {
    }
}

