###############################################################################
# Copyright (c) 2005, 2007 IBM Corporation and others.
#
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License v. 2.0 which is available at
# http://www.eclipse.org/legal/epl-2.0.
#
# SPDX-License-Identifier: EPL-2.0
#

###############################################################################

require 'base64'

module XoredDebugger

    class ErrorMessages
    private
        ERROR_MESSAGES = {
            # 000 Command parsing errors            
            0 => 'no error',
            
            1 => 'parse error in command',
            
            2 => 'duplicate arguments in command',
            
            3 => 'invalid options (ie, missing a required option, invalid value for a passed option)',
            
            4 => 'Unimplemented command',
            
            5 => 'Command not available (Is used for async commands. For instance ' +
                'if the engine is in state "run" then only "break" and "status" are available).',
            
            # 100 File related errors
            
            100 => 'can not open file (as a reply to a "source" command if the ' +
                  'requested source file can''t be opened)',
            
            101 => 'stream redirect failed',            
            
            # 200 Breakpoint, or code flow errors
            
            200 => 'breakpoint could not be set (for some reason the breakpoint ' +
                  'could not be set due to problems registering it) ',
            
            201 => 'breakpoint type not supported (for example I don''t support ' +
                  'watch yet and thus return this error)',
            
            202 => 'invalid breakpoint (the IDE tried to set a breakpoint on a ' +
                  'line that does not exist in the file (ie "line 0" or lines ' +
                  'past the end of the file) ',
                  
            203 => 'no code on breakpoint line (the IDE tried to set a breakpoint ' +
                  'on a line which does not have any executable code. The ' +
                  'debugger engine is NOT required to return this type if it ' +
                  'is impossible to determine if there is code on a given ' +
                  'location. (For example, in the PHP debugger backend this ' +
                  'will only be returned in some special cases where the current ' +
                  'scope falls into the scope of the breakpoint to be set)).',
                  
            204 => 'Invalid breakpoint state (using an unsupported breakpoint state ' +
                  'was attempted)',
                   
            205 => 'No such breakpoint (used in breakpoint_get etc. to show that ' +
                  'there is no breakpoint with the given ID)',
                  
            206 => 'Error evaluating code (use from eval() (or perhaps ' +
                  'property_get for a full name get)) ',
                  
            207 => 'Invalid expression (the expression used for a non-eval() ' +
                  'was invalid)',
            
            # 300 Data errors
            
            300 => 'Can not get property (when the requested property to get did ' +
                  'not exist, this is NOT used for an existing but uninitialized ' +
                  'property, which just gets the type "uninitialised" (See: ' +
                  'PreferredTypeNames)).',
                  
            301 => 'Stack depth invalid (the -d stack depth parameter did not ' +
                  'exist (ie, there were less stack elements than the number ' +
                  'requested) or the parameter was < 0) ',
                  
            302 => 'Context invalid (an non existing context was requested)',
            
            # 900 Protocol errors
            
            900 => 'Encoding not supported',
            
            998 => 'An internal exception in the debugger occurred',
            
            999 => 'Unknown error'            
        }
        
    public
        def ErrorMessages.get_message(code)  
            ERROR_MESSAGES[code]
        end        
    end    
end # module
