/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.core.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.emf.core.internal.plugin.EMFCoreDebugOptions;
import org.eclipse.gmf.runtime.emf.core.internal.plugin.EMFCorePlugin;

public class MetamodelManager {
    private static final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private static final Map METAMODEL_MAP = new HashMap();
    private static final Map REVERSE_METAMODEL_MAP = new HashMap();

    public static void register(ENamedElement element) {
        MetamodelManager.register(element, null);
    }

    public static void register(ENamedElement element, ResourceLocator resourceLocator) {
        if (element instanceof EOperation) {
            return;
        }
        if (element instanceof EParameter) {
            return;
        }
        String id = MetamodelManager.getNonCachedID(element);
        String name = element.getName();
        String displayName = null;
        if (resourceLocator == null && element instanceof EPackage) {
            resourceLocator = MetamodelManager.findResourceLocator((EPackage)element);
        }
        if (resourceLocator != null) {
            EEnum eEnum;
            if (element instanceof EClass) {
                displayName = resourceLocator.getString("_UI_" + name + "_type");
            } else if (element instanceof EStructuralFeature) {
                EClass eClass = ((EStructuralFeature)element).getEContainingClass();
                if (eClass != null) {
                    displayName = resourceLocator.getString("_UI_" + eClass.getName() + "_" + name + "_feature");
                }
            } else if (element instanceof EEnumLiteral && (eEnum = ((EEnumLiteral)element).getEEnum()) != null) {
                displayName = resourceLocator.getString("_UI_" + eEnum.getName() + "_" + name + "_literal");
            }
        }
        if (displayName == null) {
            displayName = name;
        }
        METAMODEL_MAP.put(element, new MetaModelDescriptor(id, displayName));
        REVERSE_METAMODEL_MAP.put(id, element);
        for (Object child : element.eContents()) {
            if (!(child instanceof ENamedElement)) continue;
            MetamodelManager.register((ENamedElement)child, resourceLocator);
        }
    }

    private static ResourceLocator findResourceLocator(EPackage pkg) {
        ResourceLocator result = null;
        ArrayList<Object> types = new ArrayList<Object>(2);
        types.add(pkg);
        types.add(IItemLabelProvider.class);
        AdapterFactory factory = adapterFactory.getFactoryForTypes(types);
        if (factory != null) {
            Adapter adapter;
            EObject instance = null;
            for (Object next : pkg.getEClassifiers()) {
                if (!(next instanceof EClass) || ((EClass)next).isAbstract()) continue;
                instance = pkg.getEFactoryInstance().create((EClass)next);
                break;
            }
            if (instance != null && (adapter = factory.adapt(instance, IItemLabelProvider.class)) instanceof ResourceLocator) {
                result = (ResourceLocator)adapter;
            }
        }
        return result;
    }

    public static String getID(ENamedElement element) {
        if (element instanceof EOperation) {
            IllegalArgumentException e = new IllegalArgumentException("EOperation does not support IDs");
            Trace.throwing((Plugin)EMFCorePlugin.getDefault(), (String)EMFCoreDebugOptions.EXCEPTIONS_THROWING, MetamodelManager.class, (String)"getID", (Throwable)e);
            throw e;
        }
        if (element instanceof EParameter) {
            IllegalArgumentException e = new IllegalArgumentException("EParameter does not support IDs");
            Trace.throwing((Plugin)EMFCorePlugin.getDefault(), (String)EMFCoreDebugOptions.EXCEPTIONS_THROWING, MetamodelManager.class, (String)"getID", (Throwable)e);
            throw e;
        }
        MetaModelDescriptor descriptor = (MetaModelDescriptor)METAMODEL_MAP.get(element);
        if (descriptor != null) {
            return descriptor.id;
        }
        return MetamodelManager.getNonCachedID(element);
    }

    public static String getLocalName(ENamedElement element) {
        MetamodelManager.tryRegisterElement(element);
        MetaModelDescriptor descriptor = (MetaModelDescriptor)METAMODEL_MAP.get(element);
        if (descriptor != null) {
            return descriptor.localName;
        }
        return element.getName();
    }

    public static String getDisplayName(ENamedElement element) {
        MetamodelManager.tryRegisterElement(element);
        MetaModelDescriptor descriptor = (MetaModelDescriptor)METAMODEL_MAP.get(element);
        if (descriptor != null) {
            return descriptor.displayName;
        }
        return element.getName();
    }

    public static ENamedElement getElement(String id) {
        ENamedElement result = (ENamedElement)REVERSE_METAMODEL_MAP.get(id);
        if (result == null && id != null) {
            result = MetamodelManager.findInPackageRegistry(id);
        }
        return result;
    }

    private static ENamedElement findInPackageRegistry(String id) {
        ENamedElement result = null;
        int dot = id.indexOf(46);
        String pkgName = dot >= 0 ? id.substring(0, dot) : id;
        for (Object next : EPackage.Registry.INSTANCE.values()) {
            EPackage pkg;
            if (!(next instanceof EPackage) || !pkgName.equals((pkg = (EPackage)next).getName()) || (result = MetamodelManager.findElement((ENamedElement)pkg, id)) == null) continue;
            MetamodelManager.register((ENamedElement)pkg, null);
            break;
        }
        return result;
    }

    private static ENamedElement findElement(ENamedElement element, String id) {
        ENamedElement result = null;
        int dot = id.indexOf(46);
        if (dot < 0) {
            if (id.equals(element.getName())) {
                result = element;
            }
        } else {
            String name = id.substring(0, dot);
            if (name.equals(element.getName())) {
                id = id.substring(dot + 1);
                Iterator iter = element.eContents().iterator();
                while (result == null && iter.hasNext()) {
                    Object next = iter.next();
                    if (!(next instanceof ENamedElement)) continue;
                    result = MetamodelManager.findElement((ENamedElement)next, id);
                }
            }
        }
        return result;
    }

    private static String getNonCachedID(ENamedElement element) {
        StringBuffer id = new StringBuffer();
        ENamedElement current = element;
        while (current != null) {
            id.insert(0, current.getName());
            EObject container = current.eContainer();
            current = null;
            if (container == null) continue;
            if (container instanceof ENamedElement) {
                current = (ENamedElement)container;
                id.insert(0, '.');
                continue;
            }
            return null;
        }
        return id.toString();
    }

    private static void tryRegisterElement(ENamedElement element) {
        String pkgName;
        if (element instanceof EOperation || element instanceof EParameter) {
            return;
        }
        String id = MetamodelManager.getID(element);
        if (id == null) {
            return;
        }
        int dot = id.indexOf(46);
        String string = pkgName = dot >= 0 ? id.substring(0, dot) : id;
        if (REVERSE_METAMODEL_MAP.get(pkgName) != null) {
            return;
        }
        for (Object next : EPackage.Registry.INSTANCE.values()) {
            EPackage pkg;
            if (!(next instanceof EPackage) || !pkgName.equals((pkg = (EPackage)next).getName())) continue;
            MetamodelManager.register((ENamedElement)pkg, null);
        }
    }

    private static class MetaModelDescriptor {
        public String id = null;
        public String localName = null;
        public String displayName = null;

        public MetaModelDescriptor(String id, String displayName) {
            this.id = id.intern();
            this.localName = displayName.replaceAll(" ", "").intern();
            this.displayName = displayName.intern();
        }
    }
}

