/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.diagnostics;

import java.text.MessageFormat;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.validation.internal.ELValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.Messages;
import org.eclipse.osgi.util.NLS;

public final class DiagnosticFactory {
    public static final String SOURCE_ID = "org.eclipse.jst.jsf.validation.el.Diagnostics";
    public static final int BINARY_OP_BOTH_OPERANDS_NULL_ID = 0;
    public static final int BINARY_OP_POSSIBLE_DIVISION_BY_ZERO_ID = 1;
    public static final int BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION_ID = 2;
    public static final int BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME_ID = 3;
    public static final int BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME_ID = 4;
    public static final int BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN_ID = 5;
    public static final int BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS_ID = 6;
    public static final int BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME_ID = 7;
    public static final int BINARY_OP_NO_AVAILABLE_TYPE_COERCION_ID = 8;
    public static final int BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS_ID = 9;
    public static final int UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME_ID = 10;
    public static final int UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE_ID = 11;
    public static final int UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO_ID = 12;
    public static final int UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION_ID = 13;
    public static final int UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN_ID = 14;
    public static final int TERNARY_OP_CHOICE_IS_ALWAYS_SAME_ID = 15;
    public static final int TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN_ID = 16;
    public static final int UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED_ID = 17;
    public static final int CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING_ID = 18;
    public static final int MEMBER_NOT_FOUND_ID = 19;
    public static final int VARIABLE_NOT_FOUND_ID = 20;
    public static final int MISSING_CLOSING_EXPR_BRACKET_ID = 21;
    public static final int GENERAL_SYNTAX_ERROR_ID = 22;
    public static final int EMPTY_EL_EXPRESSION_ID = 23;
    public static final int BINARY_OP_DOT_WITH_VALUEB_NULL_ID = 24;
    public static final int BINARY_OP_DOT_WITH_DOTTED_KEY_SHOULD_USE_ARRAY_ID = 25;
    public static final int POSSIBLE_ARRAY_INDEX_OUT_OF_BOUNDS_ID = 26;
    public static final int BINARY_COMPARISON_WITH_ENUM_ALWAYS_SAME_ID = 27;
    public static final int BINARY_OP_COMPARISON_OF_ENUMS_INCOMPATIBLE_ID = 28;
    public static final int MEMBER_IS_INTERMEDIATE_ID = 29;
    public static final int NUM_IDS = 30;
    private static Diagnostic DIAGNOSTIC_POSSIBLE_DIV_BY_ZERO;
    private static Diagnostic DIAGNOSTIC_NO_AVAILABLE_TYPE_COERCION;
    private static Diagnostic DIAGNOSTIC_COULD_NOT_COERCE_LITERALS;

    public Diagnostic create_BINARY_OP_BOTH_OPERANDS_NULL(String operatorName) {
        String message = NLS.bind((String)Messages.BINARY_OP_BOTH_OPERANDS_NULL, (Object)operatorName);
        return this.create(0, message);
    }

    public Diagnostic create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO() {
        if (DIAGNOSTIC_POSSIBLE_DIV_BY_ZERO == null) {
            String message = Messages.POSSIBLE_DIV_BY_ZERO;
            DIAGNOSTIC_POSSIBLE_DIV_BY_ZERO = this.create(1, message);
        }
        return DIAGNOSTIC_POSSIBLE_DIV_BY_ZERO;
    }

    public Diagnostic create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(String operatorName) {
        String message = NLS.bind((String)Messages.BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION, (Object)operatorName);
        return this.create(2, message);
    }

    public Diagnostic create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME(String operatorName, String value) {
        String message = NLS.bind((String)Messages.BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME, (Object)operatorName, (Object)value);
        return this.create(3, message);
    }

    public Diagnostic create_BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME(String value) {
        String message = NLS.bind((String)Messages.BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME, (Object)value);
        return this.create(4, message);
    }

    public Diagnostic create_BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN(String whichArgument) {
        String message = NLS.bind((String)Messages.BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN, (Object)whichArgument);
        return this.create(5, message);
    }

    public Diagnostic create_BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS(boolean shortCircuitValue, String operatorName) {
        String message = NLS.bind((String)Messages.BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS, (Object)shortCircuitValue, (Object)operatorName);
        return this.create(6, message);
    }

    public Diagnostic create_BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME(boolean shortCircuitValue, String operatorName) {
        String message = NLS.bind((String)Messages.BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME, (Object)shortCircuitValue, (Object)operatorName);
        return this.create(7, message);
    }

    public Diagnostic create_BINARY_OP_NO_AVAILABLE_TYPE_COERCION() {
        if (DIAGNOSTIC_NO_AVAILABLE_TYPE_COERCION == null) {
            DIAGNOSTIC_NO_AVAILABLE_TYPE_COERCION = this.create(8, Messages.BINARY_OP_NO_AVAILABLE_TYPE_COERCION);
        }
        return DIAGNOSTIC_NO_AVAILABLE_TYPE_COERCION;
    }

    public Diagnostic create_BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS() {
        if (DIAGNOSTIC_COULD_NOT_COERCE_LITERALS == null) {
            DIAGNOSTIC_COULD_NOT_COERCE_LITERALS = this.create(9, Messages.BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS);
        }
        return DIAGNOSTIC_COULD_NOT_COERCE_LITERALS;
    }

    public Diagnostic create_UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME_ID(String operatorName, String value) {
        String message = NLS.bind((String)Messages.UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME, (Object)operatorName, (Object)value);
        return this.create(10, message);
    }

    public Diagnostic create_UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE() {
        return this.create(11, Messages.UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE);
    }

    public Diagnostic create_UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO() {
        return this.create(12, Messages.UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO);
    }

    public Diagnostic create_UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(String operatorName) {
        String message = NLS.bind((String)Messages.UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION, (Object)operatorName);
        return this.create(13, message);
    }

    public Diagnostic create_UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED(String operatorName) {
        String message = NLS.bind((String)Messages.UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED, (Object)operatorName);
        return this.create(17, message);
    }

    public Diagnostic create_UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN() {
        return this.create(14, Messages.UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN);
    }

    public Diagnostic create_TERNARY_OP_CHOICE_IS_ALWAYS_SAME(boolean result, String whichSelected) {
        String message = NLS.bind((String)Messages.TERNARY_OP_CHOICE_IS_ALWAYS_SAME, (Object)result, (Object)whichSelected);
        return this.create(15, message);
    }

    public Diagnostic create_TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN() {
        return this.create(16, Messages.TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN_ID);
    }

    public Diagnostic create_CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING() {
        return this.create(18, Messages.CANNOT_APPLY_OPERATORS_TO_MB);
    }

    public Diagnostic create_MEMBER_NOT_FOUND(String curMemberSymbol, String owningMember) {
        return this.create(19, NLS.bind((String)Messages.VM_PROP_NAME_NOT_FOUND, (Object)curMemberSymbol, (Object)owningMember));
    }

    public Diagnostic create_VARIABLE_NOT_FOUND(String variableName) {
        return this.create(20, NLS.bind((String)Messages.VM_ROOT_NAME_NOT_FOUND, (Object)variableName));
    }

    public Diagnostic create_MISSING_CLOSING_EXPR_BRACKET() {
        return this.create(21, Messages.MISSING_CLOSING_EXPR_BRACKET);
    }

    public Diagnostic create_GENERAL_SYNTAX_ERROR() {
        return this.create(22, Messages.GENERAL_SYNTAX_ERROR);
    }

    public Diagnostic create_EMPTY_EL_EXPRESSION() {
        return this.create(23, Messages.EMPTY_EL_EXPRESSION);
    }

    public Diagnostic create_BINARY_OP_DOT_WITH_VALUEB_NULL(String operatorName) {
        return this.create(24, Messages.bind((String)Messages.BINARY_OP_DOT_WITH_VALUEB_NULL, (Object)operatorName));
    }

    public Diagnostic create_BINARY_OP_DOT_WITH_VALUEA_MAP_SHOULD_USE_ARRAY(String valAName, String valueBName) {
        Object[] formatArgs = new Object[]{valAName, valueBName};
        return this.create(25, MessageFormat.format(Messages.BINARY_OP_DOT_WITH_DOTTED_KEY_SHOULD_USE_ARRAY, formatArgs));
    }

    public Diagnostic create_POSSIBLE_ARRAY_INDEX_OUT_OF_BOUNDS(Integer value) {
        Object[] formatArgs = new Object[]{value};
        return this.create(26, MessageFormat.format(Messages.POSSIBLE_ARRAY_INDEX_OUT_OF_BOUNDS, formatArgs));
    }

    public Diagnostic create_BINARY_COMPARISON_WITH_ENUM_AND_CONST_ALWAYS_SAME(String operatorName, boolean invariantResult, String enumName, String fieldName) {
        return this.create(27, MessageFormat.format(Messages.BINARY_COMPARISON_WITH_ENUM_AND_CONST_ALWAYS_SAME, operatorName, invariantResult, enumName, fieldName));
    }

    public Diagnostic create_BINARY_COMPARISON_WITH_TWO_ENUMS_ALWAYS_SAME(String operatorName, boolean invariantResult, String enumName1, String enumName2) {
        return this.create(27, MessageFormat.format(Messages.BINARY_COMPARISON_WITH_TWO_ENUMS_ALWAYS_SAME, operatorName, invariantResult, enumName1, enumName2));
    }

    public Diagnostic create_BINARY_COMPARISON_WITH_ENUM_AND_UNCOERCABLE_NONCONST_ALWAYS_SAME(String operatorName, boolean invariantResult, String enumName, String nonEnum) {
        return this.create(27, MessageFormat.format(Messages.BINARY_COMPARISON_WITH_ENUM_AND_UNCOERCABLE_NONCONST_ALWAYS_SAME, operatorName, invariantResult, enumName, nonEnum));
    }

    public Diagnostic create_BINARY_OP_COMPARISON_OF_ENUMS_INCOMPATIBLE() {
        return this.create(28, Messages.BINARY_OP_COMPARISON_OF_ENUMS_INCOMPATIBLE);
    }

    public Diagnostic create_MEMBER_IS_INTERMEDIATE(String intermediateMemberName) {
        return this.create(29, NLS.bind((String)Messages.MEMBER_IS_INTERMEDIATE, (Object)intermediateMemberName));
    }

    private BasicDiagnostic create(int diagnosticId, String message) {
        int severity = ELValidationPreferences.getDefaultSeverity(diagnosticId);
        return new BasicDiagnostic(severity, SOURCE_ID, diagnosticId, message, null);
    }
}

