/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.businessprocess;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.archive.JsonStorage;
import org.eclipse.jubula.client.archive.errorhandling.IProjectNameConflictResolver;
import org.eclipse.jubula.client.archive.errorhandling.NullProjectNameConflictResolver;
import org.eclipse.jubula.client.archive.i18n.Messages;
import org.eclipse.jubula.client.core.businessprocess.INameMapper;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.ProjectCompNameCache;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.businessprocess.progress.ProgressMonitorTracker;
import org.eclipse.jubula.client.core.errorhandling.ErrorMessagePresenter;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.tools.internal.exception.ConfigXmlException;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.version.IVersion;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageBP {
    public static final String JUB = ".jub";
    public static final Logger LOG = LoggerFactory.getLogger(FileStorageBP.class);
    private static final int TOTAL_IMPORT_WORK = 100;
    private static final int NUM_HBM_PROGRESS_EVENT_TYPES = 4;
    private static final int PARSE_FILES_WORK = 95;
    private static final int SAVE_TO_DB_WORK = 5;
    private static IProjectNameConflictResolver projectNameConflictResolver = new NullProjectNameConflictResolver();

    private FileStorageBP() {
    }

    public static void exportProjectList(List<IProjectPO> projectList, String exportDirName, EntityManager exportSession, IProgressMonitor monitor, boolean writeToSystemTempDir, List<File> listOfProjectFiles, IProgressConsole console) throws JBException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ExportAllBPExporting, (int)JsonStorage.getWorkToSave(projectList));
        for (IProjectPO proj : projectList) {
            String exportFileName;
            if (subMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            IProjectPO projectToExport = ProjectPM.loadProjectByIdAndPreLoad((Long)proj.getId(), (EntityManager)exportSession);
            String projectFileName = String.valueOf(projectToExport.getDisplayName()) + JUB;
            if (writeToSystemTempDir) {
                exportFileName = projectFileName;
            } else {
                if (projectToExport.equals((Object)GeneralStorage.getInstance().getProject())) {
                    projectToExport = GeneralStorage.getInstance().getProject();
                }
                exportFileName = String.valueOf(exportDirName) + projectFileName;
            }
            if (subMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            console.writeStatus((IStatus)new Status(1, "org.eclipse.jubula.client.core", NLS.bind((String)Messages.ExportAllBPInfoStartingExportProject, (Object)projectFileName)));
            try {
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                JsonStorage.save(projectToExport, exportFileName, true, (IProgressMonitor)subMonitor.newChild(1), console);
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                console.writeStatus((IStatus)new Status(1, "org.eclipse.jubula.client.core", NLS.bind((String)Messages.ExportAllBPInfoFinishedExportProject, (Object)projectFileName)));
            }
            catch (PMSaveException e) {
                LOG.error(Messages.CouldNotExportProject, (Throwable)e);
                console.writeStatus((IStatus)new Status(1, "org.eclipse.jubula.client.core", NLS.bind((String)Messages.ExportAllBPErrorExportFailedProject, (Object[])new Object[]{projectFileName, e.getMessage()})));
            }
            exportSession.detach((Object)projectToExport);
            exportSession.clear();
        }
    }

    public static void importFiles(List<URL> importProjectURLs, IProgressMonitor monitor, IProgressConsole console, boolean openProject) {
        try {
            FileStorageBP.doImport(importProjectURLs, SubMonitor.convert((IProgressMonitor)monitor), console, openProject);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static IProjectPO importProject(List<URL> fileURLs, IProgressMonitor monitor, IProgressConsole console, boolean openProject) throws InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ImportFileBPImporting, (int)100);
        return FileStorageBP.doImport(fileURLs, subMonitor, console, openProject);
    }

    private static IProjectPO doImport(List<URL> fileURLs, SubMonitor subMonitor, IProgressConsole console, boolean openProject) throws InterruptedException {
        ReadFilesOperation readFilesOp = new ReadFilesOperation(fileURLs, console);
        readFilesOp.run((IProgressMonitor)subMonitor.newChild(95));
        ImportOperation importOp = new ImportOperation(readFilesOp.getProjectToMapperMap(), readFilesOp.getProjectToCompCacheMap(), console, openProject);
        importOp.run((IProgressMonitor)subMonitor.newChild(5));
        return importOp.getProjectToOpen();
    }

    private static void showErrorDuringImport(IProgressConsole console, String projectFileName, Exception e) {
        console.writeErrorLine(NLS.bind((String)Messages.ImportFileActionErrorImportFailedProject, (Object[])new Object[]{projectFileName, e.getMessage()}));
    }

    private static void showFinishedImport(IProgressConsole console) {
        console.writeLine(Messages.ImportFileActionInfoFinishedImport);
    }

    private static void showFinishedImport(IProgressConsole console, String projectFileName) {
        console.writeLine(NLS.bind((String)Messages.ImportFileActionInfoFinishedImportProject, (Object)projectFileName));
    }

    private static void showFinishedReadingProjects(IProgressConsole console) {
        console.writeLine(Messages.ImportFileActionInfoFinishedReadingProjects);
    }

    private static void showStartingImport(IProgressConsole console) {
        console.writeLine(Messages.ImportFileActionInfoStartingImport);
    }

    private static void showStartingImport(IProgressConsole console, String projectFileName) {
        console.writeLine(NLS.bind((String)Messages.ImportFileActionInfoStartingImportProject, (Object)projectFileName));
    }

    private static void showStartingReadingProjects(IProgressConsole console) {
        console.writeLine(Messages.ImportFileActionInfoStartingReadingProjects);
    }

    public static void setProjectNameConflictResolver(IProjectNameConflictResolver resolver) {
        Validate.notNull((Object)resolver);
        projectNameConflictResolver = resolver;
    }

    private static void handlePMReadException(PMReadException e, List<URL> fileURLs) {
        ErrorMessagePresenter.getPresenter().showErrorMessage(new JBException((Object)((Object)e) + Messages.Reading + fileURLs.toArray() + Messages.Failed, MessageIDs.E_IMPORT_XML_FAILED), null, MessageIDs.getMessageObject((Integer)e.getErrorId()).getDetails());
    }

    private static void handleCapDataNotFound(ConfigXmlException ce) {
        ErrorMessagePresenter.getPresenter().showErrorMessage(MessageIDs.E_IMPORT_PROJECT_CONFIG_CONFLICT, null, new String[]{ce.getMessage()});
    }

    private static void handleUnsupportedToolkits(String errorMessage) {
        ErrorMessagePresenter.getPresenter().showErrorMessage(MessageIDs.E_UNSUPPORTED_TOOLKIT, null, new String[]{errorMessage});
    }

    static /* synthetic */ void access$0(IProgressConsole iProgressConsole) {
        FileStorageBP.showStartingImport(iProgressConsole);
    }

    static /* synthetic */ void access$1(IProgressConsole iProgressConsole) {
        FileStorageBP.showStartingReadingProjects(iProgressConsole);
    }

    static /* synthetic */ void access$2(String string) {
        FileStorageBP.handleUnsupportedToolkits(string);
    }

    static /* synthetic */ void access$3(IProgressConsole iProgressConsole) {
        FileStorageBP.showFinishedReadingProjects(iProgressConsole);
    }

    static /* synthetic */ void access$4(PMReadException pMReadException, List list) {
        FileStorageBP.handlePMReadException(pMReadException, list);
    }

    private static class CompleteImportOperation
    implements IRunnableWithProgress {
        private Map<IProjectPO, INameMapper> m_projectToMapperMap;
        private Map<IProjectPO, IWritableComponentNameCache> m_projectToCompCacheMap;
        private boolean m_isRefreshRequired = false;
        private boolean m_wasImportSuccessful = false;
        private IProgressConsole m_console;

        public CompleteImportOperation(Map<IProjectPO, INameMapper> projectToMapperMap, Map<IProjectPO, IWritableComponentNameCache> projectToCompCacheMap, IProgressConsole console) {
            this.m_projectToMapperMap = projectToMapperMap;
            this.m_projectToCompCacheMap = projectToCompCacheMap;
            this.m_console = console;
        }

        public void run(IProgressMonitor monitor) throws InterruptedException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ImportFileBPImporting, (int)this.m_projectToMapperMap.size());
            if (this.checkImportProblems()) {
                return;
            }
            for (IProjectPO proj : this.m_projectToMapperMap.keySet()) {
                JBException gde;
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                String projectName = proj.getDisplayName();
                FileStorageBP.showStartingImport(this.m_console, projectName);
                try {
                    this.m_wasImportSuccessful = this.importProject(proj, (IProgressMonitor)subMonitor.newChild(1));
                    FileStorageBP.showFinishedImport(this.m_console, projectName);
                }
                catch (PMSaveException e) {
                    LOG.warn(Messages.ErrorWhileImportingProject, (Throwable)e);
                    gde = new JBException((Object)((Object)e) + " " + ":" + Messages.SaveOf + proj.getName() + " " + Messages.Failed, MessageIDs.E_IMPORT_PROJECT_XML_FAILED);
                    FileStorageBP.showErrorDuringImport(this.m_console, projectName, (Exception)gde);
                    ErrorMessagePresenter.getPresenter().showErrorMessage(gde, (Object[])new String[]{proj.getName()}, null);
                }
                catch (PMException pme) {
                    LOG.warn(Messages.ErrorWhileImportingProject, (Throwable)pme);
                    gde = new JBException((Object)((Object)pme) + Messages.ImportOf + proj.getName() + " " + Messages.Failed, MessageIDs.E_IMPORT_PROJECT_XML_FAILED);
                    FileStorageBP.showErrorDuringImport(this.m_console, projectName, (Exception)gde);
                    ErrorMessagePresenter.getPresenter().showErrorMessage(gde, (Object[])new String[]{proj.getName()}, null);
                }
                catch (ProjectDeletedException e) {
                    gde = new JBException((Object)((Object)e) + Messages.ImportOf + proj.getName() + " " + Messages.Failed, MessageIDs.E_ALREADY_DELETED_PROJECT);
                    FileStorageBP.showErrorDuringImport(this.m_console, projectName, (Exception)gde);
                    ErrorMessagePresenter.getPresenter().showErrorMessage(gde, (Object[])new String[]{proj.getName()}, null);
                }
            }
            FileStorageBP.showFinishedImport(this.m_console);
        }

        private boolean checkImportProblems() {
            HashMap<String, String> guidToNameMap = new HashMap<String, String>();
            if (this.checkImportedProjects(guidToNameMap)) {
                return true;
            }
            EntityManager circularDependencyCheckSess = Persistor.instance().openSession();
            try {
                if (this.checkNameGuidConflict(guidToNameMap)) {
                    return true;
                }
                if (this.checkCircularDependencies(circularDependencyCheckSess)) {
                    return true;
                }
            }
            catch (PMException pme) {
                ErrorMessagePresenter.getPresenter().showErrorMessage(new JBException((Object)((Object)pme) + Messages.ImportFailed, MessageIDs.E_DATABASE_GENERAL), null, null);
                return true;
            }
            finally {
                Persistor.instance().dropSessionWithoutLockRelease(circularDependencyCheckSess);
            }
            return false;
        }

        private boolean checkCircularDependencies(EntityManager circularDependencyCheckSess) {
            for (IProjectPO proj : this.m_projectToMapperMap.keySet()) {
                HashSet checkedProjects = new HashSet();
                HashSet<IProjectPO> illegalProjects = new HashSet<IProjectPO>();
                illegalProjects.add(proj);
                HashSet<IProjectPO> projectsToCheck = new HashSet<IProjectPO>();
                for (IReusedProjectPO reused : proj.getUsedProjects()) {
                    IProjectPO reusedProject = null;
                    for (IProjectPO importedProject : this.m_projectToMapperMap.keySet()) {
                        if (!reused.getProjectGuid().equals(importedProject.getGuid()) || !reused.getProjectVersion().equals((Object)importedProject.getProjectVersion())) continue;
                        reusedProject = importedProject;
                        break;
                    }
                    if (reusedProject == null) {
                        try {
                            reusedProject = ProjectPM.loadReusedProject((IReusedProjectPO)reused, (EntityManager)circularDependencyCheckSess);
                        }
                        catch (JBException e) {
                            this.handleCircularDependency(this.m_console, proj.getName());
                            return true;
                        }
                    }
                    if (reusedProject == null) continue;
                    projectsToCheck.add(reusedProject);
                }
                for (IProjectPO projToCheck : projectsToCheck) {
                    ProjectPM.findIllegalProjects((IProjectPO)projToCheck, checkedProjects, illegalProjects, this.m_projectToMapperMap.keySet());
                }
                illegalProjects.remove(proj);
                if (illegalProjects.isEmpty()) continue;
                this.handleCircularDependency(this.m_console, proj.getName());
                return true;
            }
            return false;
        }

        public boolean wasImportSuccessful() {
            return this.m_wasImportSuccessful;
        }

        private boolean importProject(IProjectPO proj, IProgressMonitor monitor) throws PMException, ProjectDeletedException, InterruptedException {
            if (this.projectExists(proj.getGuid(), proj.getMajorProjectVersion(), proj.getMinorProjectVersion(), proj.getMicroProjectVersion(), proj.getProjectVersionQualifier())) {
                String projectNameToImport = proj.getName();
                this.handleProjectExists(this.m_console, ProjectNameBP.getInstance().getName(proj.getGuid(), false), projectNameToImport, proj.getProjectVersion());
                return false;
            }
            String selectedProjectName = this.checkProjectAndRename(proj.getGuid(), proj.getName());
            if (selectedProjectName != null) {
                proj.setClientMetaDataVersion(IVersion.JB_CLIENT_METADATA_VERSION);
                boolean willRequireRefresh = false;
                IProjectPO currentProject = GeneralStorage.getInstance().getProject();
                if (currentProject != null) {
                    for (IReusedProjectPO reused : currentProject.getUsedProjects()) {
                        if (this.m_isRefreshRequired || willRequireRefresh) break;
                        String guid = reused.getProjectGuid();
                        boolean bl = willRequireRefresh = proj.getGuid().equals(guid) && proj.getProjectVersion().equals((Object)reused.getProjectVersion());
                    }
                    this.m_isRefreshRequired = willRequireRefresh || this.m_isRefreshRequired;
                }
                monitor.beginTask("", this.getTotalWork(proj));
                monitor.subTask(Messages.ImportFileBPSaveToDB);
                ProgressMonitorTracker tracker = ProgressMonitorTracker.SINGLETON;
                tracker.setProgressMonitor(monitor);
                IWritableComponentNameCache compNameCache = this.m_projectToCompCacheMap.get(proj);
                try {
                    ProjectPM.saveProject((IProjectPO)proj, (String)selectedProjectName, (INameMapper)this.m_projectToMapperMap.get(proj), (IWritableComponentNameCache)compNameCache);
                }
                finally {
                    tracker.setProgressMonitor(null);
                }
                UsedToolkitBP.getInstance().refreshToolkitInfo(proj);
                return true;
            }
            return false;
        }

        private int getTotalWork(IProjectPO proj) {
            int totalWork = 1;
            for (ITestSuitePO testSuite : TestSuiteBP.getListOfTestSuites((IProjectPO)proj)) {
                totalWork += this.getWorkForNode((INodePO)testSuite);
            }
            for (INodePO spec : proj.getUnmodSpecList()) {
                totalWork += this.getWorkForNode(spec);
            }
            return totalWork *= 4;
        }

        private int getWorkForNode(INodePO node) {
            int work = 1;
            if (!(node instanceof IExecTestCasePO)) {
                Iterator childIter = node.getNodeListIterator();
                while (childIter.hasNext()) {
                    work += this.getWorkForNode((INodePO)childIter.next());
                }
            }
            if (node instanceof ISpecTestCasePO) {
                work += ((ISpecTestCasePO)node).getAllEventEventExecTC().size();
            }
            return work;
        }

        private boolean checkImportedProjects(Map<String, String> guidToNameMap) {
            for (IProjectPO proj : this.m_projectToMapperMap.keySet()) {
                String projectName = proj.getName();
                String guid = proj.getGuid();
                Validate.notNull((Object)projectName, (String)Messages.ImportWithoutName);
                Validate.notEmpty((String)projectName, (String)Messages.ImportEmptyName);
                if (this.isSameGuidOtherName(guidToNameMap, projectName, guid)) {
                    this.handleGuidConflict(projectName, guidToNameMap.get(guid));
                    return true;
                }
                if (this.isOtherGuidSameName(guidToNameMap, projectName, guid)) {
                    this.handleNameConflict(projectName);
                    return true;
                }
                guidToNameMap.put(guid, projectName);
            }
            return false;
        }

        private boolean isOtherGuidSameName(Map<String, String> guidToNameMap, String projectName, String guid) {
            return guidToNameMap.containsValue(projectName) && !projectName.equals(guidToNameMap.get(guid));
        }

        private boolean isSameGuidOtherName(Map<String, String> guidToNameMap, String projectName, String guid) {
            return guidToNameMap.containsKey(guid) && !projectName.equals(guidToNameMap.get(guid));
        }

        private void handleNameConflict(String name) {
            ErrorMessagePresenter.getPresenter().showErrorMessage(MessageIDs.E_PROJ_NAME_CONFLICT, (Object[])new String[0], new String[]{name});
        }

        private void handleCircularDependency(IProgressConsole console, String name) {
            console.writeErrorLine(NLS.bind((String)Messages.ErrorMessagePROJ_CIRC_DEPEND, (Object)name));
            ErrorMessagePresenter.getPresenter().showErrorMessage(MessageIDs.E_PROJ_CIRC_DEPEND, (Object[])new String[]{name}, null);
        }

        private String checkProjectAndRename(String guid, String projectName) {
            String selectedName = projectName;
            String existingNameForGuid = ProjectNameBP.getInstance().getName(guid);
            if (existingNameForGuid != null && !existingNameForGuid.equals(projectName)) {
                if (ProjectPM.doesProjectNameExist((String)projectName)) {
                    ArrayList<String> possibleNames = new ArrayList<String>(1);
                    possibleNames.add(existingNameForGuid);
                    selectedName = projectNameConflictResolver.resolveNameConflict(possibleNames);
                } else {
                    String[] possibleNames = new String[]{existingNameForGuid, projectName};
                    selectedName = projectNameConflictResolver.resolveNameConflict(Arrays.asList(possibleNames));
                }
            } else if (ProjectPM.doesProjectNameExist((String)projectName) && !projectName.equals(existingNameForGuid)) {
                ArrayList<String> possibleNames = new ArrayList<String>(1);
                possibleNames.add(existingNameForGuid);
                selectedName = projectNameConflictResolver.resolveNameConflict(possibleNames);
            }
            return selectedName;
        }

        private boolean checkNameGuidConflict(Map<String, String> guidToNameMap) throws PMException {
            Map dbGuidToNameMap = ProjectNameBP.getInstance().readAllProjectNamesFromDB();
            for (String guid : guidToNameMap.keySet()) {
                if (this.isOtherGuidSameName(dbGuidToNameMap, guidToNameMap.get(guid), guid)) {
                    this.handleNameConflict(guidToNameMap.get(guid));
                    return true;
                }
                if (!this.isSameGuidOtherName(dbGuidToNameMap, guid, guidToNameMap.get(guid))) continue;
                this.handleGuidConflict(guidToNameMap.get(guid), (String)dbGuidToNameMap.get(guid));
                return true;
            }
            return false;
        }

        private void handleGuidConflict(String importName, String existingName) {
            ErrorMessagePresenter.getPresenter().showErrorMessage(MessageIDs.E_PROJ_GUID_CONFLICT, (Object[])new String[0], new String[]{importName, existingName});
        }

        private boolean projectExists(String guid, Integer majorNumber, Integer minorNumber, Integer microNumber, String versionQualifier) {
            return ProjectPM.doesProjectVersionExist((String)guid, (Integer)majorNumber, (Integer)minorNumber, (Integer)microNumber, (String)versionQualifier);
        }

        private void handleProjectExists(IProgressConsole console, String existingName, String importName, ProjectVersion version) {
            console.writeErrorLine(NLS.bind((String)Messages.ErrorMessageIMPORT_PROJECT_FAILED, (Object)importName));
            console.writeErrorLine(NLS.bind((String)Messages.ErrorMessageIMPORT_PROJECT_FAILED_EXISTING, (Object[])new String[]{existingName, version.toString()}));
        }
    }

    private static class ImportOperation
    implements IRunnableWithProgress {
        private Map<IProjectPO, INameMapper> m_projectToMapperMap;
        private Map<IProjectPO, IWritableComponentNameCache> m_projectToCompCacheMap;
        private IProjectPO m_projectToOpen = null;
        private IProgressConsole m_console;
        private boolean m_isOpenProject;

        public ImportOperation(Map<IProjectPO, INameMapper> projectToMapperMap, Map<IProjectPO, IWritableComponentNameCache> projectToCompCacheMap, IProgressConsole console, boolean openProject) {
            this.m_projectToMapperMap = projectToMapperMap;
            this.m_projectToCompCacheMap = projectToCompCacheMap;
            this.m_console = console;
            this.m_isOpenProject = openProject;
        }

        public IProjectPO getProjectToOpen() {
            return this.m_projectToOpen;
        }

        public void run(IProgressMonitor monitor) throws InterruptedException {
            try {
                try {
                    Iterator<IProjectPO> iterator;
                    NodePM.getInstance().setUseCache(true);
                    CompleteImportOperation op = new CompleteImportOperation(this.m_projectToMapperMap, this.m_projectToCompCacheMap, this.m_console);
                    op.run(monitor);
                    if (op.wasImportSuccessful() && this.m_isOpenProject && (iterator = this.m_projectToMapperMap.keySet().iterator()).hasNext()) {
                        IProjectPO project;
                        this.m_projectToOpen = project = iterator.next();
                    }
                }
                catch (ConfigXmlException ce) {
                    FileStorageBP.handleCapDataNotFound(ce);
                    NodePM.getInstance().setUseCache(false);
                    monitor.done();
                }
            }
            finally {
                NodePM.getInstance().setUseCache(false);
                monitor.done();
            }
        }
    }

    private static class ReadFilesOperation
    implements IRunnableWithProgress {
        private Map<IProjectPO, INameMapper> m_projectToMapperMap;
        private Map<IProjectPO, IWritableComponentNameCache> m_projectToCompCacheMap;
        private List<URL> m_fileURLs;
        private IProgressConsole m_console;

        public ReadFilesOperation(List<URL> fileURLs, IProgressConsole console) {
            this.m_fileURLs = fileURLs;
            this.m_projectToMapperMap = new LinkedHashMap<IProjectPO, INameMapper>();
            this.m_projectToCompCacheMap = new LinkedHashMap<IProjectPO, IWritableComponentNameCache>();
            this.m_console = console;
        }

        /*
         * Unable to fully structure code
         */
        public void run(IProgressMonitor monitor) throws InterruptedException {
            if (this.m_fileURLs == null) {
                return;
            }
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ImportFileBPReading, (int)this.m_fileURLs.size());
            lastFileName = "";
            try {
                try {
                    FileStorageBP.access$0(this.m_console);
                    FileStorageBP.access$1(this.m_console);
                    for (URL fileURL : this.m_fileURLs) {
                        paramNameMapper = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
                        compNameCache = new ProjectCompNameCache(null);
                        lastFileName = fileName = fileURL.getFile();
                        this.m_console.writeStatus((IStatus)new Status(1, "org.eclipse.jubula.client.core", NLS.bind((String)Messages.ImportFileActionInfoStartingReadingProject, (Object)fileName)));
                        try {
                            proj = this.readProject(subMonitor, fileURL, paramNameMapper, (IWritableComponentNameCache)compNameCache, fileName);
                            if (proj == null) continue;
                            compNameCache.setContext((IPersistentObject)proj);
                            this.m_projectToMapperMap.put(proj, (INameMapper)paramNameMapper);
                            this.m_projectToCompCacheMap.put(proj, (IWritableComponentNameCache)compNameCache);
                            continue;
                        }
                        catch (JBVersionException e) {
                            ** for (msg : e.getErrorMsgs())
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.m_console.writeStatus((IStatus)new Status(4, "org.eclipse.jubula.client.core", (String)msg));
                            continue;
                        }
lbl27:
                        // 1 sources

                        this.m_console.writeStatus((IStatus)new Status(4, "org.eclipse.jubula.client.core", NLS.bind((String)Messages.ImportFileActionErrorImportFailed, (Object)fileName)));
                        continue;
                        catch (ToolkitPluginException e) {
                            this.m_console.writeStatus((IStatus)new Status(4, "org.eclipse.jubula.client.core", e.getMessage()));
                            FileStorageBP.access$2(e.getMessage());
                        }
                    }
                    FileStorageBP.access$3(this.m_console);
                }
                catch (PMReadException e) {
                    this.m_console.writeStatus((IStatus)new Status(4, "org.eclipse.jubula.client.core", NLS.bind((String)Messages.ImportFileActionErrorImportFailedProject, (Object)lastFileName, (Object)("\t" + Messages.InvalidImportFile))));
                    FileStorageBP.access$4(e, this.m_fileURLs);
                    monitor.done();
                }
                catch (ConfigXmlException ce) {
                    FileStorageBP.access$5(ce);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }

        private IProjectPO readProject(SubMonitor subMonitor, URL fileURL, ParamNameBPDecorator paramNameMapper, IWritableComponentNameCache compNameCache, String fileName) throws PMReadException, JBVersionException, InterruptedException, ToolkitPluginException {
            String fileExt = fileName.substring(fileName.lastIndexOf("."), fileName.length());
            IProjectPO proj = null;
            if (fileExt.equals(FileStorageBP.JUB)) {
                proj = new JsonStorage().readProject(fileURL, paramNameMapper, compNameCache, false, false, (IProgressMonitor)subMonitor.newChild(1), this.m_console);
            }
            return proj;
        }

        public Map<IProjectPO, INameMapper> getProjectToMapperMap() {
            return this.m_projectToMapperMap;
        }

        public Map<IProjectPO, IWritableComponentNameCache> getProjectToCompCacheMap() {
            return this.m_projectToCompCacheMap;
        }
    }
}

