/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.core.businessprocess.CompNameTypeManager;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.CompNamePopUpTextField;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewCAPDialog
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_4 = 4;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private static final int HORIZONTAL_SPAN = 3;
    private Text m_capNameField;
    private CompNamePopUpTextField m_componentNameField;
    private DirectCombo<String> m_componentCombo;
    private DirectCombo<String> m_actionCombo;
    private String m_capName;
    private String m_componentType;
    private String m_componentName;
    private String m_actionName;
    private Label m_actionLabel;
    private Label m_compNameLabel;
    private INodePO m_nodeGui;
    private final WidgetModifyListener m_modifyListener = new WidgetModifyListener();
    private IComponentNameCache m_compCache;

    public NewCAPDialog(Shell parentShell, INodePO nodeGui, IComponentNameCache compCache) {
        super(parentShell);
        this.m_nodeGui = nodeGui;
        this.m_compCache = compCache;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.NewCapDialogTitle);
        this.setMessage(Messages.NewCapDialogMessage);
        this.setTitleImage(IconConstants.NEW_CAP_DIALOG_IMAGE);
        this.getShell().setText(Messages.NewCAPDialogShellTitle);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        this.createFields(area);
        LayoutUtil.createSeparator((Composite)parent);
        String str = this.getNextChildrenName(this.m_nodeGui);
        this.m_capNameField.setText(str);
        this.m_capNameField.selectAll();
        this.m_capNameField.addModifyListener((ModifyListener)this.m_modifyListener);
        this.m_componentNameField.addModifyListener(this.m_modifyListener);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.capContextId");
        this.setHelpAvailable(true);
        return area;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        this.getButton(0).setEnabled(false);
        return button;
    }

    protected void okPressed() {
        this.m_capName = this.m_capNameField.getText();
        this.m_componentType = (String)this.m_componentCombo.getSelectedObject();
        this.m_componentName = this.m_componentNameField.getText();
        this.m_actionName = (String)this.m_actionCombo.getSelectedObject();
        this.setReturnCode(0);
        this.close();
    }

    public boolean close() {
        return super.close();
    }

    private void createFields(Composite area) {
        this.createCapNameField(area);
        this.createComponentCombo(area);
        this.createComponentName(area);
        this.createActionCombo(area);
    }

    private void createCapNameField(Composite area) {
        Label label = new Label(area, 0);
        label.setText(Messages.NewCAPDialogCapNameLabel);
        this.m_capNameField = new Text(area, 2052);
        GridData gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_capNameField);
        this.m_capNameField.setLayoutData((Object)gridData);
        LayoutUtil.setMaxChar((Text)this.m_capNameField);
    }

    private GridData newGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        return gridData;
    }

    private void createComponentCombo(Composite area) {
        String[] toolkitComponents;
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        Label label = new Label(area, 0);
        label.setText(Messages.NewCAPDialogComponentLabel);
        ArrayList<String> valueList = new ArrayList<String>();
        ArrayList<String> displayList = new ArrayList<String>();
        String[] stringArray = toolkitComponents = compSystem.getComponentTypes(GeneralStorage.getInstance().getProject().getToolkit());
        int n = toolkitComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String compType = stringArray[n2];
            if (compSystem.findComponent(compType).isVisible()) {
                valueList.add(compType);
                displayList.add(StringHelper.getInstance().get(compType, true));
            }
            ++n2;
        }
        this.m_componentCombo = new DirectCombo(area, 2060, valueList, displayList, true, true);
        GridData gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, this.m_componentCombo);
        this.m_componentCombo.setLayoutData((Object)gridData);
        this.m_componentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewCAPDialog.this.componentSelection();
            }
        });
    }

    private void createComponentName(Composite area) {
        this.m_compNameLabel = new Label(area, 0);
        this.m_compNameLabel.setText(Messages.NewCAPDialogComponentNameLabel);
        this.m_compNameLabel.setEnabled(false);
        this.m_componentNameField = new CompNamePopUpTextField(this.m_compCache, area, 2052);
        this.m_componentNameField.setEnabled(false);
        GridData gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_componentNameField);
        this.m_componentNameField.setLayoutData(gridData);
        LayoutUtil.setMaxChar((Text)this.m_componentNameField);
    }

    private void createActionCombo(Composite area) {
        this.m_actionLabel = new Label(area, 0);
        this.m_actionLabel.setText(Messages.NewCAPDialogActionLabel);
        this.m_actionLabel.setEnabled(false);
        this.m_actionCombo = new DirectCombo(area, 2060, new ArrayList(), new ArrayList(), false, false);
        this.m_actionCombo.setEnabled(false);
        GridData gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, this.m_actionCombo);
        this.m_actionCombo.setLayoutData((Object)gridData);
    }

    private void componentSelection() {
        ConcreteComponent cc;
        boolean defaultMappingComponent = false;
        String componentName = "";
        if (this.m_componentCombo.getSelectedObject() == null) {
            this.m_actionCombo.removeAll();
            return;
        }
        Map map = StringHelper.getInstance().getMap();
        Component component = ComponentBuilder.getInstance().getCompSystem().findComponent((String)this.m_componentCombo.getSelectedObject());
        if (component.isConcrete() && (cc = (ConcreteComponent)component).hasDefaultMapping()) {
            defaultMappingComponent = true;
        }
        ArrayList<Action> actions = new ArrayList<Action>(component.getActions().size());
        for (Object obj : component.getActions()) {
            Action action = (Action)obj;
            if (action.isDeprecated() || action.isApiAction()) continue;
            actions.add(action);
        }
        int actionSize = actions.size();
        Object[] actionNamesSorted = new String[actionSize];
        HashMap<Object, String> helpMap = new HashMap<Object, String>();
        int i = 0;
        while (i < actionSize) {
            Action action = (Action)actions.get(i);
            if (!action.isDeprecated()) {
                String actionName = action.getName();
                actionNamesSorted[i] = (String)map.get(actionName);
                helpMap.put(actionNamesSorted[i], actionName);
            }
            ++i;
        }
        Arrays.sort(actionNamesSorted);
        ArrayList<String> actionComboObjList = new ArrayList<String>();
        Object[] objectArray = actionNamesSorted;
        int n = actionNamesSorted.length;
        int n2 = 0;
        while (n2 < n) {
            Object actionName = objectArray[n2];
            actionComboObjList.add((String)helpMap.get(actionName));
            ++n2;
        }
        this.m_actionCombo.setItems(actionComboObjList, Arrays.asList(actionNamesSorted));
        this.m_componentNameField.setText(componentName);
        this.m_compNameLabel.setEnabled(!defaultMappingComponent);
        this.m_componentNameField.setEnabled(!defaultMappingComponent);
        this.m_actionLabel.setEnabled(true);
        this.m_actionCombo.setEnabled(true);
        this.modifyComponentTypeAction();
        this.modifyComponentNameFieldAction();
    }

    private boolean modifyCapNameFieldAction(boolean compNamesAreAlreadyCorrect) {
        boolean isCorrect = true;
        int capNameLength = this.m_capNameField.getText().length();
        if (capNameLength == 0 || this.m_capNameField.getText().startsWith(" ") || this.m_capNameField.getText().charAt(capNameLength - 1) == ' ') {
            isCorrect = false;
        }
        if (isCorrect) {
            if (!compNamesAreAlreadyCorrect) {
                this.modifyComponentTypeAction();
            } else {
                this.enableOKButton();
            }
        } else {
            this.getButton(0).setEnabled(false);
            if (capNameLength == 0) {
                this.setErrorMessage(Messages.NewCAPDialogEmptyStep);
            } else {
                this.setErrorMessage(Messages.NewCAPDialogNotValidStep);
            }
        }
        return isCorrect;
    }

    private boolean modifyComponentTypeAction() {
        boolean isCorrect = true;
        if (this.m_componentCombo.getText().length() == 0) {
            isCorrect = false;
        }
        if (isCorrect) {
            this.m_componentNameField.setFilter((String)this.m_componentCombo.getSelectedObject());
            this.modifyComponentNameFieldAction();
        } else {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
            this.setErrorMessage(Messages.NewCAPDialogEmptyCompType);
        }
        return isCorrect;
    }

    private boolean modifyComponentNameFieldAction() {
        boolean isCorrect = true;
        boolean defaultName = false;
        int componentNameLength = this.m_componentNameField.getText().length();
        if (componentNameLength == 0 || this.m_componentNameField.getText().startsWith(" ") || this.m_componentNameField.getText().charAt(componentNameLength - 1) == ' ') {
            isCorrect = false;
        }
        if (!this.m_componentNameField.isEnabled()) {
            defaultName = true;
            isCorrect = true;
        }
        String guid = this.m_compCache.getGuidForName(this.m_componentNameField.getText());
        IComponentNamePO cN = null;
        String type = null;
        if (guid != null) {
            cN = this.m_compCache.getResCompNamePOByGuid(guid);
            type = cN.getComponentType();
        }
        if (cN != null && !"guidancer.abstract.Unknown".equals(type) && !CompNameTypeManager.mayBeCompatible((IComponentNamePO)cN, (String)((String)this.m_componentCombo.getSelectedObject()))) {
            this.enableOKButton();
            this.setErrorMessage("Using this Component Name has a chance of causing type errors.");
            return true;
        }
        if (isCorrect) {
            this.modifyCapNameFieldAction(true);
            return isCorrect;
        }
        this.getButton(0).setEnabled(false);
        if (componentNameLength == 0 && !defaultName) {
            this.setErrorMessage(Messages.NewCAPDialogEmptyCompName);
        } else if (defaultName) {
            this.setErrorMessage(NLS.bind((String)Messages.NewCAPDialogReservedCompName, (Object)this.m_componentNameField.getText()));
        } else {
            this.setErrorMessage(Messages.NewCAPDialogNotValidCompName);
        }
        if (isCorrect) {
            this.modifyCapNameFieldAction(true);
        }
        return isCorrect;
    }

    private void enableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
        this.setErrorMessage(null);
    }

    public String getCapName() {
        return this.m_capName;
    }

    public String getComponentType() {
        return this.m_componentType;
    }

    public String getActionName() {
        return this.m_actionName;
    }

    public String getComponentName() {
        return this.m_componentName;
    }

    private String getNextChildrenName(INodePO parent) {
        String capName = "";
        int index = parent.getNodeListSize() + 1;
        boolean uniqueName = false;
        block0: while (!uniqueName) {
            capName = "new Test Step" + index;
            uniqueName = true;
            for (INodePO node : parent.getUnmodifiableNodeList()) {
                if (!node.getName().equals(capName)) continue;
                uniqueName = false;
                ++index;
                continue block0;
            }
        }
        return capName;
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object o = e.getSource();
            if (o.equals(NewCAPDialog.this.m_capNameField)) {
                NewCAPDialog.this.modifyCapNameFieldAction(false);
                return;
            }
            if (o.equals((Object)NewCAPDialog.this.m_componentNameField)) {
                NewCAPDialog.this.modifyComponentNameFieldAction();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + "(" + o + ")" + "."));
        }
    }
}

