/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.layout.Pane;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITextComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.adapter.JavaFXComponentAdapter;
import org.eclipse.jubula.rc.javafx.tester.util.AbstractTraverser;
import org.eclipse.jubula.rc.javafx.tester.util.GenericTraverseHelper;
import org.eclipse.jubula.rc.javafx.tester.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.tester.util.NodeTraverseHelper;
import org.eclipse.jubula.rc.javafx.tester.util.Rounding;
import org.eclipse.jubula.rc.javafx.tester.util.compatibility.TableUtils;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.StringParsing;

public class TableAdapter
extends JavaFXComponentAdapter<TableView<?>>
implements ITableComponent<TableCell<?, ?>> {
    private List<TableColumn> m_columns = new ArrayList<TableColumn>();

    public TableAdapter(TableView<?> objectToAdapt) {
        super(objectToAdapt);
    }

    public String getText() {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                ObservableList sCells = ((TableView)TableAdapter.this.getRealComponent()).getSelectionModel().getSelectedCells();
                if (!sCells.isEmpty()) {
                    TablePosition pos = (TablePosition)sCells.get(0);
                    return TableAdapter.this.getCellText(pos.getRow(), pos.getColumn());
                }
                throw new StepExecutionException("No selection found", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
            }
        });
        return result;
    }

    public int getColumnCount() {
        int result = EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnCount", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int counter = 0;
                for (TableColumn column : ((TableView)TableAdapter.this.getRealComponent()).getColumns()) {
                    counter += new GenericTraverseHelper<TableColumn, TableColumn>().getInstancesOf(new AbstractTraverser<TableColumn, TableColumn>(column){

                        @Override
                        public Iterable<TableColumn> getTraversableData() {
                            return ((TableColumn)this.getObject()).getColumns();
                        }
                    }, TableColumn.class).size();
                }
                return counter + ((TableView)TableAdapter.this.getRealComponent()).getColumns().size();
            }
        });
        return result;
    }

    public int getRowCount() {
        int result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRowCount", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((TableView)TableAdapter.this.getRealComponent()).getItems().size();
            }
        });
        return result;
    }

    public String getCellText(final int row, final int column) {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getCellText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                TableColumn col = null;
                col = TableAdapter.this.m_columns.size() == 0 ? table.getVisibleLeafColumn(column) : (TableColumn)TableAdapter.this.m_columns.get(column);
                table.scrollTo(row);
                table.scrollToColumn(col);
                table.layout();
                List<TableCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)table, TableCell.class);
                for (TableCell cell : tCells) {
                    IComponent adapter;
                    if (cell.getIndex() != row || cell.getTableColumn() != col || cell.getTableView() != table || !NodeTraverseHelper.isVisible((Node)cell) || (adapter = (IComponent)AdapterFactoryRegistry.getInstance().getAdapter(IComponent.class, (Object)cell)) == null || !(adapter instanceof ITextComponent)) continue;
                    return ((ITextComponent)adapter).getText();
                }
                return null;
            }
        });
        return result;
    }

    public String getColumnHeaderText(final int column) {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnHeaderText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (TableAdapter.this.m_columns.size() > 0) {
                    TableColumn tCol = (TableColumn)TableAdapter.this.m_columns.get(column);
                    return tCol.getText();
                }
                TableColumn tCol = ((TableView)TableAdapter.this.getRealComponent()).getVisibleLeafColumn(column);
                return tCol.getText();
            }
        });
        return result;
    }

    public int getColumnFromString(final String colPath, final String op) {
        Integer result = EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnFromString", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                List path;
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                TableColumn column = TableAdapter.this.determineColumn(colPath, op, table, path = StringParsing.splitToList((String)colPath, (char)'/', (char)'\\', (boolean)false));
                if (column == null) {
                    return -2;
                }
                if (table.getVisibleLeafColumns().contains((Object)column)) {
                    return table.getVisibleLeafColumns().indexOf((Object)column);
                }
                TableAdapter.this.m_columns.add(column);
                return TableAdapter.this.m_columns.indexOf(column);
            }
        });
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TableColumn<?, ?> determineColumn(String colPath, String op, TableView table, List<String> path) {
        columns = colPath.contains("/") != false ? table.getColumns() : table.getVisibleLeafColumns();
        pathIterator = path.iterator();
        currCol = null;
        column = null;
        block6: while (pathIterator.hasNext()) {
            try {
                block16: {
                    currCol = pathIterator.next();
                    usrIdxCol = Integer.parseInt(currCol);
                    if (usrIdxCol == 0) {
                        ++usrIdxCol;
                    }
                    i = IndexConverter.toImplementationIndex((int)usrIdxCol);
                    if (MatchUtil.NOT_EQUALS != op) break block16;
                    j = 0;
                    if (true) ** GOTO lbl31
                }
                try {
                    if (pathIterator.hasNext()) {
                        columns = ((TableColumn)columns.get(i)).getColumns();
                        continue;
                    }
                    column = (TableColumn)columns.get(i);
                }
                catch (IndexOutOfBoundsException v0) {
                    return null;
                    do {
                        if (j != i) {
                            if (pathIterator.hasNext()) {
                                columns = ((TableColumn)columns.get(j)).getColumns();
                            } else {
                                column = (TableColumn)columns.get(j);
                            }
                        }
                        ++j;
lbl31:
                        // 2 sources

                    } while (j < columns.size());
                }
            }
            catch (NumberFormatException v1) {
                try {
                    if (path.size() <= 1) {
                        columns = table.getColumns();
                    }
                    if (columns.size() <= 0) {
                        throw new StepExecutionException("No Columns", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                    }
                    for (TableColumn c : columns) {
                        h = c.getText();
                        if (!MatchUtil.getInstance().match(h, currCol, op)) continue;
                        column = c;
                        if (!pathIterator.hasNext()) continue block6;
                        columns = c.getColumns();
                        continue block6;
                    }
                    return null;
                }
                catch (IllegalArgumentException v2) {}
            }
        }
        return column;
    }

    public String getRowText(int row) {
        return null;
    }

    public int getRowFromString(final String row, final String operator) {
        Integer result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRowFromString", new Callable<Integer>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public Integer call() throws Exception {
                block6: {
                    rowInt = null;
                    table = (TableView)TableAdapter.this.getRealComponent();
                    try {
                        rowInt = IndexConverter.toImplementationIndex((int)Integer.parseInt(row));
                        if (rowInt == -1 && table.getColumns().size() <= 0) {
                            throw new StepExecutionException("No Header", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                        }
                        break block6;
                    }
                    catch (NumberFormatException v0) {
                        i = 0;
                        ** while (i < table.getItems().size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        cellTxt = TableAdapter.this.getCellText(i, 0);
                        if (MatchUtil.getInstance().match(cellTxt, row, operator)) {
                            return new Integer(i);
                        }
                        ++i;
                        continue;
                    }
                }
                if (rowInt == null) {
                    throw new StepExecutionException("Row not found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                }
                return rowInt;
            }
        });
        return result;
    }

    public Rectangle getHeaderBounds(final int column) {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("getHeaderBounds", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                TableColumn col = TableAdapter.this.m_columns.size() > 0 ? (TableColumn)TableAdapter.this.m_columns.get(column) : ((TableView)TableAdapter.this.getRealComponent()).getVisibleLeafColumn(column);
                table.scrollToColumn(col);
                return TableUtils.getNodeBoundsofHeader((Parent)table, col, true);
            }
        });
        return result;
    }

    public Cell getSelectedCell() throws StepExecutionException {
        Cell result = EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedCell", new Callable<Cell>(){

            @Override
            public Cell call() throws StepExecutionException {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                ObservableList list = table.getSelectionModel().getSelectedCells();
                if (list.size() > 0) {
                    TablePosition pos = null;
                    for (Object object : list) {
                        TablePosition curr = (TablePosition)object;
                        if (curr.getRow() != table.getSelectionModel().getSelectedIndex()) continue;
                        pos = curr;
                        break;
                    }
                    if (pos != null) {
                        return new Cell(pos.getRow(), pos.getColumn());
                    }
                }
                throw new StepExecutionException("No selection found", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
            }
        });
        return result;
    }

    public boolean isHeaderVisible() {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isHeaderVisible", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Pane header = (Pane)((TableView)TableAdapter.this.getRealComponent()).lookup("TableHeaderRow");
                if (header != null) {
                    return header.isVisible();
                }
                return false;
            }
        });
        return result;
    }

    public boolean isCellEditable(final int row, final int column) {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isCellEditable", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                if (table.isEditable()) {
                    TableColumn col = null;
                    col = TableAdapter.this.m_columns.size() == 0 ? table.getVisibleLeafColumn(column) : (TableColumn)TableAdapter.this.m_columns.get(column);
                    if (col.isEditable()) {
                        table.scrollTo(row);
                        table.scrollToColumn(col);
                        table.layout();
                        List<TableCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)table, TableCell.class);
                        for (TableCell cell : tCells) {
                            if (cell.getIndex() != row || cell.getTableColumn() != col || cell.getTableView() != table || !NodeTraverseHelper.isVisible((Node)cell)) continue;
                            return cell.isEditable();
                        }
                    }
                }
                return false;
            }
        });
        return result;
    }

    public boolean hasCellSelection() {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("hasCellSelection", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                if (table.getSelectionModel().getSelectedCells().size() > 0) {
                    return true;
                }
                return false;
            }
        });
        return result;
    }

    public Rectangle scrollCellToVisible(final int row, final int column) throws StepExecutionException {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("scrollCellToVisible", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TableView table = (TableView)TableAdapter.this.getRealComponent();
                TableColumn col = null;
                col = TableAdapter.this.m_columns.size() == 0 ? table.getVisibleLeafColumn(column) : (TableColumn)TableAdapter.this.m_columns.get(column);
                table.scrollTo(row);
                table.scrollToColumn(col);
                table.layout();
                List<TableCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)table, TableCell.class);
                for (TableCell cell : tCells) {
                    if (cell.getIndex() != row || cell.getTableColumn() != col || cell.getTableView() != table) continue;
                    Rectangle b = NodeBounds.getAbsoluteBounds((Node)cell);
                    Rectangle tableB = NodeBounds.getAbsoluteBounds((Node)table);
                    return new Rectangle(Math.abs(tableB.x - b.x), Math.abs(tableB.y - b.y), Rounding.round(b.getWidth()), Rounding.round(b.getHeight()));
                }
                return null;
            }
        });
        return result;
    }

    public Object getTableHeader() {
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getTableHeader", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((TableView)TableAdapter.this.getRealComponent()).lookup("TableHeaderRow");
            }
        });
        return result;
    }

    public String getPropertyValueOfCell(final String name, final TableCell<?, ?> cell) {
        String prop = EventThreadQueuerJavaFXImpl.invokeAndWait("getProperty", new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    IComponent adapter = (IComponent)AdapterFactoryRegistry.getInstance().getAdapter(IComponent.class, (Object)cell);
                    if (adapter != null && adapter instanceof ITextComponent) {
                        return ((ITextComponent)adapter).getPropteryValue(name);
                    }
                    return null;
                }
                catch (RobotException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
            }
        });
        return String.valueOf(prop);
    }

    public boolean doesRowExist(int row) {
        return row >= 0 && row < this.getRowCount();
    }

    public int getTopIndex() {
        throw new UnsupportedOperationException("JavaFX table adapter does not implement getTopIndex.");
    }

    public Rectangle getCellBounds(int row, int col, boolean restr) {
        throw new UnsupportedOperationException("JavaFX table adapter does not implement getCellBounds.");
    }
}

