/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql;

import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.oql.compiler.CompilerImpl;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.parser.internal.oql.compiler.Query;
import org.eclipse.mat.parser.internal.oql.parser.OQLParser;
import org.eclipse.mat.parser.internal.oql.parser.ParseException;
import org.eclipse.mat.parser.internal.oql.parser.TokenMgrError;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.OQLParseException;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.PatternUtil;
import org.eclipse.mat.util.SimpleMonitor;
import org.eclipse.mat.util.VoidProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQLQueryImpl
implements IOQLQuery {
    Query query;
    EvaluationContext ctx;

    private static Column buildColumn(Query.SelectItem column, Object columnValue) {
        String name = column.getName();
        if (name == null) {
            name = column.getExpression().toString();
        }
        Class type = columnValue != null ? columnValue.getClass() : Object.class;
        return new Column(name, type).noTotals();
    }

    public OQLQueryImpl(EvaluationContext parent, Query query) {
        this.init(parent, query);
    }

    public OQLQueryImpl(String queryString) throws OQLParseException {
        try {
            OQLParser p = new OQLParser(new StringReader(queryString));
            p.setCompiler(new CompilerImpl());
            Query query = p.ParseQuery();
            this.init(null, query);
        }
        catch (ParseException e) {
            int line = e.currentToken.next.beginLine;
            int column = e.currentToken.next.beginColumn;
            throw new OQLParseException(e.getMessage(), null, line, column);
        }
        catch (TokenMgrError e) {
            String msg = e.getMessage();
            int line = 1;
            int column = 1;
            Pattern pattern = Pattern.compile("Lexical error at line ([0-9]*), column ([0-9]*)\\..*");
            Matcher matcher = pattern.matcher(msg);
            if (matcher.matches()) {
                line = Integer.parseInt(matcher.group(1));
                column = Integer.parseInt(matcher.group(2));
            }
            throw new OQLParseException(msg, null, line, column);
        }
    }

    private void init(EvaluationContext parent, Query query) {
        this.query = query;
        this.ctx = new EvaluationContext(parent);
        if (query.getFromClause() != null) {
            this.ctx.setAlias(query.getFromClause().getAlias());
        }
    }

    private void initSnapshot(ISnapshot snapshot) {
        this.ctx.setSnapshot(snapshot);
    }

    public Object execute(ISnapshot snapshot, IProgressListener monitor) throws SnapshotException {
        Object result;
        if (snapshot == null) {
            throw new NullPointerException(Messages.OQLQueryImpl_Error_MissingSnapshot);
        }
        this.initSnapshot(snapshot);
        if (monitor == null) {
            monitor = new VoidProgressListener();
        }
        return (result = this.internalExecute(monitor)) instanceof IntResult ? (Object)((IntResult)result).toArray() : result;
    }

    protected Object internalExecute(IProgressListener monitor) throws SnapshotException {
        int[] percentages = new int[1 + (this.query.getUnionQueries() != null ? this.query.getUnionQueries().size() : 0)];
        Arrays.fill(percentages, 100);
        SimpleMonitor listener = new SimpleMonitor(this.query.toString(), monitor, percentages);
        Object result = null;
        result = this.query.getFromClause().getSubSelect() != null ? this.doSubQuery(listener.nextMonitor()) : (this.query.getFromClause().getCall() != null ? this.doMethodCall(listener.nextMonitor()) : this.doFromItem(listener.nextMonitor()));
        if (this.query.getUnionQueries() != null) {
            result = this.union(listener, result);
        }
        return result;
    }

    private Object union(SimpleMonitor monitor, Object result) throws SnapshotException, OQLParseException {
        UnionResultSet unionResultSet = null;
        IntArrayResult unionIntResult = null;
        if (result instanceof CustomTableResultSet) {
            unionResultSet = new UnionResultSet();
            unionResultSet.addResultSet((CustomTableResultSet)result);
        } else if (result instanceof IntResult) {
            IntResult intResult = (IntResult)result;
            unionIntResult = new IntArrayResult(intResult.size());
            unionIntResult.addAll(intResult);
        }
        for (Query q : this.query.getUnionQueries()) {
            OQLQueryImpl unionQuery;
            Object unionResult;
            if (this.query.getSelectClause().getSelectList().isEmpty() || this.query.getSelectClause().isAsObjects()) {
                if (!q.getSelectClause().getSelectList().isEmpty() && !q.getSelectClause().isAsObjects()) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_QueryMustReturnObjects, (Object[])new Object[]{q}));
                }
            } else if (q.getSelectClause().getSelectList().size() != this.query.getSelectClause().getSelectList().size()) {
                throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_QueryMustHaveIdenticalSelectItems, (Object[])new Object[]{q}));
            }
            if ((unionResult = (unionQuery = new OQLQueryImpl(this.ctx, q)).internalExecute(monitor.nextMonitor())) == null) continue;
            if (unionResultSet != null) {
                unionResultSet.addResultSet((CustomTableResultSet)unionResult);
                continue;
            }
            if (unionIntResult != null) {
                unionIntResult.addAll((IntResult)unionResult);
                continue;
            }
            if (this.query.getSelectClause().getSelectList().isEmpty() || this.query.getSelectClause().isAsObjects()) {
                unionIntResult = new IntArrayResult(0);
                unionIntResult.addAll((IntResult)unionResult);
                continue;
            }
            unionResultSet = new UnionResultSet();
            unionResultSet.addResultSet((CustomTableResultSet)unionResult);
        }
        return unionResultSet != null ? unionResultSet : unionIntResult;
    }

    private Object doSubQuery(IProgressListener monitor) throws SnapshotException {
        OQLQueryImpl subQuery = new OQLQueryImpl(this.ctx, this.query.getFromClause().getSubSelect());
        Object result = subQuery.internalExecute(monitor);
        if (!(result instanceof IntResult)) {
            throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_MustReturnObjectList, (Object[])new Object[]{this.query.getFromClause().getSubSelect()}));
        }
        IntResult baseSet = (IntResult)result;
        if (this.query.getFromClause().includeObjects() && !this.query.getFromClause().includeSubClasses()) {
            return this.filterAndSelect(baseSet, monitor);
        }
        try {
            ArrayList<IClass> classes = new ArrayList<IClass>(baseSet.size());
            IntIterator iter = baseSet.iterator();
            while (iter.hasNext()) {
                int id = iter.nextInt();
                IClass subjectClass = (IClass)this.ctx.getSnapshot().getObject(id);
                classes.add(subjectClass);
                if (!this.query.getFromClause().includeSubClasses()) continue;
                classes.addAll(subjectClass.getAllSubclasses());
            }
            return this.filterClasses(monitor, classes);
        }
        catch (ClassCastException e) {
            throw new SnapshotException(Messages.OQLQueryImpl_Error_ClassCastExceptionOccured, (Throwable)e);
        }
    }

    private Object doFromItem(IProgressListener listener) throws SnapshotException {
        Collection<IClass> classes = null;
        if (this.query.getFromClause().getClassName() != null) {
            classes = this.ctx.getSnapshot().getClassesByName(this.query.getFromClause().getClassName(), this.query.getFromClause().includeSubClasses());
        } else {
            if (this.query.getFromClause().getClassNamePattern() != null) {
                try {
                    Pattern pattern = Pattern.compile(PatternUtil.smartFix((String)this.query.getFromClause().getClassNamePattern(), (boolean)false));
                    classes = this.ctx.getSnapshot().getClassesByName(pattern, this.query.getFromClause().includeSubClasses());
                }
                catch (PatternSyntaxException e) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_InvalidClassNamePattern, (Object[])new Object[]{this.query.getFromClause().getClassNamePattern()}), (Throwable)e);
                }
            }
            if (this.query.getFromClause().getObjectIds() != null) {
                if (this.query.getFromClause().includeObjects() && !this.query.getFromClause().includeSubClasses()) {
                    return this.filterAndSelect(new IntArrayResult(this.query.getFromClause().getObjectIds().toArray()), listener);
                }
                classes = new ArrayList();
                IteratorInt ee = this.query.getFromClause().getObjectIds().iterator();
                while (ee.hasNext()) {
                    IObject subject = this.ctx.getSnapshot().getObject(ee.next());
                    if (subject instanceof IClass) {
                        IClass subjectClass = (IClass)subject;
                        classes.add(subjectClass);
                        if (!this.query.getFromClause().includeSubClasses()) continue;
                        classes.addAll(subjectClass.getAllSubclasses());
                        continue;
                    }
                    throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Errot_IsNotClass, (Object[])new Object[]{Long.toHexString(subject.getObjectAddress())}));
                }
            } else if (this.query.getFromClause().getObjectAddresses() != null) {
                ArrayLong objectAddresses = this.query.getFromClause().getObjectAddresses();
                IntArrayResult result = new IntArrayResult(objectAddresses.size());
                IteratorLong ee = objectAddresses.iterator();
                while (ee.hasNext()) {
                    result.add(this.ctx.getSnapshot().mapAddressToId(ee.next()));
                }
                if (this.query.getFromClause().includeObjects() && !this.query.getFromClause().includeSubClasses()) {
                    return this.filterAndSelect(result, listener);
                }
                classes = new ArrayList();
                IntIterator iter = result.iterator();
                while (iter.hasNext()) {
                    IObject subject = this.ctx.getSnapshot().getObject(iter.nextInt());
                    if (subject instanceof IClass) {
                        IClass subjectClass = (IClass)subject;
                        classes.add(subjectClass);
                        if (!this.query.getFromClause().includeSubClasses()) continue;
                        classes.addAll(subjectClass.getAllSubclasses());
                        continue;
                    }
                    throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Errot_IsNotClass, (Object[])new Object[]{Long.toHexString(subject.getObjectAddress())}));
                }
            }
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        if (classes == null || classes.isEmpty()) {
            return null;
        }
        return this.filterClasses(listener, classes);
    }

    private Object doMethodCall(IProgressListener listener) throws SnapshotException {
        ArrayList<IClass> classes;
        block30: {
            Object result;
            block29: {
                Expression method = this.query.getFromClause().getCall();
                this.ctx.setSubject(this.ctx.getSnapshot());
                result = method.compute(this.ctx);
                if (this.query.getFromClause().includeObjects() && !this.query.getFromClause().includeSubClasses()) {
                    if (result == null) {
                        return null;
                    }
                    if (result instanceof Iterable) {
                        ArrayList<Object> r = new ArrayList<Object>();
                        for (Object obj : (Iterable)result) {
                            if (!this.accept(obj)) continue;
                            r.add(obj);
                        }
                        return r.isEmpty() ? null : this.select(r, listener);
                    }
                    if (result.getClass().isArray()) {
                        ArrayList<Object> r = new ArrayList<Object>();
                        int length = Array.getLength(result);
                        int ii = 0;
                        while (ii < length) {
                            Object obj = Array.get(result, ii);
                            if (this.accept(obj)) {
                                r.add(obj);
                            }
                            ++ii;
                        }
                        return r.isEmpty() ? null : this.select(r, listener);
                    }
                    return this.accept(result) ? this.select(result, listener) : null;
                }
                classes = new ArrayList<IClass>();
                if (result != null) break block29;
                return null;
            }
            try {
                if (result instanceof Iterable) {
                    for (Object obj : (Iterable)result) {
                        if (obj == null) continue;
                        if (obj instanceof Integer) {
                            IClass subjectClass = (IClass)this.ctx.getSnapshot().getObject(((Integer)obj).intValue());
                            classes.add(subjectClass);
                            if (!this.query.getFromClause().includeSubClasses()) continue;
                            classes.addAll(subjectClass.getAllSubclasses());
                            continue;
                        }
                        if (obj instanceof int[]) {
                            int[] nArray = (int[])obj;
                            int n = nArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int id = nArray[n2];
                                IClass subjectClass = (IClass)this.ctx.getSnapshot().getObject(id);
                                classes.add(subjectClass);
                                if (this.query.getFromClause().includeSubClasses()) {
                                    classes.addAll(subjectClass.getAllSubclasses());
                                }
                                ++n2;
                            }
                            continue;
                        }
                        IClass subjectClass = (IClass)obj;
                        classes.add(subjectClass);
                        if (!this.query.getFromClause().includeSubClasses()) continue;
                        classes.addAll(subjectClass.getAllSubclasses());
                    }
                    break block30;
                }
                if (result.getClass().isArray()) {
                    int length = Array.getLength(result);
                    int ii = 0;
                    while (ii < length) {
                        Object obj = Array.get(result, ii);
                        if (obj != null) {
                            if (obj instanceof Integer) {
                                IClass subjectClass = (IClass)this.ctx.getSnapshot().getObject(((Integer)obj).intValue());
                                classes.add(subjectClass);
                                if (this.query.getFromClause().includeSubClasses()) {
                                    classes.addAll(subjectClass.getAllSubclasses());
                                }
                            } else if (obj instanceof int[]) {
                                int[] nArray = (int[])obj;
                                int n = nArray.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    int id = nArray[n3];
                                    IClass subjectClass = (IClass)this.ctx.getSnapshot().getObject(id);
                                    classes.add(subjectClass);
                                    if (this.query.getFromClause().includeSubClasses()) {
                                        classes.addAll(subjectClass.getAllSubclasses());
                                    }
                                    ++n3;
                                }
                            } else {
                                IClass subjectClass = (IClass)obj;
                                classes.add(subjectClass);
                                if (this.query.getFromClause().includeSubClasses()) {
                                    classes.addAll(subjectClass.getAllSubclasses());
                                }
                            }
                        }
                        ++ii;
                    }
                } else {
                    IClass subjectClass = (IClass)result;
                    classes.add(subjectClass);
                    if (this.query.getFromClause().includeSubClasses()) {
                        classes.addAll(subjectClass.getAllSubclasses());
                    }
                }
            }
            catch (ClassCastException e) {
                throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_ElementIsNotClass, (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        return this.filterClasses(listener, classes);
    }

    private Object filterClasses(IProgressListener listener, Collection<IClass> classes) throws SnapshotException {
        if (this.query.getFromClause().includeObjects()) {
            listener.beginTask(Messages.OQLQueryImpl_SelectingObjects, classes.size());
            IntResult filteredSet = this.createIntResult(classes.size());
            for (IClass clasz : classes) {
                if (this.accept(clasz.getObjectId())) {
                    filteredSet.add(clasz.getObjectId());
                }
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                listener.worked(1);
            }
            return filteredSet.isEmpty() ? null : this.select(filteredSet, listener);
        }
        listener.beginTask(Messages.OQLQueryImpl_CollectingObjects, classes.size());
        IntResult filteredSet = this.createIntResult(classes.size() * 100);
        for (IClass clasz : classes) {
            int[] ids;
            listener.subTask(MessageUtil.format((String)Messages.OQLQueryImpl_CheckingClass, (Object[])new Object[]{clasz.getName()}));
            int[] nArray = ids = clasz.getObjectIds();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                if (this.accept(id)) {
                    filteredSet.add(id);
                }
                ++n2;
            }
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
        }
        return filteredSet.isEmpty() ? null : this.select(filteredSet, listener);
    }

    private boolean accept(int objectId) throws SnapshotException {
        if (this.query.getWhereClause() == null) {
            return true;
        }
        return this.accept(this.ctx.getSnapshot().getObject(objectId));
    }

    private boolean accept(Object object) throws SnapshotException {
        if (this.query.getWhereClause() == null) {
            return true;
        }
        this.ctx.setSubject(object);
        Boolean result = (Boolean)this.query.getWhereClause().compute(this.ctx);
        return result == null ? false : result;
    }

    private Object filterAndSelect(IntResult objectIds, IProgressListener listener) throws SnapshotException {
        IntResult filteredSet = this.createIntResult(objectIds.size());
        IntIterator iter = objectIds.iterator();
        while (iter.hasNext()) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            int id = iter.nextInt();
            if (!this.accept(id)) continue;
            filteredSet.add(id);
        }
        return filteredSet.isEmpty() ? null : this.select(filteredSet, listener);
    }

    private Object select(IntResult objectIds, IProgressListener listener) throws SnapshotException {
        Query.SelectClause select = this.query.getSelectClause();
        if (select.isRetainedSet()) {
            objectIds = new IntArrayResult(this.ctx.getSnapshot().getRetainedSet(objectIds.toArray(), listener));
        }
        if (select.getSelectList().isEmpty()) {
            return objectIds;
        }
        if (select.isAsObjects()) {
            ResultSet temp = new ResultSet(this.getSelectQuery(), objectIds.toArray());
            IntResult r = this.createIntResult(objectIds.size());
            this.convertToObjects(temp, r, listener);
            return r;
        }
        return new ResultSet(this.getSelectQuery(), objectIds.toArray());
    }

    private Object select(List<Object> objects, IProgressListener listener) throws SnapshotException {
        Query.SelectClause select = this.query.getSelectClause();
        if (select.isRetainedSet()) {
            return this.select(this.convertToObjectIds(objects), listener);
        }
        if (select.getSelectList().isEmpty()) {
            return objects;
        }
        if (select.isAsObjects()) {
            ObjectResultSet temp = new ObjectResultSet(this.getSelectQuery(), objects);
            IntResult r = this.createIntResult(temp.getRowCount());
            this.convertToObjects(temp, r, listener);
            return r;
        }
        return new ObjectResultSet(this.getSelectQuery(), objects);
    }

    private Object select(Object object, IProgressListener listener) throws SnapshotException {
        Query.SelectClause select = this.query.getSelectClause();
        if (select.isRetainedSet()) {
            return this.select(this.convertToObjectIds(Arrays.asList(object)), listener);
        }
        if (select.getSelectList().isEmpty()) {
            return object;
        }
        if (select.isAsObjects()) {
            ObjectResultSet temp = new ObjectResultSet(this.getSelectQuery(), Arrays.asList(object));
            IntResult r = this.createIntResult(temp.getRowCount());
            this.convertToObjects(temp, r, listener);
            return r;
        }
        return new ObjectResultSet(this.getSelectQuery(), Arrays.asList(object));
    }

    private OQLQueryImpl getSelectQuery() {
        Query q2 = new Query();
        q2.setSelectClause(this.query.getSelectClause());
        q2.setFromClause(this.query.getFromClause());
        q2.setWhereClause(this.query.getWhereClause());
        OQLQueryImpl qi = new OQLQueryImpl(this.ctx, q2);
        return qi;
    }

    private IntArrayResult convertToObjectIds(List<?> objects) throws SnapshotException {
        ArrayInt a = new ArrayInt();
        for (Object object : objects) {
            if (object == null) continue;
            if (object instanceof Integer) {
                a.add(((Integer)object).intValue());
                continue;
            }
            if (object instanceof IObject) {
                a.add(((IObject)object).getObjectId());
                continue;
            }
            if (object instanceof int[]) {
                a.addAll((int[])object);
                continue;
            }
            throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_CannotCalculateRetainedSet, (Object[])new Object[]{object}));
        }
        return new IntArrayResult(a);
    }

    private void convertToObjects(CustomTableResultSet set, IntResult resultSet, IProgressListener listener) throws SnapshotException {
        if (set.getColumns().length != 1) {
            throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_QueryCannotBeConverted, (Object[])new Object[]{set.getOQLQuery()}));
        }
        int count = set.getRowCount();
        int ii = 0;
        while (ii < count) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            Object rowObject = set.getColumnValue(set.getRow(ii), 0);
            Collection<Object> it = rowObject instanceof Iterable ? (Set<Object>)rowObject : (rowObject instanceof Object[] ? Arrays.asList((Object[])rowObject) : Collections.singleton(rowObject));
            for (Object t : it) {
                long addr;
                if (t == null) continue;
                if (t instanceof Integer) {
                    resultSet.add((Integer)t);
                    continue;
                }
                if (t instanceof int[]) {
                    resultSet.addAll((int[])t);
                    continue;
                }
                if (t instanceof IObject) {
                    resultSet.add(((IObject)t).getObjectId());
                    continue;
                }
                if (t instanceof Long) {
                    addr = (Long)t;
                    if (addr == 0L) continue;
                    int id = this.ctx.getSnapshot().mapAddressToId(addr);
                    resultSet.add(id);
                    continue;
                }
                if (t instanceof long[]) {
                    long[] lArray = (long[])t;
                    int n = lArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        addr = lArray[n2];
                        if (addr != 0L) {
                            int id = this.ctx.getSnapshot().mapAddressToId(addr);
                            resultSet.add(id);
                        }
                        ++n2;
                    }
                    continue;
                }
                throw new SnapshotException(MessageUtil.format((String)Messages.OQLQueryImpl_Error_ResultMustReturnObjectList, (Object[])new Object[]{set.getOQLQuery(), String.valueOf(rowObject)}));
            }
            ++ii;
        }
    }

    private IntResult createIntResult(int capacity) {
        return this.query.getSelectClause().isDistinct() || this.query.getSelectClause().isRetainedSet() ? new IntSetResult(capacity) : new IntArrayResult(capacity);
    }

    public String toString() {
        return this.query.toString();
    }

    private static interface CustomTableResultSet
    extends IOQLQuery.Result,
    IResultTable {
    }

    private static class IntArrayResult
    implements IntResult {
        ArrayInt arrayInt;

        public IntArrayResult(int capacity) {
            this.arrayInt = new ArrayInt(capacity);
        }

        public IntArrayResult(int[] initialValues) {
            this.arrayInt = new ArrayInt(initialValues);
        }

        public IntArrayResult(ArrayInt values) {
            this.arrayInt = values;
        }

        public void add(int id) {
            this.arrayInt.add(id);
        }

        public void addAll(int[] ids) {
            this.arrayInt.addAll(ids);
        }

        public void addAll(IntResult intResult) {
            if (intResult instanceof IntArrayResult) {
                this.arrayInt.addAll(((IntArrayResult)intResult).arrayInt);
            } else {
                IntIterator iter = intResult.iterator();
                while (iter.hasNext()) {
                    this.arrayInt.add(iter.nextInt());
                }
            }
        }

        public int size() {
            return this.arrayInt.size();
        }

        public int[] toArray() {
            return this.arrayInt.toArray();
        }

        public boolean isEmpty() {
            return this.arrayInt.isEmpty();
        }

        public IntIterator iterator() {
            return new IntIterator(){
                int nextIndex = 0;

                public boolean hasNext() {
                    return this.nextIndex < IntArrayResult.this.arrayInt.size();
                }

                public int nextInt() {
                    return IntArrayResult.this.arrayInt.get(this.nextIndex++);
                }
            };
        }
    }

    private static interface IntIterator {
        public int nextInt();

        public boolean hasNext();
    }

    private static interface IntResult {
        public void add(int var1);

        public void addAll(int[] var1);

        public void addAll(IntResult var1);

        public int size();

        public int[] toArray();

        public boolean isEmpty();

        public IntIterator iterator();
    }

    private static class IntSetResult
    implements IntResult {
        SetInt setInt;

        public IntSetResult(int capacity) {
            this.setInt = new SetInt(capacity);
        }

        public void add(int id) {
            this.setInt.add(id);
        }

        public void addAll(int[] ids) {
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                this.setInt.add(id);
                ++n2;
            }
        }

        public void addAll(IntResult intResult) {
            IntIterator iter = intResult.iterator();
            while (iter.hasNext()) {
                this.setInt.add(iter.nextInt());
            }
        }

        public int size() {
            return this.setInt.size();
        }

        public int[] toArray() {
            return this.setInt.toArray();
        }

        public boolean isEmpty() {
            return this.setInt.isEmpty();
        }

        public IntIterator iterator() {
            return new IntIterator(){
                IteratorInt intEnum;
                {
                    this.intEnum = IntSetResult.this.setInt.iterator();
                }

                public boolean hasNext() {
                    return this.intEnum.hasNext();
                }

                public int nextInt() {
                    return this.intEnum.next();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectResultSet
    implements CustomTableResultSet {
        private static final Object NULL_VALUE = new Object();
        OQLQueryImpl source;
        Column[] columns;
        Object[] objects;

        ObjectResultSet(OQLQueryImpl source, List<Object> objects) throws SnapshotException {
            this(source, objects.toArray());
        }

        ObjectResultSet(OQLQueryImpl source, Object[] objects) throws SnapshotException {
            this.source = source;
            this.objects = objects;
            List<Query.SelectItem> selectList = source.query.getSelectClause().getSelectList();
            this.columns = new Column[selectList.size()];
            try {
                int ii = 0;
                while (ii < this.columns.length) {
                    this.columns[ii] = OQLQueryImpl.buildColumn(selectList.get(ii), this.getColumnValue(0, ii));
                    ++ii;
                }
            }
            catch (RuntimeException e) {
                throw SnapshotException.rethrow((Throwable)e);
            }
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public int getRowCount() {
            return this.objects.length;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            int index = (Integer)row;
            if (!(this.objects[index] instanceof ValueHolder)) {
                this.resolve(index);
            }
            ValueHolder holder = (ValueHolder)this.objects[index];
            if (holder.values[columnIndex] == null) {
                try {
                    this.source.ctx.setSubject(holder.subject);
                    Query.SelectItem column = this.source.query.getSelectClause().getSelectList().get(columnIndex);
                    Object v = column.getExpression().compute(this.source.ctx);
                    holder.values[columnIndex] = v == null ? NULL_VALUE : v;
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
            }
            return holder.values[columnIndex] == NULL_VALUE ? null : holder.values[columnIndex];
        }

        public IContextObjectSet getContext(Object row) {
            final int index = (Integer)row;
            if (!(this.objects[index] instanceof ValueHolder)) {
                this.resolve(index);
            }
            if (((ValueHolder)this.objects[index]).subject instanceof IObject) {
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return ((IObject)((ValueHolder)ObjectResultSet.this.objects[index]).subject).getObjectId();
                    }

                    public int[] getObjectIds() {
                        return new int[]{this.getObjectId()};
                    }

                    public String getOQL() {
                        String alias = ObjectResultSet.this.source.query.getFromClause().getAlias();
                        String alias2 = alias == null ? "" : " " + alias;
                        return "SELECT " + ObjectResultSet.this.source.query.getSelectClause().toString() + " FROM OBJECTS " + this.getObjectId() + alias2;
                    }
                };
            }
            return null;
        }

        public Object getRow(int index) {
            return index;
        }

        public String getOQLQuery() {
            return this.source.toString();
        }

        private void resolve(int index) {
            ValueHolder answer = new ValueHolder(this.objects[index], new Object[this.columns.length]);
            this.objects[index] = answer;
        }

        private static class ValueHolder {
            Object subject;
            Object[] values;

            public ValueHolder(Object subject, Object[] values) {
                this.subject = subject;
                this.values = values;
            }
        }
    }

    private static class ResultSet
    implements CustomTableResultSet {
        private static final Object NULL_VALUE = new Object();
        OQLQueryImpl source;
        Column[] columns;
        int[] objectIds;
        ValueHolder[] objects;

        public ResultSet(OQLQueryImpl source, int[] objectIds) throws SnapshotException {
            this.source = source;
            this.objectIds = objectIds;
            this.objects = new ValueHolder[objectIds.length];
            List<Query.SelectItem> selectList = source.query.getSelectClause().getSelectList();
            this.columns = new Column[selectList.size()];
            try {
                int ii = 0;
                while (ii < this.columns.length) {
                    this.columns[ii] = OQLQueryImpl.buildColumn(selectList.get(ii), this.getColumnValue(0, ii));
                    ++ii;
                }
            }
            catch (RuntimeException e) {
                throw SnapshotException.rethrow((Throwable)e);
            }
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public int getRowCount() {
            return this.objectIds.length;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            Object value;
            int index = (Integer)row;
            if (this.objects[index] == null) {
                this.objects[index] = new ValueHolder(new Object[this.columns.length]);
            }
            if (this.objects[index].values[columnIndex] == null) {
                try {
                    IObject object = this.source.ctx.getSnapshot().getObject(this.objectIds[index]);
                    this.source.ctx.setSubject(object);
                    List<Query.SelectItem> selectList = this.source.query.getSelectClause().getSelectList();
                    Object value2 = selectList.get(columnIndex).getExpression().compute(this.source.ctx);
                    this.objects[index].values[columnIndex] = value2 != null ? value2 : NULL_VALUE;
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
            }
            return (value = this.objects[index].values[columnIndex]) == NULL_VALUE ? null : value;
        }

        public IContextObjectSet getContext(final Object row) {
            return new IContextObjectSet(){

                public int getObjectId() {
                    return ResultSet.this.objectIds[(Integer)row];
                }

                public int[] getObjectIds() {
                    return new int[]{this.getObjectId()};
                }

                public String getOQL() {
                    String alias = ResultSet.this.source.query.getFromClause().getAlias();
                    String alias2 = alias == null ? "" : " " + alias;
                    return "SELECT " + ResultSet.this.source.query.getSelectClause().toString() + " FROM OBJECTS " + this.getObjectId() + alias2;
                }
            };
        }

        public Object getRow(int index) {
            return index;
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public String getOQLQuery() {
            return this.source.query.toString();
        }

        private static class ValueHolder {
            Object[] values;

            public ValueHolder(Object[] values) {
                this.values = values;
            }
        }
    }

    private static class UnionResultSet
    implements IOQLQuery.Result,
    IResultTable {
        int size = 0;
        List<CustomTableResultSet> resultSets = new ArrayList<CustomTableResultSet>();
        ArrayInt sizes = new ArrayInt(5);

        private UnionResultSet() {
        }

        public void addResultSet(CustomTableResultSet resultSet) {
            this.sizes.add(this.size);
            this.size += resultSet.getRowCount();
            this.resultSets.add(resultSet);
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public Column[] getColumns() {
            return this.resultSets.get(0).getColumns();
        }

        public int getRowCount() {
            return this.size;
        }

        public Object getRow(int index) {
            int ii = this.findPageFor(index);
            IResultTable rs = this.resultSets.get(ii);
            Object value = rs.getRow(index - this.sizes.get(ii));
            return new ValueHolder(rs, value);
        }

        public Object getColumnValue(Object row, int columnIndex) {
            ValueHolder holder = (ValueHolder)row;
            return holder.source.getColumnValue(holder.row, columnIndex);
        }

        public IContextObject getContext(Object row) {
            ValueHolder holder = (ValueHolder)row;
            return holder.source.getContext(holder.row);
        }

        private int findPageFor(int rowNo) {
            int pageIndex = 0;
            while (pageIndex + 1 < this.sizes.size() && rowNo >= this.sizes.get(pageIndex + 1)) {
                ++pageIndex;
            }
            return pageIndex;
        }

        public String getOQLQuery() {
            StringBuilder buf = new StringBuilder();
            for (IOQLQuery.Result result : this.resultSets) {
                OQL.union((StringBuilder)buf, (String)result.getOQLQuery());
            }
            return buf.toString();
        }

        private static class ValueHolder {
            IResultTable source;
            Object row;

            public ValueHolder(IResultTable source, Object row) {
                this.source = source;
                this.row = row;
            }
        }
    }
}

