/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.ISmartFieldModel;
import org.eclipse.swt.graphics.Image;

public class LanguageSmartFieldModel
implements ISmartFieldModel {
    private final List<Locale> m_locales;

    public LanguageSmartFieldModel() {
        String[] isoLanguages = Locale.getISOLanguages();
        ArrayList<Locale> locs = new ArrayList<Locale>(isoLanguages.length);
        String[] stringArray = isoLanguages;
        int n = isoLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            String isoLang = stringArray[n2];
            locs.add(new Locale(isoLang));
            ++n2;
        }
        this.m_locales = locs;
    }

    @Override
    public Image getImage(Object item) {
        return NlsCore.getImage("comment");
    }

    @Override
    public List<Object> getProposals(String pattern) {
        TreeMap<String, Locale> props = new TreeMap<String, Locale>();
        for (Locale l : this.m_locales) {
            if (!l.getDisplayLanguage().toLowerCase().startsWith(pattern.toLowerCase())) continue;
            props.put(this.getText(l), l);
        }
        return new ArrayList<Object>(props.values());
    }

    @Override
    public String getText(Object item) {
        if (item == null) {
            return "";
        }
        Locale loc = (Locale)item;
        String ds = loc.getDisplayLanguage();
        String l = loc.getLanguage();
        StringBuilder b = new StringBuilder(ds.length() + l.length() + 3);
        b.append(ds);
        b.append(" (");
        b.append(l);
        b.append(')');
        return b.toString();
    }
}

