/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.util;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.scout.sdk.core.util.SdkLog;

public final class CodeTemplateContextBridge {
    private static Class<?> codeTemplateContextClass;

    private CodeTemplateContextBridge() {
    }

    public static TemplateContext createCodeTemplateContext(String contextTypeName, IJavaProject project, String lineDelim) {
        try {
            return (TemplateContext)CodeTemplateContextBridge.getCodeTemplateContextClass().getConstructor(String.class, IJavaProject.class, String.class).newInstance(contextTypeName, project, lineDelim);
        }
        catch (Throwable e) {
            SdkLog.error((Object[])new Object[]{e});
            return null;
        }
    }

    private static Class<?> getCodeTemplateContextClass() {
        Class<?> ret = codeTemplateContextClass;
        if (ret == null) {
            try {
                ret = CodeTemplateContextBridge.class.getClassLoader().loadClass("org.eclipse.jdt.internal.core.manipulation.CodeTemplateContext");
            }
            catch (ClassNotFoundException e) {
                ret = CodeTemplateContextBridge.loadLegacyCodeTemplateContextClass();
            }
            codeTemplateContextClass = ret;
        }
        return ret;
    }

    private static Class<?> loadLegacyCodeTemplateContextClass() {
        try {
            return CodeTemplateContextBridge.class.getClassLoader().loadClass("org.eclipse.jdt.internal.corext.template.java.CodeTemplateContext");
        }
        catch (ClassNotFoundException e1) {
            SdkLog.error((String)"Could not found a CodeTemplateContext class on classpath.", (Object[])new Object[0]);
            return null;
        }
    }
}

