/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.CVSActionSelectionProperties;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.internal.ui.dialogs.IPromptCondition;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.ide.IDE;

public abstract class CVSAction
extends TeamAction
implements IEditorActionDelegate {
    private List accumulatedStatus = new ArrayList();
    private RetargetAction retargetAction;
    private IAction action;

    private void initializeRetargetAction(IWorkbenchWindow window) {
        this.retargetAction = new RetargetAction(this.getId(), "");
        this.retargetAction.addPropertyChangeListener(event -> {
            if (event.getProperty().equals("enabled")) {
                Object val1 = event.getNewValue();
                if (val1 instanceof Boolean && this.action != null) {
                    this.action.setEnabled(((Boolean)val1).booleanValue());
                }
            } else if (event.getProperty().equals("checked")) {
                Object val2 = event.getNewValue();
                if (val2 instanceof Boolean && this.action != null) {
                    this.action.setChecked(((Boolean)val2).booleanValue());
                }
            } else if (event.getProperty().equals("text")) {
                Object val3 = event.getNewValue();
                if (val3 instanceof String && this.action != null) {
                    this.action.setText((String)val3);
                }
            } else if (event.getProperty().equals("toolTipText")) {
                Object val4 = event.getNewValue();
                if (val4 instanceof String && this.action != null) {
                    this.action.setToolTipText((String)val4);
                }
            } else if (event.getProperty().equals("org.eclipse.ui.internal.actionHandlers") && this.action != null && this.retargetAction != null) {
                this.action.setEnabled(this.retargetAction.isEnabled());
            }
        });
        window.getPartService().addPartListener((IPartListener)this.retargetAction);
        IWorkbenchPart activePart = window.getPartService().getActivePart();
        if (activePart != null) {
            this.retargetAction.partActivated(activePart);
        }
    }

    public final void run(IAction action) {
        try {
            if (!this.beginExecution(action)) {
                return;
            }
            if (this.retargetAction != null && this.retargetAction.getActionHandler() != null) {
                this.retargetAction.run();
            } else {
                this.execute(action);
            }
            this.endExecution();
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {
            this.handle(null);
        }
        catch (TeamException e) {
            this.handle((Exception)((Object)e));
        }
    }

    public String getId() {
        return "";
    }

    public void init(IWorkbenchWindow window) {
        super.init(window);
        this.initializeRetargetAction(window);
    }

    public boolean isEnabled() {
        if (this.retargetAction != null && this.retargetAction.getActionHandler() != null) {
            return this.retargetAction.isEnabled();
        }
        return false;
    }

    public void dispose() {
        IPartService partService;
        super.dispose();
        IWorkbenchWindow window = this.getWindow();
        if (window != null && (partService = window.getPartService()) != null) {
            partService.removePartListener((IPartListener)this.retargetAction);
        }
        if (this.retargetAction != null) {
            this.retargetAction.dispose();
            this.retargetAction = null;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TextSelection) {
            IEditorPart part;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart iEditorPart = part = activePage != null ? activePage.getActiveEditor() : null;
            if (part != null) {
                IEditorInput input = part.getEditorInput();
                ResourceMapping mapping = Utils.getResourceMapping((Object)input);
                if (mapping != null) {
                    selection = new StructuredSelection((Object)mapping);
                } else {
                    IResource resource = Utils.getResource((Object)input);
                    if (resource != null) {
                        selection = new StructuredSelection((Object)resource);
                    }
                }
            }
        }
        super.selectionChanged(action, selection);
        this.action = action;
    }

    protected void setActionEnablement(IAction action) {
        if (this.retargetAction != null && this.retargetAction.getActionHandler() != null) {
            action.setEnabled(this.retargetAction.isEnabled());
        } else {
            super.setActionEnablement(action);
        }
    }

    protected boolean beginExecution(IAction action) throws TeamException {
        this.accumulatedStatus.clear();
        return !this.needsToSaveDirtyEditors() || this.saveAllEditors();
    }

    protected void endExecution() throws TeamException {
        if (!this.accumulatedStatus.isEmpty()) {
            this.handle(null);
        }
    }

    protected void addStatus(IStatus status) {
        this.accumulatedStatus.add(status);
    }

    protected IStatus[] getAccumulatedStatus() {
        return this.accumulatedStatus.toArray(new IStatus[this.accumulatedStatus.size()]);
    }

    protected String getErrorTitle() {
        return CVSUIMessages.CVSAction_errorTitle;
    }

    protected String getWarningTitle() {
        return CVSUIMessages.CVSAction_warningTitle;
    }

    protected String getMultiStatusMessage() {
        return CVSUIMessages.CVSAction_multipleProblemsMessage;
    }

    protected IStatus getStatusToDisplay(IStatus[] problems) {
        if (problems.length == 1) {
            return problems[0];
        }
        MultiStatus combinedStatus = new MultiStatus("org.eclipse.team.cvs.ui", 0, this.getMultiStatusMessage(), null);
        int i = 0;
        while (i < problems.length) {
            combinedStatus.merge(problems[i]);
            ++i;
        }
        return combinedStatus;
    }

    protected void handle(Exception exception) {
        ArrayList<IStatus> problems = new ArrayList<IStatus>();
        IStatus[] status = this.getAccumulatedStatus();
        if (status != null) {
            int i = 0;
            while (i < status.length) {
                IStatus iStatus = status[i];
                if (!iStatus.isOK() || iStatus.getCode() == -10) {
                    problems.add(iStatus);
                }
                ++i;
            }
        }
        if (problems.size() == 0) {
            if (exception == null) {
                return;
            }
            this.handle(exception, this.getErrorTitle(), null);
            return;
        }
        if (exception != null) {
            this.handle(exception, this.getErrorTitle(), null);
        }
        String message = null;
        IStatus statusToDisplay = this.getStatusToDisplay(problems.toArray(new IStatus[problems.size()]));
        if (statusToDisplay.isOK()) {
            return;
        }
        if (statusToDisplay.isMultiStatus() && statusToDisplay.getChildren().length == 1) {
            message = statusToDisplay.getMessage();
            statusToDisplay = statusToDisplay.getChildren()[0];
        }
        String title = statusToDisplay.getSeverity() == 4 ? this.getErrorTitle() : this.getWarningTitle();
        CVSUIPlugin.openError(this.getShell(), title, message, new CVSException(statusToDisplay));
    }

    protected final void run(IRunnableWithProgress runnable, boolean cancelable, int progressKind) throws InvocationTargetException, InterruptedException {
        Exception[] exceptions = new Exception[1];
        IRunnableWithProgress innerRunnable = monitor -> this.getRepositoryManager().run(runnable, monitor);
        switch (progressKind) {
            case 2: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), () -> {
                    try {
                        innerRunnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e1) {
                        exceptionArray[0] = e1;
                    }
                    catch (InterruptedException e2) {
                        exceptionArray[0] = e2;
                    }
                });
                break;
            }
            default: {
                new ProgressMonitorDialog(this.getShell()).run(cancelable, cancelable, innerRunnable);
            }
        }
        if (exceptions[0] != null) {
            if (exceptions[0] instanceof InvocationTargetException) {
                throw (InvocationTargetException)exceptions[0];
            }
            throw (InterruptedException)exceptions[0];
        }
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected ICVSResource[] getSelectedCVSResources() {
        ArrayList<Object> resources = null;
        IStructuredSelection selection = this.getSelection();
        if (!selection.isEmpty()) {
            resources = new ArrayList<Object>();
            for (Object next : selection) {
                IAdaptable a;
                Object adapter;
                if (next instanceof ICVSResource) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable) || !((adapter = (a = (IAdaptable)next).getAdapter(ICVSResource.class)) instanceof ICVSResource)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            return resources.toArray(new ICVSResource[resources.size()]);
        }
        return new ICVSResource[0];
    }

    protected ICVSRemoteFolder[] getSelectedRemoteFolders() {
        ArrayList<Object> resources = null;
        IStructuredSelection selection = this.getSelection();
        if (!selection.isEmpty()) {
            resources = new ArrayList<Object>();
            for (Object next : selection) {
                IAdaptable a;
                Object adapter;
                if (next instanceof ICVSRemoteFolder) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable) || !((adapter = (a = (IAdaptable)next).getAdapter(ICVSRemoteFolder.class)) instanceof ICVSRemoteFolder)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            return resources.toArray(new ICVSRemoteFolder[resources.size()]);
        }
        return new ICVSRemoteFolder[0];
    }

    protected ICVSRemoteResource[] getSelectedRemoteResources() {
        ArrayList<Object> resources = null;
        IStructuredSelection selection = this.getSelection();
        if (!selection.isEmpty()) {
            resources = new ArrayList<Object>();
            for (Object next : selection) {
                IAdaptable a;
                Object adapter;
                if (next instanceof ICVSRemoteResource) {
                    resources.add(next);
                    continue;
                }
                if (next instanceof CVSFileRevision) {
                    resources.add(((CVSFileRevision)next).getCVSRemoteFile());
                    continue;
                }
                if (next instanceof ILogEntry) {
                    resources.add(((ILogEntry)next).getRemoteFile());
                    continue;
                }
                if (!(next instanceof IAdaptable) || !((adapter = (a = (IAdaptable)next).getAdapter(ICVSRemoteResource.class)) instanceof ICVSRemoteResource)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            ICVSRemoteResource[] result = new ICVSRemoteResource[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new ICVSRemoteResource[0];
    }

    public static IPromptCondition getOverwriteLocalChangesPrompt(IResource[] dirtyResources) {
        return new IPromptCondition(dirtyResources){
            List resources;
            {
                this.resources = Arrays.asList(iResourceArray);
            }

            public boolean needsPrompt(IResource resource) {
                return this.resources.contains(resource);
            }

            public String promptMessage(IResource resource) {
                return NLS.bind((String)CVSUIMessages.ReplaceWithAction_localChanges, (Object[])new String[]{resource.getName()});
            }
        };
    }

    public static boolean checkForMixingTags(Shell shell, IResource[] resources, CVSTag tag) throws CVSException {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        if (!store.getBoolean("pref_prompt_on_mixed_tags")) {
            return true;
        }
        boolean[] result = new boolean[]{true};
        int i = 0;
        while (i < resources.length) {
            ICVSResource cvsResource;
            CVSEntryLineTag parentTag;
            IResource resource = resources[i];
            if (resource.getType() != 4 && !CVSTag.equalTags((CVSTag)tag, (CVSTag)(parentTag = (cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource)).getParent().getFolderSyncInfo().getTag())) && !CVSTag.equalTags((CVSTag)tag, (CVSTag)CVSTag.BASE)) {
                shell.getDisplay().syncExec(() -> {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)CVSUIMessages.CVSAction_mixingTagsTitle, (String)NLS.bind((String)CVSUIMessages.CVSAction_mixingTags, (Object[])new String[]{tag.getName()}), (String)CVSUIMessages.CVSAction_doNotShowThisAgain, (boolean)false, (IPreferenceStore)store, (String)"pref_prompt_on_mixed_tags");
                    blArray[0] = dialog.getReturnCode() == 0;
                });
                break;
            }
            ++i;
        }
        return result[0];
    }

    private boolean saveAllEditors() {
        int option = CVSUIPlugin.getPlugin().getPreferenceStore().getInt("pref_save_dirty_editors");
        boolean[] okToContinue = new boolean[]{true};
        if (option != 1) {
            Display.getDefault().syncExec(() -> {
                boolean confirm = option == 2;
                IResource[] selectedResources = this.getSelectedResources();
                if (selectedResources != null) {
                    blArray[0] = IDE.saveAllEditors((IResource[])selectedResources, (boolean)confirm);
                }
            });
        }
        return okToContinue[0];
    }

    protected void handle(Exception exception, String title, String message) {
        CVSUIPlugin.openError(this.getShell(), title, message, exception, 12);
    }

    protected RepositoryManager getRepositoryManager() {
        return CVSUIPlugin.getPlugin().getRepositoryManager();
    }

    protected final IResource[] getSelectedResourcesWithOverlap() {
        IStructuredSelection selection = this.getSelection();
        CVSActionSelectionProperties props = CVSActionSelectionProperties.getProperties(this.getSelection());
        if (props == null) {
            return Utils.getContributedResources((Object[])selection.toArray());
        }
        return props.getAllSelectedResources();
    }

    protected final IResource[] getSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        CVSActionSelectionProperties props = CVSActionSelectionProperties.getProperties(this.getSelection());
        if (props == null) {
            return CVSActionSelectionProperties.getNonOverlapping(Utils.getContributedResources((Object[])selection.toArray()));
        }
        return props.getNonoverlappingSelectedResources();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public boolean isHandled() {
        return true;
    }

    protected final ICVSResource getCVSResourceFor(IResource resource) {
        CVSActionSelectionProperties props = CVSActionSelectionProperties.getProperties(this.getSelection());
        if (props == null) {
            return CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        }
        return props.getCVSResourceFor(resource);
    }

    public static CVSTag getAccurateFileTag(ICVSResource cvsResource) throws CVSException {
        CVSTag tag = null;
        if (cvsResource != null) {
            return Util.getAccurateFileTag((ICVSResource)cvsResource, (CVSTag[])CVSAction.getTags(cvsResource));
        }
        return tag;
    }

    public static CVSTag[] getTags(ICVSResource cvsResource) {
        TagSource tagSource = TagSource.create(new ICVSResource[]{cvsResource});
        return tagSource.getTags(TagSource.convertIncludeFlaqsToTagTypes(31));
    }
}

