/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.ui.modelconnector.IModelConnector;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 * @since 1.4
 */
@SuppressWarnings("all")
public class ShowMatchLocationHandler extends AbstractHandler {
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    final ISelection selection = HandlerUtil.getCurrentSelection(event);
    final IViewPart resultView = HandlerUtil.getActiveSite(event).getPage().findView(QueryResultView.ID);
    if ((resultView instanceof QueryResultView)) {
      final boolean active = ((QueryResultView)resultView).hasActiveEngine();
      if ((active && (selection instanceof IStructuredSelection))) {
        final IModelConnector connector = ((QueryResultView)resultView).getModelConnector();
        if ((connector != null)) {
          final HashSet<EObject> eObjectsInSelection = CollectionLiterals.<EObject>newHashSet();
          final Procedure1<Object> _function = (Object it) -> {
            boolean _matched = false;
            if (it instanceof IPatternMatch) {
              _matched=true;
              Iterables.<EObject>addAll(eObjectsInSelection, Iterables.<EObject>filter(((Iterable<?>)Conversions.doWrapArray(((IPatternMatch)it).toArray())), EObject.class));
            }
            if (!_matched) {
              if (it instanceof EObject) {
                _matched=true;
                eObjectsInSelection.add(((EObject)it));
              }
            }
            if (!_matched) {
            }
          };
          IteratorExtensions.<Object>forEach(((IStructuredSelection) selection).iterator(), _function);
          connector.showLocation(((Object[])Conversions.unwrapArray(eObjectsInSelection, Object.class)));
        }
      }
    }
    return null;
  }
}
