/*******************************************************************************
 * Copyright (c) 2004-2010 Gabor Bergmann and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabor Bergmann - initial API and implementation
 *******************************************************************************/

package org.eclipse.viatra.query.runtime.rete.construction.quasitree;

import java.util.Comparator;

import org.eclipse.viatra.query.runtime.rete.util.Options;
import org.eclipse.viatra.query.runtime.rete.util.OrderingCompareAgent;

/**
 * @author Gabor Bergmann
 * 
 */
public class JoinOrderingHeuristics implements Comparator<JoinCandidate> {

    @Override
    public int compare(JoinCandidate jc1, JoinCandidate jc2) {
        return new OrderingCompareAgent<JoinCandidate>(jc1, jc2) {
            @Override
            protected void doCompare() {
                swallowBoolean(true && consider(preferTrue(a.isTrivial(), b.isTrivial()))
                        && consider(preferTrue(a.isSubsumption(), b.isSubsumption()))
                        && consider(preferTrue(a.isCheckOnly(), b.isCheckOnly()))
                        && consider( 
                                Options.functionalDependencyOption == Options.FunctionalDependencyOption.OFF ?
                                dontCare() :
                                preferTrue(a.isHeath(), b.isHeath())
                            )
                        && consider(preferFalse(a.isDescartes(), b.isDescartes()))

                        // TODO main heuristic decisions

                        // tie breaking
                        && consider(preferLess(a.getConsPrimary(), b.getConsPrimary(), TieBreaker.CONSTRAINT_LIST_COMPARATOR))
                        && consider(preferLess(a.getConsSecondary(), b.getConsSecondary(), TieBreaker.CONSTRAINT_LIST_COMPARATOR))
                        && consider(preferLess(System.identityHashCode(a), System.identityHashCode(b))));
            }
        }.compare();

    }

}