/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.ui.internal.notification;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public final class ImageCache {
    private static HashMap<String, Image> imageMap = new HashMap();
    private static final String ICON_ROOT_PATH = "/";

    private ImageCache() {
    }

    public static Image getImage(String fileName) {
        String iconName = ICON_ROOT_PATH + fileName;
        Image image = imageMap.get(iconName);
        if (image == null) {
            image = ImageCache.createImage(iconName);
            imageMap.put(iconName, image);
        }
        return image;
    }

    private static Image createImage(String fileName) {
        ClassLoader classLoader = ImageCache.class.getClassLoader();
        InputStream is = classLoader.getResourceAsStream(fileName);
        if (is == null && (is = classLoader.getResourceAsStream(fileName.substring(1))) == null && (is = classLoader.getResourceAsStream(fileName)) == null) {
            is = classLoader.getResourceAsStream(fileName.substring(1));
        }
        Image img = null;
        if (is != null) {
            img = new Image((Device)Display.getDefault(), is);
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.acceleo.help");
            URL entry = bundle.getEntry(fileName);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)entry);
            img = imageDescriptor.createImage();
        }
        return img;
    }

    public static void dispose() {
        Iterator<Image> e = imageMap.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }
}

