/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.importexport.impl;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfstore.internal.client.importexport.IExportImportController;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.Messages;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;

public class ImportChangesController
implements IExportImportController {
    private final ProjectSpaceBase projectSpace;

    public ImportChangesController(ProjectSpaceBase projectSpace) {
        this.projectSpace = projectSpace;
    }

    public String getLabel() {
        return Messages.ImportChangesController_Changes;
    }

    public String[] getFilteredNames() {
        return new String[]{MessageFormat.format(Messages.ImportChangesController_ChangePackageFileType_Filter, ExportImportDataUnits.Change.getExtension()), Messages.ImportChangesController_AllFilesFilter};
    }

    public String[] getFilteredExtensions() {
        return new String[]{"*" + ExportImportDataUnits.Change.getExtension(), "*.*"};
    }

    public String getParentFolderPropertyKey() {
        return null;
    }

    public void execute(File file, IProgressMonitor progressMonitor) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createFileURI((String)file.getAbsolutePath()), true);
        EList directContents = resource.getContents();
        if (directContents.size() != 1 && !(directContents.get(0) instanceof ChangePackage)) {
            throw new IOException(Messages.ImportChangesController_CorruptFile);
        }
        AbstractChangePackage changePackage = (AbstractChangePackage)directContents.get(0);
        ESCloseableIterable operations = changePackage.operations();
        try {
            this.projectSpace.applyOperations(operations.iterable(), true);
        }
        finally {
            operations.close();
        }
    }

    public String getFilename() {
        return null;
    }

    public boolean isExport() {
        return false;
    }
}

