/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.core.utils;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.alm.mylyn.core.Activator;
import org.eclipse.jubula.client.alm.mylyn.core.bp.CommentReporter;
import org.eclipse.jubula.client.alm.mylyn.core.i18n.Messages;
import org.eclipse.jubula.client.alm.mylyn.core.model.ALMChange;
import org.eclipse.jubula.client.alm.mylyn.core.model.CommentEntry;
import org.eclipse.jubula.client.alm.mylyn.core.model.FieldUpdate;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.SimpleStringConverter;
import org.eclipse.jubula.client.core.utils.VariableToken;
import org.eclipse.jubula.mylyn.utils.MylynAccess;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskDataManager;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ALMAccess {
    private static final Logger LOG = LoggerFactory.getLogger(ALMAccess.class);
    private static final String VARIABLE_DATE_POSTFIX = "date";
    private static final String VARIABLE_URL_POSTFIX = "url";
    private static final String VARIABLE_SUMMARY_PREFIX = "summary";
    private static final String VARIABLE_NODE_PREFIX = "node";

    private ALMAccess() {
    }

    public static boolean createComment(String repoLabel, String taskId, List<CommentEntry> comments, IProgressMonitor monitor) {
        boolean succeeded = false;
        TaskRepository repo = MylynAccess.getRepositoryByLabel((String)repoLabel);
        try {
            TaskData taskData = MylynAccess.getTaskDataByID((TaskRepository)repo, (String)taskId, (IProgressMonitor)monitor);
            if (taskData == null) {
                return succeeded;
            }
            String connectorKind = repo.getConnectorKind();
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)connectorKind);
            ITask task = MylynAccess.getTaskByID((TaskRepository)repo, (String)taskData.getTaskId(), (IProgressMonitor)monitor);
            if (task != null) {
                ITaskDataManager taskDataManager = TasksUi.getTaskDataManager();
                ITaskDataWorkingCopy taskWorkingCopy = taskDataManager.createWorkingCopy(task, taskData);
                TaskDataModel taskModel = new TaskDataModel(repo, task, taskWorkingCopy);
                TaskAttribute rootData = taskModel.getTaskData().getRoot();
                MylynAccess.CONNECTOR handle = ALMAccess.determineConnectorHandling(connectorKind);
                TaskAttribute change = null;
                switch (handle) {
                    case HP_ALM: {
                        change = ALMAccess.hpAlmCommentHandling(comments, rootData);
                        break;
                    }
                    default: {
                        change = ALMAccess.defaultCommentHandling(comments, rootData);
                    }
                }
                if (change == null) {
                    return succeeded;
                }
                AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
                RepositoryResponse response = taskDataHandler.postTaskData(taskModel.getTaskRepository(), taskModel.getTaskData(), taskModel.getChangedOldAttributes(), monitor);
                succeeded = RepositoryResponse.ResponseKind.TASK_UPDATED.equals((Object)response.getReposonseKind());
            }
        }
        catch (CoreException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return succeeded;
    }

    public static IStatus updateFields(String repoLabel, String taskId, List<FieldUpdate> fieldUpdates, IProgressMonitor monitor) {
        Status status;
        try {
            TaskRepository repo = MylynAccess.getRepositoryByLabel((String)repoLabel);
            status = MylynAccess.updateAttributes((TaskRepository)repo, (String)taskId, ALMAccess.attributeUpdateMapping(fieldUpdates), (IProgressMonitor)monitor);
        }
        catch (CouldNotResolveException couldNotResolveException) {
            status = new Status(8, "org.eclipse.jubula.client.alm.mylyn.core", "Could not resolve variable");
        }
        return status;
    }

    private static List<Map<String, String>> attributeUpdateMapping(List<FieldUpdate> fieldUpdates) throws CouldNotResolveException {
        ArrayList<Map<String, String>> attributeUpdates = new ArrayList<Map<String, String>>(fieldUpdates.size());
        boolean failed = false;
        for (FieldUpdate u : fieldUpdates) {
            Map<String, String> attributesToChange = u.getAttributesToChange();
            for (String key : attributesToChange.keySet()) {
                String value = attributesToChange.get(key);
                try {
                    value = ALMAccess.getVariableValues(value, u);
                    attributesToChange.put(key, value);
                }
                catch (CouldNotResolveException couldNotResolveException) {
                    failed = true;
                }
            }
            attributeUpdates.add(attributesToChange);
        }
        if (failed) {
            throw new CouldNotResolveException();
        }
        return attributeUpdates;
    }

    private static String getVariableValues(String value, FieldUpdate fieldUpdate) throws CouldNotResolveException {
        boolean isFailing = false;
        if (StringUtils.isNotBlank((String)value)) {
            SimpleStringConverter converter = new SimpleStringConverter(value);
            if (converter.containsErrors()) {
                CommentReporter.getInstance().getConsole().writeErrorLine(NLS.bind((String)Messages.ParsingReportingRuledFailed, (Object)value));
                throw new CouldNotResolveException(NLS.bind((String)Messages.ParsingReportingRuledFailed, (Object)value));
            }
            List liste = converter.getTokens();
            String result = "";
            for (IParamValueToken iParamValueToken : liste) {
                if (iParamValueToken instanceof VariableToken) {
                    try {
                        result = String.valueOf(result) + ALMAccess.getBeanString(fieldUpdate, (VariableToken)iParamValueToken);
                    }
                    catch (CouldNotResolveException couldNotResolveException) {
                        isFailing = true;
                    }
                    continue;
                }
                result = String.valueOf(result) + iParamValueToken.getGuiString();
            }
            if (isFailing) {
                throw new CouldNotResolveException();
            }
            return result;
        }
        return value;
    }

    private static TaskAttribute hpAlmCommentHandling(List<CommentEntry> comments, TaskAttribute attr) {
        Properties almProps = Activator.getDefault().getAlmAccessProperties();
        String hpTaskKindKeyPrefix = String.valueOf(MylynAccess.CONNECTOR.HP_ALM.toString()) + "." + "task.common.kind";
        String req = String.valueOf(hpTaskKindKeyPrefix) + ".REQUIREMENT";
        String hpTaskKindReq = almProps.getProperty(req);
        String def = String.valueOf(hpTaskKindKeyPrefix) + ".DEFECT";
        String hpTaskKindDefect = almProps.getProperty(def);
        String taskKindValue = attr.getMappedAttribute("task.common.kind").getValue();
        String attrName = null;
        if (hpTaskKindReq.equals(taskKindValue)) {
            attrName = almProps.getProperty(String.valueOf(req) + ".comment");
        } else if (hpTaskKindDefect.equals(taskKindValue)) {
            attrName = almProps.getProperty(String.valueOf(def) + ".comment");
        }
        if (attrName != null) {
            TaskAttribute commentAttribute = attr.getMappedAttribute(attrName);
            String oldComment = commentAttribute.getValue();
            String newComment = "";
            for (ALMChange aLMChange : comments) {
                newComment = String.valueOf(aLMChange.toString()) + "<br>" + aLMChange.getDashboardURL() + "<br>" + newComment;
            }
            commentAttribute.setValue(String.valueOf(newComment) + oldComment);
            return commentAttribute;
        }
        return null;
    }

    private static TaskAttribute defaultCommentHandling(List<CommentEntry> comments, TaskAttribute attr) {
        TaskAttribute newComment = attr.createMappedAttribute("task.common.comment.new");
        String comment = "";
        for (CommentEntry c : comments) {
            comment = String.valueOf(comment) + "\n" + c.toString() + "\n" + c.getDashboardURL() + "\n" + "\n";
        }
        newComment.setValue(comment);
        return newComment;
    }

    private static MylynAccess.CONNECTOR determineConnectorHandling(String connectorKind) {
        String hpAlmConnectorKind = Activator.getDefault().getAlmAccessProperties().getProperty(MylynAccess.CONNECTOR.HP_ALM.toString());
        if (hpAlmConnectorKind.equals(connectorKind)) {
            return MylynAccess.CONNECTOR.HP_ALM;
        }
        return MylynAccess.CONNECTOR.DEFAULT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getBeanString(FieldUpdate fieldUpdate, VariableToken variable) throws CouldNotResolveException {
        String returnValue = variable.getVariableString();
        if (StringUtils.contains((String)returnValue, (char)'_')) {
            String[] strings = StringUtils.split((String)returnValue, (String)"_", (int)2);
            try {
                if (strings[0].equalsIgnoreCase(VARIABLE_NODE_PREFIX)) {
                    returnValue = strings[1].equalsIgnoreCase(VARIABLE_URL_POSTFIX) ? fieldUpdate.getDashboardURL() : (strings[1].equalsIgnoreCase(VARIABLE_DATE_POSTFIX) ? ALMAccess.formatDate(fieldUpdate.getNode().getTimeStamp()) : BeanUtils.getProperty((Object)fieldUpdate.getNode(), (String)strings[1]));
                }
                if (!strings[0].equalsIgnoreCase(VARIABLE_SUMMARY_PREFIX)) return returnValue;
                if (!strings[1].equalsIgnoreCase(VARIABLE_DATE_POSTFIX)) return BeanUtils.getProperty((Object)fieldUpdate.getSummary(), (String)strings[1]);
                return ALMAccess.formatDate(fieldUpdate.getSummary().getTestsuiteDate());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                CommentReporter.getInstance().getConsole().writeErrorLine(NLS.bind((String)Messages.UnresolvableVariable, (Object)variable.getGuiString()));
                throw new CouldNotResolveException(variable.getGuiString());
            }
        }
        returnValue = variable.getGuiString();
        CommentReporter.getInstance().getConsole().writeErrorLine(NLS.bind((String)Messages.UnresolvableVariable, (Object)variable.getGuiString()));
        throw new CouldNotResolveException(variable.getGuiString());
    }

    private static String formatDate(Date date) {
        return new SimpleDateFormat("dd.MM.yyyy").format(date);
    }

    public static class CouldNotResolveException
    extends Exception {
        public CouldNotResolveException() {
        }

        public CouldNotResolveException(String message) {
            super(message);
        }
    }
}

