/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.collectionextract.HashedMapCollectionExtractorBase;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class ConcurrentSkipListCollectionExtractor
extends HashedMapCollectionExtractorBase {
    public ConcurrentSkipListCollectionExtractor(String arrayField, String keyField, String valueField) {
        super(arrayField, keyField, valueField);
    }

    public boolean hasExtractableContents() {
        return true;
    }

    public boolean hasExtractableArray() {
        return false;
    }

    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        return null;
    }

    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        ArrayInt entries = new ArrayInt();
        ISnapshot snapshot = coll.getSnapshot();
        int tableId = this.getTableId(coll);
        if (tableId != -1) {
            int[] nArray = snapshot.getOutboundReferentIds(tableId);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int outbound = nArray[n2];
                this.collectEntriesFromTable(entries, coll.getObjectId(), outbound, snapshot);
                ++n2;
            }
        }
        return entries.toArray();
    }

    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        return this.extractEntryIds(coll).length;
    }

    public boolean hasCapacity() {
        return false;
    }

    public Integer getCapacity(IObject coll) throws SnapshotException {
        return null;
    }

    public boolean hasSize() {
        return true;
    }

    public Integer getSize(IObject coll) throws SnapshotException {
        return this.getMapSize(coll, this.extractEntryIds(coll));
    }

    public boolean hasFillRatio() {
        return false;
    }

    public Double getFillRatio(IObject coll) throws SnapshotException {
        return null;
    }

    public Double getCollisionRatio(IObject coll) throws SnapshotException {
        return 0.0;
    }

    private int getTableId(IObject coll) throws SnapshotException {
        IObject arr = (IObject)coll.resolveValue(this.arrayField);
        if (arr == null) {
            return -1;
        }
        return arr.getObjectId();
    }
}

