/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.container;

import java.util.Arrays;
import java.util.List;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.ValidationContext;
import org.eclipse.net4j.util.ui.container.IElementWizard;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementWizard
extends Notifier
implements IElementWizard,
ValidationContext {
    private IManagedContainer container;
    private String productGroup;
    private String factoryType;
    private String defaultDescription;
    private String resultDescription;
    private ValidationContext context;

    protected IManagedContainer getContainer() {
        return this.container;
    }

    protected String getProductGroup() {
        return this.productGroup;
    }

    protected String getFactoryType() {
        return this.factoryType;
    }

    protected String getDefaultDescription() {
        return this.defaultDescription;
    }

    @Override
    public String getResultDescription() {
        return this.resultDescription;
    }

    @Override
    public Object getResultElement() {
        return this.container.getElement(this.productGroup, this.factoryType, this.resultDescription);
    }

    @Override
    public void create(Composite parent, IManagedContainer container, String productGroup, String factoryType, String defaultDescription, ValidationContext context) {
        this.container = container;
        this.productGroup = productGroup;
        this.factoryType = factoryType;
        this.defaultDescription = defaultDescription;
        this.context = context;
        this.create(parent);
    }

    protected void setResultDescription(String resultDescription) {
        String oldDescription = this.resultDescription;
        if (!ObjectUtil.equals((Object)resultDescription, (Object)oldDescription)) {
            this.resultDescription = resultDescription;
            this.fireEvent();
        }
    }

    @Override
    public void setValidationError(Object source, String message) {
        if (this.context != null) {
            this.context.setValidationError(source, message);
        }
    }

    protected abstract void create(Composite var1);

    public static Label addLabel(Composite parent, String label) {
        Label control = new Label(parent, 0);
        control.setText(label);
        control.setLayoutData((Object)UIUtil.createGridData(false, false));
        return control;
    }

    public static Text addText(Composite parent, String label) {
        ElementWizard.addLabel(parent, label);
        Text control = new Text(parent, 2048);
        control.setLayoutData((Object)UIUtil.createGridData(true, false));
        return control;
    }

    public static Combo addCombo(Composite parent, String label, List<String> choices) {
        ElementWizard.addLabel(parent, label);
        Combo control = new Combo(parent, 4);
        control.setLayoutData((Object)UIUtil.createGridData(true, false));
        for (String choice : choices) {
            control.add(choice);
        }
        return control;
    }

    public static Combo addCombo(Composite parent, String label, String ... choices) {
        return ElementWizard.addCombo(parent, label, Arrays.asList(choices));
    }
}

