/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.om.OMPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringCompressor
implements StringIO {
    public static boolean BYPASS = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.util.io.StringCompressor.BYPASS");
    private static final int NULL_ID = 0;
    private static final int INFO_FOLLOWS = Integer.MIN_VALUE;
    private static final byte NOTHING_FOLLOWS = 1;
    private static final byte STRING_FOLLOWS = 2;
    private static final byte ACK_FOLLOWS = 3;
    private static final boolean DEBUG = false;
    private static final byte DEBUG_STRING = -1;
    private static final byte DEBUG_INT = -2;
    private static final byte DEBUG_BYTE = -3;
    private boolean client;
    private int lastID;
    private Map<String, ID> stringToID = new HashMap<String, ID>();
    private Map<Integer, String> idToString = new HashMap<Integer, String>();
    private Collection<Integer> pendingAcknowledgements = StringCompressor.createAcknowledgementCollection();
    private long lastAcknowledgementCheck;

    public StringCompressor(boolean client) {
        this.client = client;
    }

    public boolean isClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ExtendedDataOutput out, String string) throws IOException {
        ID id;
        if (string == null) {
            this.writeInt(out, 0);
            return;
        }
        Collection<Integer> acknowledgements = null;
        boolean stringFollows = false;
        StringCompressor stringCompressor = this;
        synchronized (stringCompressor) {
            id = this.stringToID.get(string);
            if (id == null) {
                this.lastID += this.client ? 1 : -1;
                id = new ID(this.lastID);
                this.stringToID.put(string, id);
                this.idToString.put(id.getValue(), string);
                stringFollows = true;
            } else if (!id.isAcknowledged()) {
                stringFollows = true;
            }
            this.lastAcknowledgementCheck = System.currentTimeMillis();
            if (!this.pendingAcknowledgements.isEmpty()) {
                acknowledgements = this.pendingAcknowledgements;
                this.pendingAcknowledgements = StringCompressor.createAcknowledgementCollection();
            }
        }
        if (stringFollows || acknowledgements != null) {
            this.writeInt(out, Integer.MIN_VALUE);
            this.writeInt(out, id.getValue());
            if (stringFollows) {
                this.writeByte(out, (byte)2);
                this.writeString(out, string);
            }
            this.writeAcknowledgements(out, acknowledgements);
        } else {
            this.writeInt(out, id.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String read(ExtendedDataInput in) throws IOException {
        int id = this.readInt(in);
        if (id == 0) {
            return null;
        }
        String string = null;
        Collection<Integer> acks = null;
        if (id == Integer.MIN_VALUE) {
            id = this.readInt(in);
            boolean moreInfos = true;
            while (moreInfos) {
                byte info = this.readByte(in);
                switch (info) {
                    case 1: {
                        moreInfos = false;
                        break;
                    }
                    case 2: {
                        string = this.readString(in);
                        break;
                    }
                    case 3: {
                        if (acks == null) {
                            acks = StringCompressor.createAcknowledgementCollection();
                        }
                        acks.add(this.readInt(in));
                        break;
                    }
                    default: {
                        throw new IOException("Invalid info: " + info);
                    }
                }
            }
        }
        StringCompressor stringCompressor = this;
        synchronized (stringCompressor) {
            this.processAcknowledgements(acks);
            if (string != null) {
                this.stringToID.put(string, new ID(id));
                this.idToString.put(id, string);
                this.pendingAcknowledgements.add(id);
            } else {
                string = this.idToString.get(id);
                if (string == null) {
                    throw new IOException("String ID unknown: " + id);
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> getPendingAcknowledgements(long timeout) {
        Collection<Integer> acknowledgements = null;
        StringCompressor stringCompressor = this;
        synchronized (stringCompressor) {
            long now = System.currentTimeMillis();
            if (this.lastAcknowledgementCheck + timeout < now) {
                this.lastAcknowledgementCheck = now;
                if (!this.pendingAcknowledgements.isEmpty()) {
                    acknowledgements = this.pendingAcknowledgements;
                    this.pendingAcknowledgements = StringCompressor.createAcknowledgementCollection();
                }
            }
        }
        return acknowledgements;
    }

    public void writeAcknowledgements(ExtendedDataOutput out, Collection<Integer> acknowledgements) throws IOException {
        if (acknowledgements != null) {
            for (int ack : acknowledgements) {
                this.writeByte(out, (byte)3);
                this.writeInt(out, ack);
            }
        }
        this.writeByte(out, (byte)1);
    }

    public Collection<Integer> readAcknowledgements(ExtendedDataInput in) throws IOException {
        Collection<Integer> acknowledgements = StringCompressor.createAcknowledgementCollection();
        while (in.readByte() == 3) {
            acknowledgements.add(in.readInt());
        }
        return acknowledgements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAcknowledgements(Collection<Integer> acknowledgements) {
        if (acknowledgements != null) {
            StringCompressor stringCompressor = this;
            synchronized (stringCompressor) {
                for (int value : acknowledgements) {
                    ID id;
                    String string = this.idToString.get(value);
                    if (string == null || (id = this.stringToID.get(string)) == null) continue;
                    id.setAcknowledged();
                }
            }
        }
    }

    public String toString() {
        return MessageFormat.format("StringCompressor[client={0}]", this.client);
    }

    private void writeByte(ExtendedDataOutput out, byte value) throws IOException {
        out.writeByte(value);
    }

    private void writeInt(ExtendedDataOutput out, int value) throws IOException {
        out.writeInt(value);
    }

    protected void writeString(ExtendedDataOutput out, String value) throws IOException {
        out.writeString(value);
    }

    private byte readByte(ExtendedDataInput in) throws IOException {
        byte value = in.readByte();
        return value;
    }

    private int readInt(ExtendedDataInput in) throws IOException {
        int value = in.readInt();
        return value;
    }

    protected String readString(ExtendedDataInput in) throws IOException {
        String value = in.readString();
        return value;
    }

    private void trace(String prefix, Object value) {
        int opcode;
        if (value instanceof Byte) {
            opcode = ((Byte)value).byteValue();
            switch (opcode) {
                case 1: {
                    value = "NOTHING_FOLLOWS";
                    break;
                }
                case 2: {
                    value = "STRING_FOLLOWS";
                    break;
                }
                case 3: {
                    value = "STRING_FOLLOWS";
                }
            }
        }
        if (value instanceof Integer && (opcode = ((Integer)value).intValue()) == Integer.MIN_VALUE) {
            value = "INFO_FOLLOWS";
        }
        String msg = "[" + Thread.currentThread().getName() + "] " + prefix + ": " + value;
        if (!this.client) {
            msg = "                                                                   " + msg;
        }
        IOUtil.OUT().println(msg);
    }

    private static Collection<Integer> createAcknowledgementCollection() {
        return new HashSet<Integer>();
    }

    public static class Counting
    extends StringCompressor {
        private long stringsRead;
        private long stringsWritten;

        public Counting(boolean client) {
            super(client);
        }

        public long getStringsRead() {
            return this.stringsRead;
        }

        public long getStringsWritten() {
            return this.stringsWritten;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String readString(ExtendedDataInput in) throws IOException {
            Counting counting = this;
            synchronized (counting) {
                ++this.stringsRead;
            }
            return super.readString(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeString(ExtendedDataOutput out, String value) throws IOException {
            Counting counting = this;
            synchronized (counting) {
                ++this.stringsWritten;
            }
            super.writeString(out, value);
        }
    }

    private static final class ID {
        private int value;
        private boolean acknowledged;

        public ID(int value) {
            CheckUtil.checkArg(value != Integer.MIN_VALUE, "value");
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isAcknowledged() {
            return this.acknowledged;
        }

        public void setAcknowledged() {
            this.acknowledged = true;
        }
    }
}

